<?php
define('CALENDARS', [
    ['file'=>'Panchang-advanced.php','label'=>'Samvat Panchang','emoji'=>'📅','icon'=>'fa-calendar-alt','desc'=>'Complete Vedic Samvat Panchang: tithi, nakshatra & yoga.'],
    ['file'=>'panchang-advanced-fyf.php','label'=>'Monthly Panchang','emoji'=>'🌕','icon'=>'fa-calendar','desc'=>'Monthly overview with moon phases & festivals.'],
    ['file'=>'muhurat.php','label'=>'Muhurath Calendar','emoji'=>'⏰','icon'=>'fa-gem','desc'=>'Find auspicious timings for ceremonies.'],
    ['file'=>'panchang-card.php','label'=>'Daily Panchang','emoji'=>'☀️','icon'=>'fa-sun','desc'=>'Today’s tithi, nakshatra, sunrise & sunset.'],
    ['file'=>'islamic-calendar.php','label'=>'Islamic Calendar','emoji'=>'🕌','icon'=>'fa-mosque','desc'=>'Hijri dates with prayer times & events.'],
    ['file'=>'panchang-goodday-badday.php','label'=>'Good/Bad Days','emoji'=>'👍','icon'=>'fa-thumbs-up','desc'=>'Auspicious & inauspicious days at a glance.'],
    ['file'=>'astrology-calendar-fyf.php','label'=>'Astrology Calendar','emoji'=>'🔮','icon'=>'fa-star','desc'=>'Planetary transits & emoji-infused forecasts.'],
    ['file'=>'monthly-calendar-large.php','label'=>'Aspects Calendar','emoji'=>'🌠','icon'=>'fa-calendar-day','desc'=>'Upcoming astrology events, cosmic alignments & eclipses.'],
]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>FindYourFate Calendars</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pOa2XcpIycQFXalwKpWMBjXTGTdFg6vE1LlXLBg8bYbXjHf+v+I8m8h+t+0QwziG2qB6+0opNrb1DdQ+u5Fdwg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>
<body class="bg-black text-white min-h-screen flex flex-col">
  <header class="text-center py-6 px-4 flex-shrink-0">
    <p class="text-gray-400 text-lg">✨ Explore our powerful calendars—pick one to begin your journey 🌟</p>
  </header>

  <main class="px-4 pb-10 flex-1 overflow-y-auto max-h-[calc(100vh-6rem)]">
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
      <?php foreach(CALENDARS as $cal): ?>
      <a href="<?= htmlspecialchars($cal['file']); ?>" target="_blank" class="group block bg-gradient-to-br from-gray-800 to-gray-900 p-6 rounded-3xl shadow-xl hover:shadow-2xl transform hover:scale-105 transition duration-300">
        <div class="flex flex-col items-center text-center">
          <div class="text-5xl mb-3 animate-pulse"><?= $cal['emoji']; ?></div>
          <i class="fas <?= $cal['icon']; ?> text-3xl text-yellow-400 mb-2 group-hover:text-yellow-300 transition"></i>
          <h3 class="text-xl font-bold mb-1 group-hover:text-white"><?= htmlspecialchars($cal['label']); ?></h3>
          <p class="text-gray-400 text-sm group-hover:text-gray-300"><?= htmlspecialchars($cal['desc']); ?></p>
        </div>
      </a>
      <?php endforeach; ?>
    </div>
  </main>

  <footer class="text-center text-gray-600 text-sm py-6 flex-shrink-0">
    Crafted with care ❤️
  </footer>
</body>
</html>