package findyourfate.com.sanipeyarchi;
import android.annotation.SuppressLint;
import androidx.appcompat.app.ActionBar;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import androidx.viewpager.widget.ViewPager;
import android.text.Html;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;


public class MainActivity extends AppCompatActivity
		implements ActionBar.TabListener {

	int fsize;
	private ViewPager viewPager;
	private TapFragmentManager fragmentManger;
	private ActionBar actionBar;
	private String[] tabs = {"Moon Sign","Rasi","Year"};

	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		viewPager = findViewById(R.id.pager);
		fragmentManger = new TapFragmentManager(getSupportFragmentManager());
		viewPager.setAdapter(fragmentManger);
		viewPager.setOffscreenPageLimit(0);

		ActionBar actionBar = getSupportActionBar();
		if (actionBar != null) {
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_HOME | ActionBar.DISPLAY_SHOW_TITLE);
			actionBar.setTitle(Html.fromHtml("<font color=\"#ffffff\">Sani Peyarchi</font>"));
			actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

			// Set the background color for the entire ActionBar (optional)
			actionBar.setBackgroundDrawable(new ColorDrawable(Color.parseColor("#333333"))); // Off-white color

			actionBar.show();

			for (String tabName : tabs) {
				actionBar.setBackgroundDrawable(new ColorDrawable(Color.parseColor("#9A7127"))); // Off-white color

				ActionBar.Tab tab = actionBar.newTab();
				tab.setText(tabName);
				tab.setTabListener(this);

				// Customize tab background color and text color programmatically
				View customTab = LayoutInflater.from(this).inflate(R.layout.custom_tab_layout, null);
				TextView tabTextView = customTab.findViewById(R.id.custom_tab_text);
				tabTextView.setText(tabName);
				//tabTextView.setBackgroundColor(Color.parseColor("#9A7127")); // Set tab background color (off-white)
				tabTextView.setTextColor(Color.WHITE); // Set tab text color (white)

				tab.setCustomView(customTab);
				actionBar.addTab(tab);
				//actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);
				//actionBar.addTab(actionBar.newTab().setText(tab_name).setTabListener(this));
				}
		}

		viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
			@Override
			public void onPageSelected(int position) {
				actionBar.setSelectedNavigationItem(position);
			}

			@Override
			public void onPageScrolled(int arg0, float arg1, int arg2) { }

			@Override
			public void onPageScrollStateChanged(int state) { }
		});

		viewPager.setCurrentItem(0); // Set default tab
	}


	@Override
	public void onTabSelected(ActionBar.Tab tab, FragmentTransaction ft) {
		viewPager.setCurrentItem(tab.getPosition());
	}

	@Override
	public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction ft) {

	}

	@Override
	public void onTabReselected(ActionBar.Tab tab, FragmentTransaction ft) {

	}


	public class TapFragmentManager extends FragmentStatePagerAdapter {

		public TapFragmentManager(FragmentManager fm) {
			super(fm);
		}
		@Override
		public Fragment getItem(int tab_position) {

			switch (tab_position) {
				case 0:
					Fragment newFragment = new moonsign();
					return newFragment;
				case 1:
					Fragment fragment2 = new rasi();
					return fragment2;
				case 2:
					Fragment fragment4= new saniyear();
					return fragment4;
			}
			return null;
		}
		@Override
		public int getCount() {
			// TODO Auto-generated method stub
			return 3;
		}
	}


	public class WebViewPager extends ViewPager {
		public WebViewPager(Context context, AttributeSet attrs) {
			super(context, attrs);
		}


	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.main, menu);
		menu.findItem(R.id.icon_rasi).setVisible(false);
		// animation = (AnimationView) menu.findItem(R.id.character);
		return super.onCreateOptionsMenu(menu);
	}

	@SuppressLint("NewApi")
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if (item.getItemId() ==android.R.id.home) {
			Intent int_home = new Intent(this, MainActivity.class);
			int_home.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(int_home);
		}



		else if (item.getItemId() ==R.id.sani) {
			final ProgressDialog progressDoalog = new ProgressDialog(MainActivity.this);
			progressDoalog.setProgressDrawable(MainActivity.this.getResources().getDrawable(R.drawable.progress));
			progressDoalog.setMessage("Please Wait....");
			progressDoalog.setTitle("Loading...");
			progressDoalog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
			progressDoalog.setCancelable(true);
			progressDoalog.show();
			new Thread() {
				public void run() {
					try {
						Intent int_home = new Intent(MainActivity.this, sanicontent.class);
						int_home.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
						startActivity(int_home);


					} catch (Exception e) {
					}
					progressDoalog.dismiss();
				}
			}.start();


		}
		else if (item.getItemId() ==R.id.palan) {
			final ProgressDialog progressDoalog = new ProgressDialog(MainActivity.this);
			progressDoalog.setProgressDrawable(MainActivity.this.getResources().getDrawable(R.drawable.progress));
			progressDoalog.setMessage("Please Wait....");
			progressDoalog.setTitle("Loading...");
			progressDoalog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
			progressDoalog.setCancelable(true);
			progressDoalog.show();
			new Thread() {
				public void run() {
					try {
						Intent int_home = new Intent(MainActivity.this, sanipalan.class);
						int_home.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
						startActivity(int_home);


					} catch (Exception e) {
					}
					progressDoalog.dismiss();
				}
			}.start();


		}

		else if (item.getItemId() ==R.id.palangal17) {
			final ProgressDialog progressDoalog = new ProgressDialog(MainActivity.this);
			progressDoalog.setProgressDrawable(MainActivity.this.getResources().getDrawable(R.drawable.progress));
			progressDoalog.setMessage("Please Wait....");
			progressDoalog.setTitle("Loading...");
			progressDoalog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
			progressDoalog.setCancelable(true);
			progressDoalog.show();
			new Thread() {
				public void run() {
					try {
						Intent int_home = new Intent(MainActivity.this, sanipalan17.class);
						int_home.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
						startActivity(int_home);


					} catch (Exception e) {
					}
					progressDoalog.dismiss();
				}
			}.start();


		}
		else if (item.getItemId() ==R.id.guru) {


			AlertDialog.Builder alt_compat = new AlertDialog.Builder(this);
			String desc="App to find out when Guru Peyarchi or Jupiter transit takes place.";


	/*LinearLayout layout = new LinearLayout(this);
	TextView tvMessage = new TextView(this);
	tvMessage.setBackgroundColor(Color.parseColor("#e9b44f"));
	tvMessage.setText(desc);
    tvMessage.setPadding(5, 5, 5, 5);
	tvMessage.setTextSize(17);
	layout.setOrientation(LinearLayout.VERTICAL);
	layout.addView(tvMessage);
	alt_compat.setView(layout);  */

			alt_compat.setTitle("Guru Peyarchi");
			alt_compat.setMessage(desc);
			alt_compat.setCancelable(false)

					.setPositiveButton("Later", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {

							dialog.cancel();
						}
					})
					.setNegativeButton("Never/Already", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					})

					.setNeutralButton("Open", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {



							Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=findyourfate.com.gurupeyarchi"));
							startActivity(browserIntent);


						}
					});


			AlertDialog alert = alt_compat.create();
			alert.show();

		}

		else if (item.getItemId() ==R.id.rahu) {


			AlertDialog.Builder alt_compat = new AlertDialog.Builder(this);
			String desc="App to find out when Rahu-Ketu Peyarchi transit takes place.";


        				/*LinearLayout layout = new LinearLayout(this);
        				TextView tvMessage = new TextView(this);
        				tvMessage.setBackgroundColor(Color.parseColor("#e9b44f"));
        				tvMessage.setText(desc);
        			    tvMessage.setPadding(5, 5, 5, 5);
        				tvMessage.setTextSize(17);
        				layout.setOrientation(LinearLayout.VERTICAL);
        				layout.addView(tvMessage);
        				alt_compat.setView(layout);  */

			alt_compat.setTitle("Rahu-Ketu Peyarchi");
			alt_compat.setMessage(desc);
			alt_compat.setCancelable(false)

					.setPositiveButton("Later", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {

							dialog.cancel();
						}
					})
					.setNegativeButton("Never/Already", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					})

					.setNeutralButton("Open", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {



							Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=findyourfate.com.rahuketupeyarchi"));
							startActivity(browserIntent);


						}
					});


			AlertDialog alert = alt_compat.create();
			alert.show();

		}
		else if (item.getItemId() ==R.id.icon_exit) {
			AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setMessage("Are you sure you want to leave this App.")
					.setCancelable(false)
					.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent intent = new Intent(Intent.ACTION_MAIN);
							intent.addCategory(Intent.CATEGORY_HOME);
							intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
							startActivity(intent);
						}
					})
					.setNegativeButton("No", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					});
			AlertDialog alert1 = builder.create();
			alert1.setTitle("Close App.");
			alert1.setIcon(R.drawable.alert);
			alert1.show();
		}

		else if (item.getItemId() ==R.id.share) {

			Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
			emailIntent.setType("text/plain");
			emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "Sani Peyarchi by findyourfate.com");
			emailIntent.putExtra(android.content.Intent.EXTRA_TEXT, "Hi,I would like to suggest, this Sani Peyarchi App to you. Click this link to download app http://goo.gl/zL5Eyu"+"\n\n"+" Regards");
			startActivity(Intent.createChooser(emailIntent,"Share using"));
		}
		else {
		}
		return true;


	}

	@Override
	public void onBackPressed() {
		super.onBackPressed();
		MainActivity.this.finish();
	}
}