/*
 * Decompiled with CFR 0.152.
 */
package findyourfate.com.rahuketupeyarchi;

import android.view.View;
import android.widget.LinearLayout;
import findyourfate.com.rahuketupeyarchi.ItemsRange;
import findyourfate.com.rahuketupeyarchi.WheelView;
import java.util.LinkedList;
import java.util.List;

public class WheelRecycle {
    private List<View> items;
    private List<View> emptyItems;
    private WheelView wheel;

    public WheelRecycle(WheelView wheel) {
        this.wheel = wheel;
    }

    public int recycleItems(LinearLayout layout2, int firstItem, ItemsRange range) {
        int index = firstItem;
        int i = 0;
        while (i < layout2.getChildCount()) {
            if (!range.contains(index)) {
                this.recycleView(layout2.getChildAt(i), index);
                layout2.removeViewAt(i);
                if (i == 0) {
                    ++firstItem;
                }
            } else {
                ++i;
            }
            ++index;
        }
        return firstItem;
    }

    public View getItem() {
        return this.getCachedView(this.items);
    }

    public View getEmptyItem() {
        return this.getCachedView(this.emptyItems);
    }

    public void clearAll() {
        if (this.items != null) {
            this.items.clear();
        }
        if (this.emptyItems != null) {
            this.emptyItems.clear();
        }
    }

    private List<View> addView(View view, List<View> cache) {
        if (cache == null) {
            cache = new LinkedList<View>();
        }
        cache.add(view);
        return cache;
    }

    private void recycleView(View view, int index) {
        int count = this.wheel.getViewAdapter().getItemsCount();
        if (!(index >= 0 && index < count || this.wheel.isCyclic())) {
            this.emptyItems = this.addView(view, this.emptyItems);
        } else {
            while (index < 0) {
                index = count + index;
            }
            index %= count;
            this.items = this.addView(view, this.items);
        }
    }

    private View getCachedView(List<View> cache) {
        if (cache != null && cache.size() > 0) {
            View view = cache.get(0);
            cache.remove(0);
            return view;
        }
        return null;
    }
}

