/*
 * Decompiled with CFR 0.152.
 */
package findyourfate.com.rahuketupeyarchi;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import findyourfate.com.rahuketupeyarchi.AbstractWheelAdapter;

public abstract class AbstractWheelTextAdapter
extends AbstractWheelAdapter {
    public static final int TEXT_VIEW_ITEM_RESOURCE = -1;
    protected static final int NO_RESOURCE = 0;
    public static final int DEFAULT_TEXT_COLOR = -15724528;
    public static final int LABEL_COLOR = -9437072;
    public static final int DEFAULT_TEXT_SIZE = 24;
    private int textColor = -15724528;
    private int textSize = 24;
    protected Context context;
    protected LayoutInflater inflater;
    protected int itemResourceId;
    protected int itemTextResourceId;
    protected int emptyItemResourceId;

    protected AbstractWheelTextAdapter(Context context) {
        this(context, -1);
    }

    protected AbstractWheelTextAdapter(Context context, int itemResource) {
        this(context, itemResource, 0);
    }

    protected AbstractWheelTextAdapter(Context context, int itemResource, int itemTextResource) {
        this.context = context;
        this.itemResourceId = itemResource;
        this.itemTextResourceId = itemTextResource;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getItemResource() {
        return this.itemResourceId;
    }

    public void setItemResource(int itemResourceId) {
        this.itemResourceId = itemResourceId;
    }

    public int getItemTextResource() {
        return this.itemTextResourceId;
    }

    public void setItemTextResource(int itemTextResourceId) {
        this.itemTextResourceId = itemTextResourceId;
    }

    public int getEmptyItemResource() {
        return this.emptyItemResourceId;
    }

    public void setEmptyItemResource(int emptyItemResourceId) {
        this.emptyItemResourceId = emptyItemResourceId;
    }

    protected abstract CharSequence getItemText(int var1);

    @Override
    public View getItem(int index, View convertView, ViewGroup parent) {
        if (index >= 0 && index < this.getItemsCount()) {
            TextView textView;
            if (convertView == null) {
                convertView = this.getView(this.itemResourceId, parent);
            }
            if ((textView = this.getTextView(convertView, this.itemTextResourceId)) != null) {
                CharSequence text = this.getItemText(index);
                if (text == null) {
                    text = "";
                }
                textView.setText(text);
                if (this.itemResourceId == -1) {
                    this.configureTextView(textView);
                }
            }
            return convertView;
        }
        return null;
    }

    @Override
    public View getEmptyItem(View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.getView(this.emptyItemResourceId, parent);
        }
        if (this.emptyItemResourceId == -1 && convertView instanceof TextView) {
            this.configureTextView((TextView)convertView);
        }
        return convertView;
    }

    protected void configureTextView(TextView view) {
        view.setTextColor(this.textColor);
        view.setGravity(17);
        view.setTextSize((float)this.textSize);
        view.setLines(1);
        view.setTypeface(Typeface.SANS_SERIF, 1);
    }

    private TextView getTextView(View view, int textResource) {
        TextView text = null;
        try {
            if (textResource == 0 && view instanceof TextView) {
                text = (TextView)view;
            } else if (textResource != 0) {
                text = (TextView)view.findViewById(textResource);
            }
        }
        catch (ClassCastException e) {
            Log.e((String)"AbstractWheelAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("AbstractWheelAdapter requires the resource ID to be a TextView", e);
        }
        return text;
    }

    private View getView(int resource, ViewGroup parent) {
        switch (resource) {
            case 0: {
                return null;
            }
            case -1: {
                return new TextView(this.context);
            }
        }
        return this.inflater.inflate(resource, parent, false);
    }
}

