package findyourfate.com.porutham;


import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

import android.annotation.SuppressLint;
import androidx.appcompat.widget.Toolbar;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.Toast;
import android.widget.AdapterView.OnItemSelectedListener;
import android.net.Uri;

public class single extends AppCompatActivity  implements OnClickListener {
	private Spinner spinner1;
	DBHelper DB = null;
	ImageView image;

	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.single);
        
		Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
		
		addListenerOnSpinnerItemSelection();
		addListenerOnSpinnerItemSelection();

		FirebaseDatabase database = FirebaseDatabase.getInstance();
		DatabaseReference ref = database.getReference("Description");
		ref.setValue("Description");
 

		// Optionally, configure toolbar settings
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setHomeButtonEnabled(true);
        }
	}

	public void addListenerOnSpinnerItemSelection() {
		spinner1 = (Spinner) findViewById(R.id.spinner1);
		String array[] = { "--SELECT--", "Anusham", "Aswini", "Avittam", "Ayilayam", "Barani", "Chithirai", "Hastham",
				"Karthi", "Kettai", "Mirga", "Moolam", "Makam", "Pooradam", "Pooram", "Poorat", "Poosam", "Punarap",
				"Reva", "Rohi", "Sathayam", "Swathi", "Thiruv", "Thiruvonam", "Uthiram", "Uthiradam", "Uthiratathi",
				"Visakam" };
		ArrayAdapter<String> sp_adapter = new ArrayAdapter<String>(this, R.layout.spinnertext, array);
		sp_adapter.setDropDownViewResource(R.layout.spinner_selector);
		Spinner sp = (Spinner) findViewById(R.id.spinner1);
		sp.setAdapter(sp_adapter);
		spinner1.setOnItemSelectedListener(new OnItemSelectedListener()

		{
			public void onItemSelected(AdapterView<?> main, View view, int position, long Id) {
				if (position > 0) {
					final String star = (String) spinner1.getSelectedItem();
					if (star.equals("") || star == null || star.equals("--SELECT--")) {
						Toast.makeText(getApplicationContext(), "Please enter boy star", Toast.LENGTH_SHORT).show();
					} else {
						boolean validLogin = validateLogin(star, getBaseContext());
						if (validLogin) {

							 

								Intent in = new Intent(getBaseContext(), sample1.class);
								in.putExtra("Star", star);
								startActivity(in);
							 
						}
					}
				} else {
				}
			}

			public void onNothingSelected(AdapterView<?> arg0) {
			}
		});
	}

	private boolean validateLogin(String star, Context baseContext) {
		DB = new DBHelper(getBaseContext());
		SQLiteDatabase db = DB.getReadableDatabase();
		String[] columns = { "_id" };
		String selection = "boystar=?";
		String[] selectionArgs = { star };
		Cursor cursor = null;
		try {
			cursor = db.query(DBHelper.DATABASE_TABLE_NAME, columns, selection, selectionArgs, null, null, null);
			startManagingCursor(cursor);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	/*
	 * @Override
	 * public void onBackPressed() {
	 * AlertDialog.Builder builder = new AlertDialog.Builder(this);
	 * builder.setMessage("Are you sure you want to leave this App.")
	 * .setCancelable(false)
	 * .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
	 * public void onClick(DialogInterface dialog, int id) {
	 * Intent int_home4 = new Intent(single.this,index.class);
	 * int_home4.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
	 * startActivity(int_home4);
	 * }
	 * })
	 * .setNegativeButton("No", new DialogInterface.OnClickListener() {
	 * public void onClick(DialogInterface dialog, int id) {
	 * dialog.cancel();
	 * }
	 * });
	 * AlertDialog alert = builder.create();
	 * alert.setIcon(R.drawable.alert);
	 * alert.show();
	 * 
	 * }
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.activity_main, menu);
		MenuItem item = menu.findItem(R.id.cfont);
		item.setVisible(false);
		return true;
	}

	@Override
	public void onClick(View v) {
	}

	public boolean onOptionsItemSelected(MenuItem item) {
		int itemId = item.getItemId();

		if (itemId == android.R.id.home) {
			Intent int_abt = new Intent(this, index.class);
			int_abt.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(int_abt);
			return true;
		}
		else if (itemId == R.id.claculator) {
			Intent icon_calc = new Intent(this, poruthamcalculator.class);
			icon_calc.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(icon_calc);
			return true;
		}
		else if (itemId == R.id.Nakshatra) {
			Intent icon_find = new Intent(this, findnakshatra.class);
			icon_find.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(icon_find);
			return true;
		}
		else if (itemId == R.id.guru) {
			AlertDialog.Builder alt_compat = new AlertDialog.Builder(this);
			String desc = "App to find out when Guru Peyarchi or Jupiter transit takes place.";
			alt_compat.setTitle("Guru Peyarchi");
			alt_compat.setMessage(desc)
					.setCancelable(false)
					.setPositiveButton("Later", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					})
					.setNegativeButton("Never/Already", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					})
					.setNeutralButton("Open", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent browserIntent = new Intent(Intent.ACTION_VIEW,
									Uri.parse("market://details?id=findyourfate.com.gurupeyarchi"));
							startActivity(browserIntent);
						}
					});
			AlertDialog alert = alt_compat.create();
			alert.show();
			return true;
		}
		else if (itemId == R.id.icon_exit) {
			AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setMessage("Are you sure you want to leave this App.")
					.setCancelable(false)
					.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent intent = new Intent(Intent.ACTION_MAIN);
							intent.addCategory(Intent.CATEGORY_HOME);
							intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
							startActivity(intent);
						}
					})
					.setNegativeButton("No", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					});
			AlertDialog alert1 = builder.create();
			alert1.setTitle("Close App.");
			alert1.setIcon(R.drawable.alert);
			alert1.show();
			return true;
		}
		else if (itemId == R.id.share) {
			Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
			emailIntent.setType("text/plain");
			emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "10 Porutham by findyourfate.com");
			emailIntent.putExtra(android.content.Intent.EXTRA_TEXT,
					"Hi, I would like to suggest this 10 Porutham App to you. Click this link to download the app http://goo.gl/38FZui"
							+ "\n\n" + " Regards");
			startActivity(Intent.createChooser(emailIntent, "Share using"));
			return true;
		}
		else {
			return super.onOptionsItemSelected(item);
		}
	}


}