package findyourfate.com.porutham;

import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

import android.annotation.SuppressLint;

import androidx.appcompat.widget.Toolbar;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;

import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import android.view.View.OnClickListener;
import android.webkit.WebView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;

import android.widget.Spinner;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements OnClickListener {

	private Spinner spinner1;
	private Spinner spinner123;
	Button mbutton1;
	DBHelper DB = null;
	ImageView image;

	@SuppressLint("NewApi")
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		String userAgent = new WebView(MainActivity.this).getSettings().getUserAgentString();
		if (userAgent.contains("Mobile")) {
			setContentView(R.layout.activity_main);
		} else {
			setContentView(R.layout.activity_maintab);
		}
        
		Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

		// Initialize Firebase
		FirebaseDatabase database = FirebaseDatabase.getInstance();
		DatabaseReference ref = database.getReference("Description");
		ref.setValue("Description");

		spinner1 = (Spinner) findViewById(R.id.spinner1);
		spinner123 = (Spinner) findViewById(R.id.spinner123);
		String array[] = { "--SELECT--",
				"Anusham",
				"Aswini",
				"Avittam",
				"Ayilayam",
				"Barani",
				"Chithirai",
				"Hastham",
				"Karthi",
				"Kettai",
				"Mirga",
				"Moolam",
				"Makam",
				"Pooradam",
				"Pooram",
				"Poorat",
				"Poosam",
				"Punarap",
				"Reva",
				"Rohi",
				"Sathayam",
				"Swathi",
				"Thiruv",
				"Thiruvonam",
				"Uthiram",
				"Uthiradam",
				"Uthiratathi",
				"Visakam" };
		String array123[] = { "--SELECT--",
				"Anusham",
				"Aswini",
				"Avittam-Makar",
				"Avittam-Kumba",
				"Ayilayam",
				"Barani",
				"Chithirai-Kani",
				"Chithirai-Thul",
				"Hastham",
				"Karthi-Mes",
				"Karthi-Ris",
				"Kettai",
				"Mirga-Rish",
				"Mirga-Midh",
				"Moolam",
				"Makam",
				"Pooradam",
				"Pooram",
				"Parat-Kum",
				"Purat-Min",
				"Poosam",
				"Puna-Midh",
				"Puna-Kada",
				"Revathi",
				"Rohini",
				"Sathayam",
				"Swathi",
				"Thirvadhir",
				"Thiruvonam",
				"Uthira-Sim",
				"Uthira-Kan",
				"Utra-Danus",
				"Utra-Makar",
				"Uthrattath",
				"Visak-Thul",
				"Visak-Viru"
		};

		ArrayAdapter<String> sp_adapter = new ArrayAdapter<String>(this, R.layout.spinnertext, array);
		ArrayAdapter<String> sp_adapter123 = new ArrayAdapter<String>(this, R.layout.spinnertext, array123);
		sp_adapter.setDropDownViewResource(R.layout.spinner_selector);
		sp_adapter123.setDropDownViewResource(R.layout.spinner_selector);
		Spinner sp = (Spinner) findViewById(R.id.spinner1);
		Spinner sp123 = (Spinner) findViewById(R.id.spinner123);
		sp.setAdapter(sp_adapter);
		sp123.setAdapter(sp_adapter123);
		mbutton1 = (Button) findViewById(R.id.button1);
		mbutton1.setOnClickListener(this);

        // Optionally, configure toolbar settings
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setHomeButtonEnabled(true);
			getSupportActionBar().setTitle("10 Porutham");
        }

		
	}


	@SuppressWarnings("deprecation")
	private boolean validateLogin(String star, Context baseContext) {
		DB = new DBHelper(getBaseContext());
		SQLiteDatabase db = DB.getReadableDatabase();
		String[] columns = { "_id" };
		String selection = "girlstar=?";
		String[] selectionArgs = { star };
		Cursor cursor = null;
		try {
			cursor = db.query(DBHelper.DATABASE_TABLE_NAME, columns, selection, selectionArgs, null, null, null);
			startManagingCursor(cursor);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	@SuppressWarnings("deprecation")
	private boolean validateLogin123(String star123, Context baseContext) {
		DB = new DBHelper(getBaseContext());
		SQLiteDatabase db = DB.getReadableDatabase();
		String[] columns = { "_id" };
		String selection = "girlstar=?";
		String[] selectionArgs = { star123 };
		Cursor cursor = null;
		try {
			cursor = db.query(DBHelper.DATABASE_TABLE_NAME, columns, selection, selectionArgs, null, null, null);
			startManagingCursor(cursor);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.activity_main, menu);
		MenuItem item = menu.findItem(R.id.cfont);
		item.setVisible(false);
		return true;
	}

	@Override
	public void onClick(View v) {
		if (v.getId() == R.id.button1) {
			final String star = (String) spinner1.getSelectedItem();
			final String star123 = (String) spinner123.getSelectedItem();

			if ((star.equals("") || star.equals("--SELECT--")) && (star123.equals("") || star123.equals("--SELECT--"))) {
				Toast.makeText(getApplicationContext(), "Please enter both stars", Toast.LENGTH_SHORT).show();
			} else if (star.equals("--SELECT--")) {
				Toast.makeText(getApplicationContext(), "Please enter Boy star", Toast.LENGTH_SHORT).show();
			} else if (star123.equals("--SELECT--")) {
				Toast.makeText(getApplicationContext(), "Please enter Girl star", Toast.LENGTH_SHORT).show();
			} else {
				boolean validLogin = validateLogin(star, getBaseContext());
				boolean validLogin123 = validateLogin123(star123, getBaseContext());

				if (validLogin && validLogin123) {
					Intent in123 = new Intent(getBaseContext(), sample.class);
					in123.putExtra("Star123", star123);
					in123.putExtra("Star", star);
					startActivity(in123);
				}
			}
		}

	}

	public boolean onOptionsItemSelected(MenuItem item) {
		int itemId = item.getItemId();

		if (itemId == android.R.id.home) {
			Intent int_abt = new Intent(this, index.class);
			int_abt.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(int_abt);
			return true;
		}
		else if (itemId == R.id.claculator) {
			Intent icon_calc = new Intent(this, poruthamcalculator.class);
			icon_calc.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(icon_calc);
			return true;
		}
		else if (itemId == R.id.Nakshatra) {
			Intent icon_find = new Intent(this, findnakshatra.class);
			icon_find.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(icon_find);
			return true;
		}
		else if (itemId == R.id.guru) {
			AlertDialog.Builder alt_compat = new AlertDialog.Builder(this);
			String desc = "App to find out when Guru Peyarchi or Jupiter transit takes place.";
			alt_compat.setTitle("Guru Peyarchi");
			alt_compat.setMessage(desc)
					.setCancelable(false)
					.setPositiveButton("Later", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					})
					.setNegativeButton("Never/Already", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					})
					.setNeutralButton("Open", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent browserIntent = new Intent(Intent.ACTION_VIEW,
									Uri.parse("market://details?id=findyourfate.com.gurupeyarchi"));
							startActivity(browserIntent);
						}
					});
			AlertDialog alert = alt_compat.create();
			alert.show();
			return true;
		}
		else if (itemId == R.id.icon_exit) {
			AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setMessage("Are you sure you want to leave this App.")
					.setCancelable(false)
					.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent int_home4 = new Intent(MainActivity.this, index.class);
							int_home4.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
							startActivity(int_home4);
						}
					})
					.setNegativeButton("No", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					});
			AlertDialog alert1 = builder.create();
			alert1.setTitle("Close App");
			alert1.setIcon(R.drawable.alert);
			alert1.show();
			return true;
		}
		else if (itemId == R.id.share) {
			Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
			emailIntent.setType("text/plain");
			emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "10 Porutham by findyourfate.com");
			emailIntent.putExtra(android.content.Intent.EXTRA_TEXT,
					"Hi, I would like to suggest this 10 Porutham App to you. Click this link to download the app http://goo.gl/38FZui"
							+ "\n\n" + " Regards");
			startActivity(Intent.createChooser(emailIntent, "Share using"));
			return true;
		}
		else {
			return super.onOptionsItemSelected(item);
		}
	}

}