/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.client.protocol;

import java.io.IOException;
import org.shaded.apache.commons.logging.Log;
import org.shaded.apache.commons.logging.LogFactory;
import org.shaded.apache.http.HttpException;
import org.shaded.apache.http.HttpRequest;
import org.shaded.apache.http.HttpRequestInterceptor;
import org.shaded.apache.http.annotation.Immutable;
import org.shaded.apache.http.auth.AuthScheme;
import org.shaded.apache.http.auth.AuthState;
import org.shaded.apache.http.auth.AuthenticationException;
import org.shaded.apache.http.auth.Credentials;
import org.shaded.apache.http.protocol.HttpContext;

@Immutable
public class RequestTargetAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block10: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            String method = request.getRequestLine().getMethod();
            if (method.equalsIgnoreCase("CONNECT")) {
                return;
            }
            if (request.containsHeader("Authorization")) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState == null) {
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    request.addHeader(authScheme.authenticate(creds, request));
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error("Authentication error: " + ex.getMessage());
                }
            }
        }
    }
}

