/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.introspect;

import com.shaded.fasterxml.jackson.databind.JavaType;
import com.shaded.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.shaded.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.shaded.fasterxml.jackson.databind.type.TypeBindings;
import com.shaded.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class AnnotatedMethod
extends AnnotatedWithParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Method _method;
    protected Class<?>[] _paramClasses;
    protected Serialization _serialization;

    public AnnotatedMethod(Method method, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(annotationMap, annotationMapArray);
        if (method == null) {
            throw new IllegalArgumentException("Can not construct AnnotatedMethod with null Method");
        }
        this._method = method;
    }

    protected AnnotatedMethod(Serialization serialization) {
        super(null, null);
        this._method = null;
        this._serialization = serialization;
    }

    public AnnotatedMethod withMethod(Method method) {
        return new AnnotatedMethod(method, this._annotations, this._paramAnnotations);
    }

    @Override
    public AnnotatedMethod withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedMethod(this._method, annotationMap, this._paramAnnotations);
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public Type getGenericType() {
        return this._method.getGenericReturnType();
    }

    @Override
    public Class<?> getRawType() {
        return this._method.getReturnType();
    }

    @Override
    public JavaType getType(TypeBindings typeBindings) {
        return this.getType(typeBindings, this._method.getTypeParameters());
    }

    @Override
    public final Object call() throws Exception {
        return this._method.invoke(null, new Object[0]);
    }

    @Override
    public final Object call(Object[] objectArray) throws Exception {
        return this._method.invoke(null, objectArray);
    }

    @Override
    public final Object call1(Object object) throws Exception {
        return this._method.invoke(null, object);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    @Override
    public Method getMember() {
        return this._method;
    }

    @Override
    public void setValue(Object object, Object object2) throws IllegalArgumentException {
        try {
            this._method.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to setValue() with method " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Failed to setValue() with method " + this.getFullName() + ": " + invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    @Override
    public Object getValue(Object object) throws IllegalArgumentException {
        try {
            return this._method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to getValue() with method " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Failed to getValue() with method " + this.getFullName() + ": " + invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    @Override
    public int getParameterCount() {
        return this.getRawParameterTypes().length;
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName() + "(" + this.getParameterCount() + " params)";
    }

    public Class<?>[] getRawParameterTypes() {
        if (this._paramClasses == null) {
            this._paramClasses = this._method.getParameterTypes();
        }
        return this._paramClasses;
    }

    public Type[] getGenericParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    @Override
    public Class<?> getRawParameterType(int n) {
        Class<?>[] classArray = this.getRawParameterTypes();
        return n >= classArray.length ? null : classArray[n];
    }

    @Override
    public Type getGenericParameterType(int n) {
        Type[] typeArray = this._method.getGenericParameterTypes();
        return n >= typeArray.length ? null : typeArray[n];
    }

    public Class<?> getRawReturnType() {
        return this._method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this._method.getGenericReturnType();
    }

    public String toString() {
        return "[method " + this.getFullName() + "]";
    }

    Object writeReplace() {
        return new AnnotatedMethod(new Serialization(this._method));
    }

    Object readResolve() {
        Class<?> clazz = this._serialization.clazz;
        try {
            Method method = clazz.getDeclaredMethod(this._serialization.name, this._serialization.args);
            if (!method.isAccessible()) {
                ClassUtil.checkAndFixAccess(method);
            }
            return new AnnotatedMethod(method, null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find method '" + this._serialization.name + "' from Class '" + clazz.getName());
        }
    }

    private static final class Serialization
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Class<?> clazz;
        protected String name;
        protected Class<?>[] args;

        public Serialization(Method method) {
            this.clazz = method.getDeclaringClass();
            this.name = method.getName();
            this.args = method.getParameterTypes();
        }
    }
}

