/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.ext;

import com.shaded.fasterxml.jackson.databind.BeanDescription;
import com.shaded.fasterxml.jackson.databind.DeserializationConfig;
import com.shaded.fasterxml.jackson.databind.JavaType;
import com.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.shaded.fasterxml.jackson.databind.JsonSerializer;
import com.shaded.fasterxml.jackson.databind.SerializationConfig;
import com.shaded.fasterxml.jackson.databind.deser.Deserializers;
import com.shaded.fasterxml.jackson.databind.ser.Serializers;
import java.io.Serializable;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.shaded.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.shaded.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String CLASS_NAME_DOM_NODE = "org.w3c.dom.Node";
    private static final String CLASS_NAME_DOM_DOCUMENT = "org.w3c.dom.Node";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.shaded.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.shaded.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.shaded.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    public static final OptionalHandlerFactory instance = new OptionalHandlerFactory();

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        String string = clazz.getName();
        if (!string.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSupertypeStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            if (this.doesImplement(clazz, "org.w3c.dom.Node")) {
                return (JsonSerializer)this.instantiate(SERIALIZER_FOR_DOM_NODE);
            }
            return null;
        }
        String string2 = SERIALIZERS_FOR_JAVAX_XML;
        Object object = this.instantiate(string2);
        if (object == null) {
            return null;
        }
        return ((Serializers)object).findSerializer(serializationConfig, javaType, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        String string = clazz.getName();
        if (!string.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSupertypeStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            if (this.doesImplement(clazz, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_DOCUMENT);
            }
            if (this.doesImplement(clazz, "org.w3c.dom.Node")) {
                return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_NODE);
            }
            return null;
        }
        String string2 = DESERIALIZERS_FOR_JAVAX_XML;
        Object object = this.instantiate(string2);
        if (object == null) {
            return null;
        }
        return ((Deserializers)object).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    private Object instantiate(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean doesImplement(Class<?> clazz, String string) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (clazz2.getName().equals(string)) {
                return true;
            }
            if (!this.hasInterface(clazz2, string)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(Class<?> clazz, String string) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!clazz2.getName().equals(string)) continue;
            return true;
        }
        for (Class<?> clazz2 : classArray) {
            if (!this.hasInterface(clazz2, string)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSupertypeStartingWith(Class<?> clazz, String string) {
        Class<?> clazz2;
        for (clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!clazz2.getName().startsWith(string)) continue;
            return true;
        }
        for (clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!this.hasInterfaceStartingWith(clazz2, string)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterfaceStartingWith(Class<?> clazz, String string) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!clazz2.getName().startsWith(string)) continue;
            return true;
        }
        for (Class<?> clazz2 : classArray) {
            if (!this.hasInterfaceStartingWith(clazz2, string)) continue;
            return true;
        }
        return false;
    }
}

