/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.deser.std;

import com.shaded.fasterxml.jackson.core.JsonParser;
import com.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.shaded.fasterxml.jackson.core.JsonToken;
import com.shaded.fasterxml.jackson.core.io.NumberInput;
import com.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import com.shaded.fasterxml.jackson.databind.BeanProperty;
import com.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.shaded.fasterxml.jackson.databind.JavaType;
import com.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.shaded.fasterxml.jackson.databind.KeyDeserializer;
import com.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.shaded.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.shaded.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> clazz) {
        this._valueClass = clazz;
    }

    protected StdDeserializer(JavaType javaType) {
        this._valueClass = javaType == null ? null : javaType.getRawClass();
    }

    public Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return jsonDeserializer != null && jsonDeserializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return keyDeserializer != null && keyDeserializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            if (jsonParser.getNumberType() == JsonParser.NumberType.INT) {
                return jsonParser.getIntValue() != 0;
            }
            return this._parseBooleanFromNumber(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string) || string.length() == 0) {
                return Boolean.FALSE;
            }
            throw deserializationContext.weirdStringException(string, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Boolean _parseBoolean(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            if (jsonParser.getNumberType() == JsonParser.NumberType.INT) {
                return jsonParser.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return this._parseBooleanFromNumber(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            if (string.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            throw deserializationContext.weirdStringException(string, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final boolean _parseBooleanFromNumber(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getNumberType() == JsonParser.NumberType.LONG) {
            return jsonParser.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String string = jsonParser.getText();
        if ("0.0".equals(string) || "0".equals(string)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Byte _parseByte(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getByteValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            int n;
            String string = jsonParser.getText().trim();
            try {
                int n2 = string.length();
                if (n2 == 0) {
                    return (Byte)this.getEmptyValue();
                }
                n = NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Byte value");
            }
            if (n < -128 || n > 255) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)n;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected Short _parseShort(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getShortValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            int n;
            String string = jsonParser.getText().trim();
            try {
                int n2 = string.length();
                if (n2 == 0) {
                    return (Short)this.getEmptyValue();
                }
                n = NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Short value");
            }
            if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)n;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final short _parseShortPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        int n = this._parseIntPrimitive(jsonParser, deserializationContext);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw deserializationContext.weirdStringException(String.valueOf(n), this._valueClass, "overflow, value can not be represented as 16-bit value");
        }
        return (short)n;
    }

    protected final int _parseIntPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                int n = string.length();
                if (n > 9) {
                    long l = Long.parseLong(string);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw deserializationContext.weirdStringException(string, this._valueClass, "Overflow: numeric value (" + string + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (n == 0) {
                    return 0;
                }
                return NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid int value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Integer _parseInteger(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                int n = string.length();
                if (n > 9) {
                    long l = Long.parseLong(string);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw deserializationContext.weirdStringException(string, this._valueClass, "Overflow: numeric value (" + string + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (n == 0) {
                    return (Integer)this.getEmptyValue();
                }
                return NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Integer value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Integer)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Long _parseLong(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Long)this.getEmptyValue();
            }
            try {
                return NumberInput.parseLong(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Long value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Long)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final long _parseLongPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0L;
            }
            try {
                return NumberInput.parseLong(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid long value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0L;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Float)this.getEmptyValue();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Float value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getFloatValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0.0f;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid float value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Double)this.getEmptyValue();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Double value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0.0;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid double value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jsonParser.getLongValue());
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = null;
            try {
                string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (Date)this.getEmptyValue();
                }
                return deserializationContext.parseDate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid representation (error: " + illegalArgumentException.getMessage() + ")");
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected static final double parseDouble(String string) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(string)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(string);
    }

    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String string = jsonParser.getValueAsString();
        if (string != null) {
            return string;
        }
        throw deserializationContext.mappingException(String.class, jsonParser.getCurrentToken());
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (object = annotationIntrospector.findDeserializationContentConverter(beanProperty.getMember())) != null) {
            Converter<Object, Object> converter = deserializationContext.converterInstance(beanProperty.getMember(), object);
            JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
            return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object clazz, String string) throws IOException, JsonProcessingException {
        if (clazz == null) {
            clazz = this.getValueClass();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, clazz, string)) {
            return;
        }
        deserializationContext.reportUnknownProperty(clazz, string, this);
        jsonParser.skipChildren();
    }
}

