/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.utilities;

import com.firebase.client.FirebaseException;
import com.firebase.client.core.Path;
import com.firebase.client.core.ValidationPath;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.snapshot.PriorityUtilities;
import com.firebase.client.utilities.Utilities;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Validation {
    private static final Pattern INVALID_PATH_REGEX = Pattern.compile("[\\[\\]\\.#$]");
    private static final Pattern INVALID_KEY_REGEX = Pattern.compile("[\\[\\]\\.#\\$\\/\\u0000-\\u001F\\u007F]");

    private static boolean isValidPathString(String pathString) {
        return !INVALID_PATH_REGEX.matcher(pathString).find();
    }

    public static void validatePathString(String pathString) throws FirebaseException {
        if (!Validation.isValidPathString(pathString)) {
            throw new FirebaseException("Invalid Firebase path: " + pathString + ". Firebase paths must not contain '.', '#', '$', '[', or ']'");
        }
    }

    public static void validateRootPathString(String pathString) throws FirebaseException {
        if (pathString.startsWith(".info")) {
            Validation.validatePathString(pathString.substring(5));
        } else if (pathString.startsWith("/.info")) {
            Validation.validatePathString(pathString.substring(6));
        } else {
            Validation.validatePathString(pathString);
        }
    }

    private static boolean isWritableKey(String key) {
        return key != null && key.length() > 0 && (key.equals(".value") || key.equals(".priority") || !key.startsWith(".") && !INVALID_KEY_REGEX.matcher(key).find());
    }

    private static boolean isValidKey(String key) {
        return key.equals(".info") || !INVALID_KEY_REGEX.matcher(key).find();
    }

    public static void validateNullableKey(String key) throws FirebaseException {
        if (key != null && !Validation.isValidKey(key)) {
            throw new FirebaseException("Invalid key: " + key + ". Keys must not contain '/', '.', '#', '$', '[', or ']'");
        }
    }

    private static boolean isWritablePath(Path path) {
        ChildKey front = path.getFront();
        return front == null || !front.asString().startsWith(".");
    }

    public static void validateWritableObject(Object object) {
        block4: {
            block3: {
                if (!(object instanceof Map)) break block3;
                Map map = (Map)object;
                if (map.containsKey(".sv")) {
                    return;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Validation.validateWritableKey((String)entry.getKey());
                    Validation.validateWritableObject(entry.getValue());
                }
                break block4;
            }
            if (!(object instanceof List)) break block4;
            List list = (List)object;
            for (Object child : list) {
                Validation.validateWritableObject(child);
            }
        }
    }

    public static void validateWritableKey(String key) throws FirebaseException {
        if (!Validation.isWritableKey(key)) {
            throw new FirebaseException("Invalid key: " + key + ". Keys must not contain '/', '.', '#', '$', '[', or ']'");
        }
    }

    public static void validateWritablePath(Path path) throws FirebaseException {
        if (!Validation.isWritablePath(path)) {
            throw new FirebaseException("Invalid write location: " + path.toString());
        }
    }

    public static Map<Path, Node> parseAndValidateUpdate(Path path, Map<String, Object> update) throws FirebaseException {
        TreeMap<Path, Node> parsedUpdate = new TreeMap<Path, Node>();
        for (Map.Entry<String, Object> entry : update.entrySet()) {
            String childName;
            Path updatePath = new Path(entry.getKey());
            Object newValue = entry.getValue();
            ValidationPath.validateWithObject(path.child(updatePath), newValue);
            String string = childName = !updatePath.isEmpty() ? updatePath.getBack().asString() : "";
            if (childName.equals(".sv") || childName.equals(".value")) {
                throw new FirebaseException("Path '" + updatePath + "' contains disallowed child name: " + childName);
            }
            if (childName.equals(".priority") && !PriorityUtilities.isValidPriority(NodeUtilities.NodeFromJSON(newValue))) {
                throw new FirebaseException("Path '" + updatePath + "' contains invalid priority " + "(must be a string, double, ServerValue, or null).");
            }
            Validation.validateWritableObject(newValue);
            parsedUpdate.put(updatePath, NodeUtilities.NodeFromJSON(newValue));
        }
        Path prevPath = null;
        for (Path curPath : parsedUpdate.keySet()) {
            Utilities.hardAssert(prevPath == null || prevPath.compareTo(curPath) < 0);
            if (prevPath != null && prevPath.contains(curPath)) {
                throw new FirebaseException("Path '" + prevPath + "' is an ancestor of '" + curPath + "' in an update.");
            }
            prevPath = curPath;
        }
        return parsedUpdate;
    }
}

