/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.realtime;

import com.firebase.client.core.Context;
import com.firebase.client.core.RepoInfo;
import com.firebase.client.realtime.util.StringListReader;
import com.firebase.client.utilities.LogWrapper;
import com.firebase.client.utilities.Utilities;
import com.firebase.client.utilities.encoding.JsonHelpers;
import com.firebase.tubesock.WebSocket;
import com.firebase.tubesock.WebSocketEventHandler;
import com.firebase.tubesock.WebSocketException;
import com.firebase.tubesock.WebSocketMessage;
import com.shaded.fasterxml.jackson.databind.JavaType;
import com.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.shaded.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WebsocketConnection {
    private static long connectionId = 0L;
    private static final long KEEP_ALIVE = 45000L;
    private static final long CONNECT_TIMEOUT = 30000L;
    private static final int MAX_FRAME_SIZE = 16384;
    private WSClient conn;
    private boolean everConnected = false;
    private boolean isClosed = false;
    private long totalFrames = 0L;
    private StringListReader frameReader;
    private Delegate delegate;
    private ScheduledFuture keepAlive;
    private ObjectMapper mapper;
    private ScheduledFuture connectTimeout;
    private Context ctx;
    private LogWrapper logger;
    private MapType mapType;

    public WebsocketConnection(Context ctx, RepoInfo repoInfo, Delegate delegate, String optLastSessionId) {
        long connId = connectionId++;
        this.mapper = JsonHelpers.getMapper();
        this.mapType = this.mapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
        this.delegate = delegate;
        this.ctx = ctx;
        this.logger = ctx.getLogger("WebSocket", "ws_" + connId);
        this.conn = this.createConnection(repoInfo, optLastSessionId);
    }

    private WSClient createConnection(RepoInfo repoInfo, String optLastSessionId) {
        URI uri = repoInfo.getConnectionURL(optLastSessionId);
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        extraHeaders.put("User-Agent", this.ctx.getUserAgent());
        WebSocket ws = new WebSocket(uri, null, extraHeaders);
        WSClientTubesock client = new WSClientTubesock(ws);
        return client;
    }

    public void open() {
        this.conn.connect();
        this.connectTimeout = this.ctx.getRunLoop().schedule(new Runnable(){

            @Override
            public void run() {
                WebsocketConnection.this.closeIfNeverConnected();
            }
        }, 30000L);
    }

    public void start() {
    }

    public void close() {
        if (this.logger.logsDebug()) {
            this.logger.debug("websocket is being closed");
        }
        this.isClosed = true;
        this.conn.close();
        if (this.connectTimeout != null) {
            this.connectTimeout.cancel(true);
        }
        if (this.keepAlive != null) {
            this.keepAlive.cancel(true);
        }
    }

    public void send(Map<String, Object> message) {
        this.resetKeepAlive();
        try {
            String toSend = this.mapper.writeValueAsString(message);
            String[] segs = Utilities.splitIntoFrames(toSend, 16384);
            if (segs.length > 1) {
                this.conn.send("" + segs.length);
            }
            for (int i = 0; i < segs.length; ++i) {
                this.conn.send(segs[i]);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize message: " + message.toString(), e);
            this.shutdown();
        }
    }

    private void appendFrame(String message) {
        this.frameReader.addString(message);
        --this.totalFrames;
        if (this.totalFrames == 0L) {
            try {
                this.frameReader.freeze();
                Map decoded = (Map)this.mapper.readValue((Reader)this.frameReader, (JavaType)this.mapType);
                this.frameReader = null;
                if (this.logger.logsDebug()) {
                    this.logger.debug("handleIncomingFrame complete frame: " + decoded);
                }
                this.delegate.onMessage(decoded);
            }
            catch (IOException e) {
                this.logger.error("Error parsing frame: " + this.frameReader.toString(), e);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException e) {
                this.logger.error("Error parsing frame (cast error): " + this.frameReader.toString(), e);
                this.close();
                this.shutdown();
            }
        }
    }

    private void handleNewFrameCount(int numFrames) {
        this.totalFrames = numFrames;
        this.frameReader = new StringListReader();
        if (this.logger.logsDebug()) {
            this.logger.debug("HandleNewFrameCount: " + this.totalFrames);
        }
    }

    private String extractFrameCount(String message) {
        if (message.length() <= 6) {
            try {
                int frameCount = Integer.parseInt(message);
                if (frameCount > 0) {
                    this.handleNewFrameCount(frameCount);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.handleNewFrameCount(1);
        return message;
    }

    private void handleIncomingFrame(String message) {
        if (!this.isClosed) {
            this.resetKeepAlive();
            if (this.isBuffering()) {
                this.appendFrame(message);
            } else {
                String remaining = this.extractFrameCount(message);
                if (remaining != null) {
                    this.appendFrame(remaining);
                }
            }
        }
    }

    private void resetKeepAlive() {
        if (!this.isClosed) {
            if (this.keepAlive != null) {
                this.keepAlive.cancel(false);
                if (this.logger.logsDebug()) {
                    this.logger.debug("Reset keepAlive. Remaining: " + this.keepAlive.getDelay(TimeUnit.MILLISECONDS));
                }
            } else if (this.logger.logsDebug()) {
                this.logger.debug("Reset keepAlive");
            }
            this.keepAlive = this.ctx.getRunLoop().schedule(this.nop(), 45000L);
        }
    }

    private Runnable nop() {
        return new Runnable(){

            @Override
            public void run() {
                if (WebsocketConnection.this.conn != null) {
                    WebsocketConnection.this.conn.send("0");
                    WebsocketConnection.this.resetKeepAlive();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.frameReader != null;
    }

    private void onClosed() {
        if (!this.isClosed) {
            if (this.logger.logsDebug()) {
                this.logger.debug("closing itself");
            }
            this.shutdown();
        }
        this.conn = null;
        if (this.keepAlive != null) {
            this.keepAlive.cancel(false);
        }
    }

    private void shutdown() {
        this.isClosed = true;
        this.delegate.onDisconnect(this.everConnected);
    }

    private void closeIfNeverConnected() {
        if (!this.everConnected && !this.isClosed) {
            if (this.logger.logsDebug()) {
                this.logger.debug("timed out on connect");
            }
            this.conn.close();
        }
    }

    private class WSClientTubesock
    implements WSClient,
    WebSocketEventHandler {
        private WebSocket ws;

        private WSClientTubesock(WebSocket ws) {
            this.ws = ws;
            this.ws.setEventHandler(this);
        }

        @Override
        public void onOpen() {
            WebsocketConnection.this.ctx.getRunLoop().scheduleNow(new Runnable(){

                @Override
                public void run() {
                    WebsocketConnection.this.connectTimeout.cancel(false);
                    WebsocketConnection.this.everConnected = true;
                    if (WebsocketConnection.this.logger.logsDebug()) {
                        WebsocketConnection.this.logger.debug("websocket opened");
                    }
                    WebsocketConnection.this.resetKeepAlive();
                }
            });
        }

        @Override
        public void onMessage(WebSocketMessage msg) {
            final String str = msg.getText();
            if (WebsocketConnection.this.logger.logsDebug()) {
                WebsocketConnection.this.logger.debug("ws message: " + str);
            }
            WebsocketConnection.this.ctx.getRunLoop().scheduleNow(new Runnable(){

                @Override
                public void run() {
                    WebsocketConnection.this.handleIncomingFrame(str);
                }
            });
        }

        @Override
        public void onClose() {
            String logMessage = "closed";
            WebsocketConnection.this.ctx.getRunLoop().scheduleNow(new Runnable(){

                @Override
                public void run() {
                    if (WebsocketConnection.this.logger.logsDebug()) {
                        WebsocketConnection.this.logger.debug("closed");
                    }
                    WebsocketConnection.this.onClosed();
                }
            });
        }

        @Override
        public void onError(final WebSocketException e) {
            WebsocketConnection.this.ctx.getRunLoop().scheduleNow(new Runnable(){

                @Override
                public void run() {
                    String logMessage = "had an error";
                    if (WebsocketConnection.this.logger.logsDebug()) {
                        WebsocketConnection.this.logger.debug(logMessage, e);
                    }
                    if (e.getMessage().startsWith("unknown host")) {
                        if (WebsocketConnection.this.logger.logsDebug()) {
                            WebsocketConnection.this.logger.debug("If you are running on Android, have you added <uses-permission android:name=\"android.permission.INTERNET\" /> under <manifest> in AndroidManifest.xml?");
                        }
                    } else if (WebsocketConnection.this.logger.logsDebug()) {
                        WebsocketConnection.this.logger.debug("|" + e.getMessage() + "|");
                    }
                    WebsocketConnection.this.onClosed();
                }
            });
        }

        @Override
        public void onLogMessage(String msg) {
            if (WebsocketConnection.this.logger.logsDebug()) {
                WebsocketConnection.this.logger.debug("Tubesock: " + msg);
            }
        }

        @Override
        public void send(String msg) {
            this.ws.send(msg);
        }

        @Override
        public void close() {
            this.ws.close();
        }

        private void shutdown() {
            this.ws.close();
            try {
                this.ws.blockClose();
            }
            catch (InterruptedException e) {
                WebsocketConnection.this.logger.error("Interrupted while shutting down websocket threads", e);
            }
        }

        @Override
        public void connect() {
            try {
                this.ws.connect();
            }
            catch (WebSocketException e) {
                if (WebsocketConnection.this.logger.logsDebug()) {
                    WebsocketConnection.this.logger.debug("Error connecting", e);
                }
                this.shutdown();
            }
        }
    }

    private static interface WSClient {
        public void connect();

        public void close();

        public void send(String var1);
    }

    public static interface Delegate {
        public void onMessage(Map<String, Object> var1);

        public void onDisconnect(boolean var1);
    }
}

