/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.core.AndroidSupport;
import com.firebase.client.core.CompoundHash;
import com.firebase.client.core.Constants;
import com.firebase.client.core.Context;
import com.firebase.client.core.Path;
import com.firebase.client.core.RangeMerge;
import com.firebase.client.core.RepoInfo;
import com.firebase.client.core.SyncTree;
import com.firebase.client.core.Tag;
import com.firebase.client.core.view.QuerySpec;
import com.firebase.client.realtime.Connection;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.utilities.LogWrapper;
import com.firebase.client.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;

public class PersistentConnection
implements Connection.Delegate {
    private static final String REQUEST_ERROR = "error";
    private static final String REQUEST_QUERIES = "q";
    private static final String REQUEST_TAG = "t";
    private static final String REQUEST_STATUS = "s";
    private static final String REQUEST_PATH = "p";
    private static final String REQUEST_NUMBER = "r";
    private static final String REQUEST_PAYLOAD = "b";
    private static final String REQUEST_COUNTERS = "c";
    private static final String REQUEST_DATA_PAYLOAD = "d";
    private static final String REQUEST_DATA_HASH = "h";
    private static final String REQUEST_COMPOUND_HASH = "ch";
    private static final String REQUEST_COMPOUND_HASH_PATHS = "ps";
    private static final String REQUEST_COMPOUND_HASH_HASHES = "hs";
    private static final String REQUEST_CREDENTIAL = "cred";
    private static final String REQUEST_ACTION = "a";
    private static final String REQUEST_ACTION_STATS = "s";
    private static final String REQUEST_ACTION_LISTEN = "l";
    private static final String REQUEST_ACTION_QUERY = "q";
    private static final String REQUEST_ACTION_PUT = "p";
    private static final String REQUEST_ACTION_MERGE = "m";
    private static final String REQUEST_ACTION_UNLISTEN = "u";
    private static final String REQUEST_ACTION_QUERY_UNLISTEN = "n";
    private static final String REQUEST_ACTION_ONDISCONNECT_PUT = "o";
    private static final String REQUEST_ACTION_ONDISCONNECT_MERGE = "om";
    private static final String REQUEST_ACTION_ONDISCONNECT_CANCEL = "oc";
    private static final String REQUEST_ACTION_AUTH = "auth";
    private static final String REQUEST_ACTION_UNAUTH = "unauth";
    private static final String RESPONSE_FOR_REQUEST = "b";
    private static final String SERVER_ASYNC_ACTION = "a";
    private static final String SERVER_ASYNC_PAYLOAD = "b";
    private static final String SERVER_ASYNC_DATA_UPDATE = "d";
    private static final String SERVER_ASYNC_DATA_MERGE = "m";
    private static final String SERVER_ASYNC_DATA_RANGE_MERGE = "rm";
    private static final String SERVER_ASYNC_AUTH_REVOKED = "ac";
    private static final String SERVER_ASYNC_LISTEN_CANCELLED = "c";
    private static final String SERVER_ASYNC_SECURITY_DEBUG = "sd";
    private static final String SERVER_DATA_UPDATE_PATH = "p";
    private static final String SERVER_DATA_UPDATE_BODY = "d";
    private static final String SERVER_DATA_START_PATH = "s";
    private static final String SERVER_DATA_END_PATH = "e";
    private static final String SERVER_DATA_RANGE_MERGE = "m";
    private static final String SERVER_DATA_TAG = "t";
    private static final String SERVER_DATA_WARNINGS = "w";
    private static final String SERVER_RESPONSE_DATA = "d";
    private static final long RECONNECT_MIN_DELAY = 1000L;
    private static final long RECONNECT_RESET_TIMEOUT = 30000L;
    private static final long RECONNECT_MAX_DELAY = 30000L;
    private static final double RECONNECT_MULTIPLIER = 1.3;
    private static long connectionIds = 0L;
    private Delegate delegate;
    private RepoInfo repoInfo;
    private boolean shouldReconnect = true;
    private boolean firstConnection = true;
    private long lastConnectionAttemptTime;
    private long lastConnectionEstablishedTime;
    private Connection realtime;
    private ConnectionState connectionState = ConnectionState.Disconnected;
    private long writeCounter = 0L;
    private long requestCounter = 0L;
    private long reconnectDelay = 1000L;
    private Map<Long, ResponseListener> requestCBHash;
    private boolean writesPaused;
    private List<OutstandingDisconnect> onDisconnectRequestQueue;
    private Map<Long, OutstandingPut> outstandingPuts;
    private Map<QuerySpec, OutstandingListen> listens;
    private Random random;
    private ScheduledFuture reconnectFuture;
    private AuthCredential authCredential;
    private Context ctx;
    private LogWrapper logger;
    private String lastSessionId;

    public PersistentConnection(Context ctx, RepoInfo info, Delegate delegate) {
        this.delegate = delegate;
        this.ctx = ctx;
        this.repoInfo = info;
        this.listens = new HashMap<QuerySpec, OutstandingListen>();
        this.requestCBHash = new HashMap<Long, ResponseListener>();
        this.writesPaused = false;
        this.outstandingPuts = new HashMap<Long, OutstandingPut>();
        this.onDisconnectRequestQueue = new ArrayList<OutstandingDisconnect>();
        this.random = new Random();
        long connId = connectionIds++;
        this.logger = this.ctx.getLogger("PersistentConnection", "pc_" + connId);
        this.lastSessionId = null;
    }

    public void establishConnection() {
        if (this.shouldReconnect) {
            this.lastConnectionAttemptTime = System.currentTimeMillis();
            this.lastConnectionEstablishedTime = 0L;
            this.realtime = new Connection(this.ctx, this.repoInfo, this, this.lastSessionId);
            this.realtime.open();
        }
    }

    @Override
    public void onReady(long timestamp, String sessionId) {
        if (this.logger.logsDebug()) {
            this.logger.debug("onReady");
        }
        this.lastConnectionEstablishedTime = System.currentTimeMillis();
        this.handleTimestamp(timestamp);
        if (this.firstConnection) {
            this.sendConnectStats();
        }
        this.restoreState();
        this.firstConnection = false;
        this.lastSessionId = sessionId;
        this.delegate.onConnect();
    }

    public void listen(QuerySpec query, SyncTree.SyncTreeHash currentHashFn, Tag tag, RequestResultListener listener) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Listening on " + query);
        }
        Utilities.hardAssert(query.isDefault() || !query.loadsAllData(), "listen() called for non-default but complete query");
        Utilities.hardAssert(!this.listens.containsKey(query), "listen() called twice for same QuerySpec.");
        if (this.logger.logsDebug()) {
            this.logger.debug("Adding listen query: " + query);
        }
        OutstandingListen outstandingListen = new OutstandingListen(listener, query, tag, currentHashFn);
        this.listens.put(query, outstandingListen);
        if (this.connected()) {
            this.sendListen(outstandingListen);
        }
    }

    public Map<QuerySpec, OutstandingListen> getListens() {
        return this.listens;
    }

    public void put(String pathString, Object data, Firebase.CompletionListener onComplete) {
        this.put(pathString, data, null, onComplete);
    }

    public void put(String pathString, Object data, String hash, Firebase.CompletionListener onComplete) {
        this.putInternal("p", pathString, data, hash, onComplete);
    }

    public void merge(String pathString, Object data, Firebase.CompletionListener onComplete) {
        this.putInternal("m", pathString, data, null, onComplete);
    }

    public void purgeOutstandingWrites() {
        FirebaseError error = FirebaseError.fromCode(-25);
        for (OutstandingPut put : this.outstandingPuts.values()) {
            if (put.onComplete == null) continue;
            put.onComplete.onComplete(error, null);
        }
        for (OutstandingDisconnect onDisconnect : this.onDisconnectRequestQueue) {
            if (onDisconnect.onComplete == null) continue;
            onDisconnect.onComplete.onComplete(error, null);
        }
        this.outstandingPuts.clear();
        this.onDisconnectRequestQueue.clear();
    }

    @Override
    public void onDataMessage(Map<String, Object> message) {
        if (message.containsKey(REQUEST_NUMBER)) {
            long rn = ((Integer)message.get(REQUEST_NUMBER)).intValue();
            ResponseListener responseListener = this.requestCBHash.remove(rn);
            if (responseListener != null) {
                Map response = (Map)message.get("b");
                responseListener.onResponse(response);
            }
        } else if (!message.containsKey(REQUEST_ERROR)) {
            if (message.containsKey("a")) {
                String action = (String)message.get("a");
                Map body = (Map)message.get("b");
                this.onDataPush(action, body);
            } else if (this.logger.logsDebug()) {
                this.logger.debug("Ignoring unknown message: " + message);
            }
        }
    }

    @Override
    public void onDisconnect(Connection.DisconnectReason reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Got on disconnect due to " + reason.name());
        }
        this.connectionState = ConnectionState.Disconnected;
        if (!this.shouldReconnect) {
            this.cancelTransactions();
            this.requestCBHash.clear();
        } else {
            long recDelay;
            if (reason == Connection.DisconnectReason.SERVER_RESET) {
                recDelay = 0L;
            } else {
                if (this.lastConnectionEstablishedTime > 0L) {
                    long timeSinceLastConnectSucceeded = System.currentTimeMillis() - this.lastConnectionEstablishedTime;
                    if (timeSinceLastConnectSucceeded > 30000L) {
                        this.reconnectDelay = 1000L;
                    }
                    this.lastConnectionEstablishedTime = 0L;
                }
                long timeSinceLastConnectAttempt = System.currentTimeMillis() - this.lastConnectionAttemptTime;
                recDelay = Math.max(1L, this.reconnectDelay - timeSinceLastConnectAttempt);
                recDelay = this.random.nextInt((int)recDelay);
            }
            if (this.logger.logsDebug()) {
                this.logger.debug("Reconnecting in " + recDelay + "ms");
            }
            this.reconnectFuture = this.ctx.getRunLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    PersistentConnection.this.establishConnection();
                }
            }, recDelay);
            this.reconnectDelay = Math.min(30000L, (long)((double)this.reconnectDelay * 1.3));
        }
        this.delegate.onDisconnect();
    }

    @Override
    public void onKill(String reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Firebase connection was forcefully killed by the server. Will not attempt reconnect. Reason: " + reason);
        }
        this.shouldReconnect = false;
    }

    void unlisten(QuerySpec query) {
        if (this.logger.logsDebug()) {
            this.logger.debug("unlistening on " + query);
        }
        Utilities.hardAssert(query.isDefault() || !query.loadsAllData(), "unlisten() called for non-default but complete query");
        OutstandingListen listen = this.removeListen(query);
        if (listen != null && this.connected()) {
            this.sendUnlisten(listen);
        }
    }

    private boolean connected() {
        return this.connectionState != ConnectionState.Disconnected;
    }

    void onDisconnectPut(Path path, Object data, Firebase.CompletionListener onComplete) {
        if (this.canSendWrites()) {
            this.sendOnDisconnect(REQUEST_ACTION_ONDISCONNECT_PUT, path, data, onComplete);
        } else {
            this.onDisconnectRequestQueue.add(new OutstandingDisconnect(REQUEST_ACTION_ONDISCONNECT_PUT, path, data, onComplete));
        }
    }

    private boolean canSendWrites() {
        return this.connectionState == ConnectionState.Connected && !this.writesPaused;
    }

    void onDisconnectMerge(Path path, Map<String, Object> updates, Firebase.CompletionListener onComplete) {
        if (this.canSendWrites()) {
            this.sendOnDisconnect(REQUEST_ACTION_ONDISCONNECT_MERGE, path, updates, onComplete);
        } else {
            this.onDisconnectRequestQueue.add(new OutstandingDisconnect(REQUEST_ACTION_ONDISCONNECT_MERGE, path, updates, onComplete));
        }
    }

    void onDisconnectCancel(Path path, Firebase.CompletionListener onComplete) {
        if (this.canSendWrites()) {
            this.sendOnDisconnect(REQUEST_ACTION_ONDISCONNECT_CANCEL, path, null, onComplete);
        } else {
            this.onDisconnectRequestQueue.add(new OutstandingDisconnect(REQUEST_ACTION_ONDISCONNECT_CANCEL, path, null, onComplete));
        }
    }

    void interrupt() {
        this.shouldReconnect = false;
        if (this.realtime != null) {
            this.realtime.close();
            this.realtime = null;
        } else {
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(false);
                this.reconnectFuture = null;
            }
            this.onDisconnect(Connection.DisconnectReason.OTHER);
        }
    }

    public void resume() {
        this.shouldReconnect = true;
        if (this.realtime == null) {
            this.establishConnection();
        }
    }

    public void auth(String credential, Firebase.AuthListener listener) {
        if (this.authCredential == null) {
            this.authCredential = new AuthCredential(listener, credential);
        } else if (this.authCredential.matches(credential)) {
            this.authCredential.addListener(listener);
            if (this.authCredential.isComplete()) {
                this.authCredential.replay(listener);
            }
        } else {
            this.authCredential.preempt();
            this.authCredential = new AuthCredential(listener, credential);
        }
        if (this.connected()) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Authenticating with credential: " + credential);
            }
            this.sendAuth();
        }
    }

    public void unauth(final Firebase.CompletionListener listener) {
        this.authCredential = null;
        this.delegate.onAuthStatus(false);
        if (this.connected()) {
            this.sendAction(REQUEST_ACTION_UNAUTH, new HashMap<String, Object>(), new ResponseListener(){

                @Override
                public void onResponse(Map<String, Object> response) {
                    String status = (String)response.get("s");
                    FirebaseError error = null;
                    if (!status.equals("ok")) {
                        error = FirebaseError.fromStatus(status, (String)response.get("d"));
                    }
                    listener.onComplete(error, null);
                }
            });
        }
    }

    public void pauseWrites() {
        if (this.logger.logsDebug()) {
            this.logger.debug("Writes paused.");
        }
        this.writesPaused = true;
    }

    public void unpauseWrites() {
        if (this.logger.logsDebug()) {
            this.logger.debug("Writes unpaused.");
        }
        this.writesPaused = false;
        if (this.canSendWrites()) {
            this.restoreWrites();
        }
    }

    public boolean writesPaused() {
        return this.writesPaused;
    }

    private void sendOnDisconnect(String action, Path path, Object data, final Firebase.CompletionListener onComplete) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", path.toString());
        request.put("d", data);
        if (this.logger.logsDebug()) {
            this.logger.debug("onDisconnect " + action + " " + request);
        }
        this.sendAction(action, request, new ResponseListener(){

            @Override
            public void onResponse(Map<String, Object> response) {
                String status = (String)response.get("s");
                FirebaseError error = null;
                if (!status.equals("ok")) {
                    error = FirebaseError.fromStatus(status, (String)response.get("d"));
                }
                if (onComplete != null) {
                    onComplete.onComplete(error, null);
                }
            }
        });
    }

    private void cancelTransactions() {
        Iterator<Map.Entry<Long, OutstandingPut>> iter = this.outstandingPuts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, OutstandingPut> entry = iter.next();
            OutstandingPut put = entry.getValue();
            if (!put.getRequest().containsKey(REQUEST_DATA_HASH)) continue;
            put.getOnComplete().onComplete(FirebaseError.fromStatus("disconnected"), null);
            iter.remove();
        }
    }

    private void sendUnlisten(OutstandingListen listen) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", listen.query.getPath().toString());
        Tag tag = listen.getTag();
        if (tag != null) {
            request.put("q", listen.getQuery().getParams().getWireProtocolParams());
            request.put("t", tag.getTagNumber());
        }
        this.sendAction(REQUEST_ACTION_QUERY_UNLISTEN, request, null);
    }

    private OutstandingListen removeListen(QuerySpec query) {
        if (this.logger.logsDebug()) {
            this.logger.debug("removing query " + query);
        }
        if (!this.listens.containsKey(query)) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Trying to remove listener for QuerySpec " + query + " but no listener exists.");
            }
            return null;
        }
        OutstandingListen oldListen = this.listens.get(query);
        this.listens.remove(query);
        return oldListen;
    }

    public Collection<OutstandingListen> removeListens(Path path) {
        if (this.logger.logsDebug()) {
            this.logger.debug("removing all listens at path " + path);
        }
        ArrayList<OutstandingListen> removedListens = new ArrayList<OutstandingListen>();
        for (Map.Entry<QuerySpec, OutstandingListen> entry : this.listens.entrySet()) {
            QuerySpec query = entry.getKey();
            OutstandingListen listen = entry.getValue();
            if (!query.getPath().equals(path)) continue;
            removedListens.add(listen);
        }
        for (OutstandingListen toRemove : removedListens) {
            this.listens.remove(toRemove.getQuery());
        }
        return removedListens;
    }

    private void onDataPush(String action, Map<String, Object> body) {
        if (this.logger.logsDebug()) {
            this.logger.debug("handleServerMessage: " + action + " " + body);
        }
        if (action.equals("d") || action.equals("m")) {
            Tag tag;
            boolean isMerge = action.equals("m");
            String pathString = (String)body.get("p");
            Object payloadData = body.get("d");
            Long tagNumber = Utilities.longFromObject(body.get("t"));
            Tag tag2 = tag = tagNumber != null ? new Tag(tagNumber) : null;
            if (isMerge && payloadData instanceof Map && ((Map)payloadData).size() == 0) {
                if (this.logger.logsDebug()) {
                    this.logger.debug("ignoring empty merge for path " + pathString);
                }
            } else {
                this.delegate.onDataUpdate(pathString, payloadData, isMerge, tag);
            }
        } else if (action.equals(SERVER_ASYNC_DATA_RANGE_MERGE)) {
            String pathString = (String)body.get("p");
            Object payloadData = body.get("d");
            Long tagNumber = Utilities.longFromObject(body.get("t"));
            Tag tag = tagNumber != null ? new Tag(tagNumber) : null;
            List ranges = (List)payloadData;
            ArrayList<RangeMerge> rangeMerges = new ArrayList<RangeMerge>();
            for (Map range : ranges) {
                String startString = (String)range.get("s");
                String endString = (String)range.get(SERVER_DATA_END_PATH);
                Path start = startString != null ? new Path(startString) : null;
                Path end = endString != null ? new Path(endString) : null;
                Node update = NodeUtilities.NodeFromJSON(range.get("m"));
                rangeMerges.add(new RangeMerge(start, end, update));
            }
            if (rangeMerges.isEmpty()) {
                if (this.logger.logsDebug()) {
                    this.logger.debug("Ignoring empty range merge for path " + pathString);
                }
            } else {
                this.delegate.onRangeMergeUpdate(new Path(pathString), rangeMerges, tag);
            }
        } else if (action.equals("c")) {
            String pathString = (String)body.get("p");
            this.onListenRevoked(new Path(pathString));
        } else if (action.equals(SERVER_ASYNC_AUTH_REVOKED)) {
            String status = (String)body.get("s");
            String reason = (String)body.get("d");
            this.onAuthRevoked(status, reason);
        } else if (action.equals(SERVER_ASYNC_SECURITY_DEBUG)) {
            this.onSecurityDebugPacket(body);
        } else if (this.logger.logsDebug()) {
            this.logger.debug("Unrecognized action from server: " + action);
        }
    }

    private void onListenRevoked(Path path) {
        Collection<OutstandingListen> listens = this.removeListens(path);
        if (listens != null) {
            FirebaseError error = FirebaseError.fromStatus("permission_denied");
            for (OutstandingListen listen : listens) {
                listen.resultListener.onRequestResult(error);
            }
        }
    }

    private void onAuthRevoked(String status, String reason) {
        if (this.authCredential != null) {
            FirebaseError error = FirebaseError.fromStatus(status, reason);
            this.authCredential.onRevoked(error);
            this.authCredential = null;
        }
    }

    private void onSecurityDebugPacket(Map<String, Object> message) {
        this.logger.info((String)message.get("msg"));
    }

    private void sendAuth() {
        this.sendAuthHelper(false);
    }

    private void sendAuthAndRestoreWrites() {
        this.sendAuthHelper(true);
    }

    private void sendAuthHelper(final boolean restoreWritesAfterComplete) {
        assert (this.connected()) : "Must be connected to send auth.";
        assert (this.authCredential != null) : "Can't send auth if it's null.";
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put(REQUEST_CREDENTIAL, this.authCredential.getCredential());
        final AuthCredential credential = this.authCredential;
        this.sendAction(REQUEST_ACTION_AUTH, request, new ResponseListener(){

            @Override
            public void onResponse(Map<String, Object> response) {
                PersistentConnection.this.connectionState = ConnectionState.Connected;
                if (credential == PersistentConnection.this.authCredential) {
                    String status = (String)response.get("s");
                    if (status.equals("ok")) {
                        PersistentConnection.this.delegate.onAuthStatus(true);
                        credential.onSuccess(response.get("d"));
                    } else {
                        PersistentConnection.this.authCredential = null;
                        PersistentConnection.this.delegate.onAuthStatus(false);
                        String reason = (String)response.get("d");
                        credential.onCancel(FirebaseError.fromStatus(status, reason));
                    }
                }
                if (restoreWritesAfterComplete) {
                    PersistentConnection.this.restoreWrites();
                }
            }
        });
    }

    private void restoreState() {
        if (this.logger.logsDebug()) {
            this.logger.debug("calling restore state");
        }
        if (this.authCredential != null) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Restoring auth.");
            }
            this.connectionState = ConnectionState.Authenticating;
            this.sendAuthAndRestoreWrites();
        } else {
            this.connectionState = ConnectionState.Connected;
        }
        if (this.logger.logsDebug()) {
            this.logger.debug("Restoring outstanding listens");
        }
        for (OutstandingListen listen : this.listens.values()) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Restoring listen " + listen.getQuery());
            }
            this.sendListen(listen);
        }
        if (this.connectionState == ConnectionState.Connected) {
            this.restoreWrites();
        }
    }

    private void restoreWrites() {
        assert (this.connectionState == ConnectionState.Connected) : "Should be connected if we're restoring writes.";
        if (this.writesPaused) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Writes are paused; skip restoring writes.");
            }
        } else {
            if (this.logger.logsDebug()) {
                this.logger.debug("Restoring writes.");
            }
            ArrayList<Long> outstanding = new ArrayList<Long>(this.outstandingPuts.keySet());
            Collections.sort(outstanding);
            for (Long put : outstanding) {
                this.sendPut(put);
            }
            for (OutstandingDisconnect disconnect : this.onDisconnectRequestQueue) {
                this.sendOnDisconnect(disconnect.getAction(), disconnect.getPath(), disconnect.getData(), disconnect.getOnComplete());
            }
            this.onDisconnectRequestQueue.clear();
        }
    }

    private void handleTimestamp(long timestamp) {
        if (this.logger.logsDebug()) {
            this.logger.debug("handling timestamp");
        }
        long timestampDelta = timestamp - System.currentTimeMillis();
        HashMap<ChildKey, Object> updates = new HashMap<ChildKey, Object>();
        updates.put(Constants.DOT_INFO_SERVERTIME_OFFSET, timestampDelta);
        this.delegate.onServerInfoUpdate(updates);
    }

    private Map<String, Object> getPutObject(String pathString, Object data, String hash) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", pathString);
        request.put("d", data);
        if (hash != null) {
            request.put(REQUEST_DATA_HASH, hash);
        }
        return request;
    }

    private void putInternal(String action, String pathString, Object data, String hash, Firebase.CompletionListener onComplete) {
        Map<String, Object> request = this.getPutObject(pathString, data, hash);
        long writeId = this.writeCounter++;
        this.outstandingPuts.put(writeId, new OutstandingPut(action, request, onComplete));
        if (this.canSendWrites()) {
            this.sendPut(writeId);
        }
    }

    private void sendPut(final long putId) {
        assert (this.canSendWrites()) : "sendPut called when we can't send writes (we're disconnected or writes are paused).";
        final OutstandingPut put = this.outstandingPuts.get(putId);
        final Firebase.CompletionListener onComplete = put.getOnComplete();
        final String action = put.getAction();
        this.sendAction(action, put.getRequest(), new ResponseListener(){

            @Override
            public void onResponse(Map<String, Object> response) {
                OutstandingPut currentPut;
                if (PersistentConnection.this.logger.logsDebug()) {
                    PersistentConnection.this.logger.debug(action + " response: " + response);
                }
                if ((currentPut = (OutstandingPut)PersistentConnection.this.outstandingPuts.get(putId)) == put) {
                    PersistentConnection.this.outstandingPuts.remove(putId);
                    if (onComplete != null) {
                        String status = (String)response.get("s");
                        if (status.equals("ok")) {
                            onComplete.onComplete(null, null);
                        } else {
                            onComplete.onComplete(FirebaseError.fromStatus(status, (String)response.get("d")), null);
                        }
                    }
                } else if (PersistentConnection.this.logger.logsDebug()) {
                    PersistentConnection.this.logger.debug("Ignoring on complete for put " + putId + " because it was removed already.");
                }
            }
        });
    }

    private void sendListen(final OutstandingListen listen) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", listen.getQuery().getPath().toString());
        Tag tag = listen.getTag();
        if (tag != null) {
            request.put("q", listen.getQuery().getParams().getWireProtocolParams());
            request.put("t", tag.getTagNumber());
        }
        SyncTree.SyncTreeHash hashFunction = listen.getHashFunction();
        request.put(REQUEST_DATA_HASH, hashFunction.getSimpleHash());
        if (hashFunction.shouldIncludeCompoundHash()) {
            CompoundHash compoundHash = hashFunction.getCompoundHash();
            ArrayList<String> posts = new ArrayList<String>();
            for (Path path : compoundHash.getPosts()) {
                posts.add(path.wireFormat());
            }
            HashMap<String, List<String>> hash = new HashMap<String, List<String>>();
            hash.put(REQUEST_COMPOUND_HASH_HASHES, compoundHash.getHashes());
            hash.put(REQUEST_COMPOUND_HASH_PATHS, posts);
            request.put(REQUEST_COMPOUND_HASH, hash);
        }
        this.sendAction("q", request, new ResponseListener(){

            @Override
            public void onResponse(Map<String, Object> response) {
                OutstandingListen currentListen;
                Map serverBody;
                String status = (String)response.get("s");
                if (status.equals("ok") && (serverBody = (Map)response.get("d")).containsKey(PersistentConnection.SERVER_DATA_WARNINGS)) {
                    List warnings = (List)serverBody.get(PersistentConnection.SERVER_DATA_WARNINGS);
                    PersistentConnection.this.warnOnListenerWarnings(warnings, listen.getQuery());
                }
                if ((currentListen = (OutstandingListen)PersistentConnection.this.listens.get(listen.getQuery())) == listen) {
                    if (!status.equals("ok")) {
                        PersistentConnection.this.removeListen(listen.getQuery());
                        FirebaseError error = FirebaseError.fromStatus(status, (String)response.get("d"));
                        listen.resultListener.onRequestResult(error);
                    } else {
                        listen.resultListener.onRequestResult(null);
                    }
                }
            }
        });
    }

    private void sendStats(Map<String, Integer> stats) {
        if (!stats.isEmpty()) {
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("c", stats);
            this.sendAction("s", request, new ResponseListener(){

                @Override
                public void onResponse(Map<String, Object> response) {
                    String status = (String)response.get("s");
                    if (!status.equals("ok")) {
                        FirebaseError error = FirebaseError.fromStatus(status, (String)response.get("d"));
                        if (PersistentConnection.this.logger.logsDebug()) {
                            PersistentConnection.this.logger.debug("Failed to send stats: " + error);
                        }
                    }
                }
            });
        } else if (this.logger.logsDebug()) {
            this.logger.debug("Not sending stats because stats are empty");
        }
    }

    private void warnOnListenerWarnings(List<String> warnings, QuerySpec query) {
        if (warnings.contains("no_index")) {
            String indexSpec = "\".indexOn\": \"" + query.getIndex().getQueryDefinition() + '\"';
            this.logger.warn("Using an unspecified index. Consider adding '" + indexSpec + "' at " + query.getPath() + " to your security and Firebase rules for better performance");
        }
    }

    private void sendConnectStats() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        if (AndroidSupport.isAndroid()) {
            if (this.ctx.isPersistenceEnabled()) {
                stats.put("persistence.android.enabled", 1);
            }
            stats.put("sdk.android." + Firebase.getSdkVersion().replace('.', '-'), 1);
        } else {
            assert (!this.ctx.isPersistenceEnabled()) : "Stats for persistence on JVM missing (persistence not yet supported)";
            stats.put("sdk.java." + Firebase.getSdkVersion().replace('.', '-'), 1);
        }
        if (this.logger.logsDebug()) {
            this.logger.debug("Sending first connection stats");
        }
        this.sendStats(stats);
    }

    private void sendAction(String action, Map<String, Object> message, ResponseListener onResponse) {
        long rn = this.nextRequestNumber();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put(REQUEST_NUMBER, rn);
        request.put("a", action);
        request.put("b", message);
        this.realtime.sendRequest(request);
        this.requestCBHash.put(rn, onResponse);
    }

    private long nextRequestNumber() {
        return this.requestCounter++;
    }

    private static enum ConnectionState {
        Disconnected,
        Authenticating,
        Connected;

    }

    private static class AuthCredential {
        private List<Firebase.AuthListener> listeners = new ArrayList<Firebase.AuthListener>();
        private String credential;
        private boolean onSuccessCalled = false;
        private Object authData;

        AuthCredential(Firebase.AuthListener listener, String credential) {
            this.listeners.add(listener);
            this.credential = credential;
        }

        public boolean matches(String credential) {
            return this.credential.equals(credential);
        }

        public void preempt() {
            FirebaseError error = FirebaseError.fromStatus("preempted");
            for (Firebase.AuthListener listener : this.listeners) {
                listener.onAuthError(error);
            }
        }

        public void addListener(Firebase.AuthListener listener) {
            this.listeners.add(listener);
        }

        public void replay(Firebase.AuthListener listener) {
            assert (this.authData != null);
            listener.onAuthSuccess(this.authData);
        }

        public boolean isComplete() {
            return this.onSuccessCalled;
        }

        public String getCredential() {
            return this.credential;
        }

        public void onCancel(FirebaseError error) {
            if (this.onSuccessCalled) {
                this.onRevoked(error);
            } else {
                for (Firebase.AuthListener listener : this.listeners) {
                    listener.onAuthError(error);
                }
            }
        }

        public void onRevoked(FirebaseError error) {
            for (Firebase.AuthListener listener : this.listeners) {
                listener.onAuthRevoked(error);
            }
        }

        public void onSuccess(Object authData) {
            if (!this.onSuccessCalled) {
                this.onSuccessCalled = true;
                this.authData = authData;
                for (Firebase.AuthListener listener : this.listeners) {
                    listener.onAuthSuccess(authData);
                }
            }
        }
    }

    private static class OutstandingDisconnect {
        private final String action;
        private final Path path;
        private final Object data;
        private final Firebase.CompletionListener onComplete;

        private OutstandingDisconnect(String action, Path path, Object data, Firebase.CompletionListener onComplete) {
            this.action = action;
            this.path = path;
            this.data = data;
            this.onComplete = onComplete;
        }

        public String getAction() {
            return this.action;
        }

        public Path getPath() {
            return this.path;
        }

        public Object getData() {
            return this.data;
        }

        public Firebase.CompletionListener getOnComplete() {
            return this.onComplete;
        }
    }

    private static class OutstandingPut {
        private String action;
        private Map<String, Object> request;
        private Firebase.CompletionListener onComplete;

        private OutstandingPut(String action, Map<String, Object> request, Firebase.CompletionListener onComplete) {
            this.action = action;
            this.request = request;
            this.onComplete = onComplete;
        }

        public String getAction() {
            return this.action;
        }

        public Map<String, Object> getRequest() {
            return this.request;
        }

        public Firebase.CompletionListener getOnComplete() {
            return this.onComplete;
        }
    }

    static class OutstandingListen {
        private final RequestResultListener resultListener;
        private final QuerySpec query;
        private final SyncTree.SyncTreeHash hashFunction;
        private final Tag tag;

        private OutstandingListen(RequestResultListener listener, QuerySpec query, Tag tag, SyncTree.SyncTreeHash hashFunction) {
            this.resultListener = listener;
            this.query = query;
            this.hashFunction = hashFunction;
            this.tag = tag;
        }

        public QuerySpec getQuery() {
            return this.query;
        }

        public Tag getTag() {
            return this.tag;
        }

        public SyncTree.SyncTreeHash getHashFunction() {
            return this.hashFunction;
        }

        public String toString() {
            return this.query.toString() + " (Tag: " + this.tag + ")";
        }
    }

    static interface RequestResultListener {
        public void onRequestResult(FirebaseError var1);
    }

    private static interface ResponseListener {
        public void onResponse(Map<String, Object> var1);
    }

    public static interface Delegate {
        public void onDataUpdate(String var1, Object var2, boolean var3, Tag var4);

        public void onRangeMergeUpdate(Path var1, List<RangeMerge> var2, Tag var3);

        public void onConnect();

        public void onDisconnect();

        public void onAuthStatus(boolean var1);

        public void onServerInfoUpdate(Map<ChildKey, Object> var1);
    }
}

