/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client;

import com.firebase.client.ChildEventListener;
import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.FirebaseException;
import com.firebase.client.ValueEventListener;
import com.firebase.client.core.ChildEventRegistration;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Path;
import com.firebase.client.core.Repo;
import com.firebase.client.core.ValueEventRegistration;
import com.firebase.client.core.ZombieEventManager;
import com.firebase.client.core.view.QueryParams;
import com.firebase.client.core.view.QuerySpec;
import com.firebase.client.snapshot.BooleanNode;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.DoubleNode;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.KeyIndex;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.PathIndex;
import com.firebase.client.snapshot.PriorityIndex;
import com.firebase.client.snapshot.PriorityUtilities;
import com.firebase.client.snapshot.StringNode;
import com.firebase.client.snapshot.ValueIndex;
import com.firebase.client.utilities.Utilities;
import com.firebase.client.utilities.Validation;

public class Query {
    protected final Repo repo;
    protected final Path path;
    protected final QueryParams params;
    private final boolean orderByCalled;

    Query(Repo repo, Path path, QueryParams params, boolean orderByCalled) throws FirebaseException {
        this.repo = repo;
        this.path = path;
        this.params = params;
        this.orderByCalled = orderByCalled;
        Utilities.hardAssert(params.isValid(), "Validation of queries failed.");
    }

    Query(Repo repo, Path path) {
        this.repo = repo;
        this.path = path;
        this.params = QueryParams.DEFAULT_PARAMS;
        this.orderByCalled = false;
    }

    private void validateQueryEndpoints(QueryParams params) {
        if (params.getIndex().equals(KeyIndex.getInstance())) {
            String message = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (params.hasStart()) {
                Node startNode = params.getIndexStartValue();
                ChildKey startName = params.getIndexStartName();
                if (startName != ChildKey.getMinName() || !(startNode instanceof StringNode)) {
                    throw new IllegalArgumentException(message);
                }
            }
            if (params.hasEnd()) {
                Node endNode = params.getIndexEndValue();
                ChildKey endName = params.getIndexEndName();
                if (endName != ChildKey.getMaxName() || !(endNode instanceof StringNode)) {
                    throw new IllegalArgumentException(message);
                }
            }
        } else if (params.getIndex().equals(PriorityIndex.getInstance()) && (params.hasStart() && !PriorityUtilities.isValidPriority(params.getIndexStartValue()) || params.hasEnd() && !PriorityUtilities.isValidPriority(params.getIndexEndValue()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void validateLimit(QueryParams params) {
        if (params.hasStart() && params.hasEnd() && params.hasLimit() && !params.hasAnchoredLimit()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void validateEqualToCall() {
        if (this.params.hasStart()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.params.hasEnd()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void validateNoOrderByCall() {
        if (this.orderByCalled) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener listener) {
        this.addEventRegistration(new ValueEventRegistration(this.repo, listener, this.getSpec()));
        return listener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener listener) {
        this.addEventRegistration(new ChildEventRegistration(this.repo, listener, this.getSpec()));
        return listener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener listener) {
        this.addEventRegistration(new ValueEventRegistration(this.repo, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot snapshot) {
                Query.this.removeEventListener(this);
                listener.onDataChange(snapshot);
            }

            @Override
            public void onCancelled(FirebaseError error) {
                listener.onCancelled(error);
            }
        }, this.getSpec()));
    }

    public void removeEventListener(ValueEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.removeEventRegistration(new ValueEventRegistration(this.repo, listener, this.getSpec()));
    }

    public void removeEventListener(ChildEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.removeEventRegistration(new ChildEventRegistration(this.repo, listener, this.getSpec()));
    }

    private void removeEventRegistration(final EventRegistration registration) {
        ZombieEventManager.getInstance().zombifyForRemove(registration);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Query.this.repo.removeEventCallback(registration);
            }
        });
    }

    private void addEventRegistration(final EventRegistration listener) {
        ZombieEventManager.getInstance().recordEventRegistration(listener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Query.this.repo.addEventCallback(listener);
            }
        });
    }

    public void keepSynced(final boolean keepSynced) {
        if (!this.path.isEmpty() && this.path.getFront().equals(ChildKey.getInfoKey())) {
            throw new FirebaseException("Can't call keepSynced() on .info paths.");
        }
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Query.this.repo.keepSynced(Query.this.getSpec(), keepSynced);
            }
        });
    }

    public Query startAt() {
        return this.startAt(EmptyNode.Empty(), null);
    }

    public Query startAt(String value) {
        return this.startAt(value, null);
    }

    public Query startAt(double value) {
        return this.startAt(value, null);
    }

    public Query startAt(boolean value) {
        return this.startAt(value, null);
    }

    public Query startAt(String value, String key) {
        Node node = value != null ? new StringNode(value, PriorityUtilities.NullPriority()) : EmptyNode.Empty();
        return this.startAt(node, key);
    }

    public Query startAt(double value, String key) {
        return this.startAt(new DoubleNode(value, PriorityUtilities.NullPriority()), key);
    }

    public Query startAt(boolean value, String key) {
        return this.startAt(new BooleanNode(value, PriorityUtilities.NullPriority()), key);
    }

    private Query startAt(Node node, String key) {
        Validation.validateNullableKey(key);
        if (!node.isLeafNode() && !node.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.params.hasStart()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        ChildKey childKey = key != null ? ChildKey.fromString(key) : null;
        QueryParams newParams = this.params.startAt(node, childKey);
        this.validateLimit(newParams);
        this.validateQueryEndpoints(newParams);
        assert (newParams.isValid());
        return new Query(this.repo, this.path, newParams, this.orderByCalled);
    }

    public Query endAt() {
        return this.endAt(Node.MAX_NODE, null);
    }

    public Query endAt(String value) {
        return this.endAt(value, null);
    }

    public Query endAt(double value) {
        return this.endAt(value, null);
    }

    public Query endAt(boolean value) {
        return this.endAt(value, null);
    }

    public Query endAt(String value, String key) {
        Node node = value != null ? new StringNode(value, PriorityUtilities.NullPriority()) : EmptyNode.Empty();
        return this.endAt(node, key);
    }

    public Query endAt(double value, String key) {
        return this.endAt(new DoubleNode(value, PriorityUtilities.NullPriority()), key);
    }

    public Query endAt(boolean value, String key) {
        return this.endAt(new BooleanNode(value, PriorityUtilities.NullPriority()), key);
    }

    private Query endAt(Node node, String key) {
        ChildKey childKey;
        Validation.validateNullableKey(key);
        if (!node.isLeafNode() && !node.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        ChildKey childKey2 = childKey = key != null ? ChildKey.fromString(key) : null;
        if (this.params.hasEnd()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        QueryParams newParams = this.params.endAt(node, childKey);
        this.validateLimit(newParams);
        this.validateQueryEndpoints(newParams);
        assert (newParams.isValid());
        return new Query(this.repo, this.path, newParams, this.orderByCalled);
    }

    public Query equalTo(String value) {
        this.validateEqualToCall();
        return this.startAt(value).endAt(value);
    }

    public Query equalTo(double value) {
        this.validateEqualToCall();
        return this.startAt(value).endAt(value);
    }

    public Query equalTo(boolean value) {
        this.validateEqualToCall();
        return this.startAt(value).endAt(value);
    }

    public Query equalTo(String value, String key) {
        this.validateEqualToCall();
        return this.startAt(value, key).endAt(value, key);
    }

    public Query equalTo(double value, String key) {
        this.validateEqualToCall();
        return this.startAt(value, key).endAt(value, key);
    }

    public Query equalTo(boolean value, String key) {
        this.validateEqualToCall();
        return this.startAt(value, key).endAt(value, key);
    }

    @Deprecated
    public Query limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.params.hasLimit()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        QueryParams newParams = this.params.limit(limit);
        this.validateLimit(newParams);
        return new Query(this.repo, this.path, newParams, this.orderByCalled);
    }

    public Query limitToFirst(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.params.hasLimit()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.repo, this.path, this.params.limitToFirst(limit), this.orderByCalled);
    }

    public Query limitToLast(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.params.hasLimit()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.repo, this.path, this.params.limitToLast(limit), this.orderByCalled);
    }

    public Query orderByChild(String path) {
        if (path == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (path.equals("$key") || path.equals(".key")) {
            throw new IllegalArgumentException("Can't use '" + path + "' as path, please use orderByKey() instead!");
        }
        if (path.equals("$priority") || path.equals(".priority")) {
            throw new IllegalArgumentException("Can't use '" + path + "' as path, please use orderByPriority() instead!");
        }
        if (path.equals("$value") || path.equals(".value")) {
            throw new IllegalArgumentException("Can't use '" + path + "' as path, please use orderByValue() instead!");
        }
        Validation.validatePathString(path);
        this.validateNoOrderByCall();
        Path indexPath = new Path(path);
        if (indexPath.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        PathIndex index = new PathIndex(indexPath);
        return new Query(this.repo, this.path, this.params.orderBy(index), true);
    }

    public Query orderByPriority() {
        this.validateNoOrderByCall();
        QueryParams newParams = this.params.orderBy(PriorityIndex.getInstance());
        this.validateQueryEndpoints(newParams);
        return new Query(this.repo, this.path, newParams, true);
    }

    public Query orderByKey() {
        this.validateNoOrderByCall();
        QueryParams newParams = this.params.orderBy(KeyIndex.getInstance());
        this.validateQueryEndpoints(newParams);
        return new Query(this.repo, this.path, newParams, true);
    }

    public Query orderByValue() {
        this.validateNoOrderByCall();
        return new Query(this.repo, this.path, this.params.orderBy(ValueIndex.getInstance()), true);
    }

    public Firebase getRef() {
        return new Firebase(this.repo, this.getPath());
    }

    public Path getPath() {
        return this.path;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public QuerySpec getSpec() {
        return new QuerySpec(this.path, this.params);
    }
}

