/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client;

import com.firebase.client.FirebaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class FirebaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int PREEMPTED = -5;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int AUTHENTICATION_PROVIDER_DISABLED = -12;
    public static final int INVALID_CONFIGURATION = -13;
    public static final int INVALID_PROVIDER = -14;
    public static final int INVALID_EMAIL = -15;
    public static final int INVALID_PASSWORD = -16;
    public static final int USER_DOES_NOT_EXIST = -17;
    public static final int EMAIL_TAKEN = -18;
    public static final int DENIED_BY_USER = -19;
    public static final int INVALID_CREDENTIALS = -20;
    public static final int INVALID_AUTH_ARGUMENTS = -21;
    public static final int PROVIDER_ERROR = -22;
    public static final int LIMITS_EXCEEDED = -23;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> errorReasons = new HashMap<Integer, String>();
    private static final Map<String, Integer> errorCodes;
    private final int code;
    private final String message;
    private final String details;

    public static FirebaseError fromStatus(String status) {
        return FirebaseError.fromStatus(status, null);
    }

    public static FirebaseError fromStatus(String status, String reason) {
        return FirebaseError.fromStatus(status, reason, null);
    }

    public static FirebaseError fromCode(int code) {
        if (!errorReasons.containsKey(code)) {
            throw new IllegalArgumentException("Invalid Firebase error code: " + code);
        }
        String message = errorReasons.get(code);
        return new FirebaseError(code, message, null);
    }

    public static FirebaseError fromStatus(String status, String reason, String details) {
        Integer code = errorCodes.get(status.toLowerCase());
        if (code == null) {
            code = -999;
        }
        String message = reason == null ? errorReasons.get(code) : reason;
        return new FirebaseError(code, message, details);
    }

    public static FirebaseError fromException(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String reason = errorReasons.get(-11) + stringWriter.toString();
        return new FirebaseError(-11, reason);
    }

    public FirebaseError(int code, String message) {
        this(code, message, null);
    }

    public FirebaseError(int code, String message, String details) {
        this.code = code;
        this.message = message;
        this.details = details == null ? "" : details;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public String toString() {
        return "FirebaseError: " + this.message;
    }

    public FirebaseException toException() {
        return new FirebaseException("Firebase error: " + this.message);
    }

    static {
        errorReasons.put(-1, "The transaction needs to be run again with current data");
        errorReasons.put(-2, "The server indicated that this operation failed");
        errorReasons.put(-3, "This client does not have permission to perform this operation");
        errorReasons.put(-4, "The operation had to be aborted due to a network disconnect");
        errorReasons.put(-5, "The active or pending auth credentials were superseded by another call to auth");
        errorReasons.put(-6, "The supplied auth token has expired");
        errorReasons.put(-7, "The supplied auth token was invalid");
        errorReasons.put(-8, "The transaction had too many retries");
        errorReasons.put(-9, "The transaction was overridden by a subsequent set");
        errorReasons.put(-10, "The service is unavailable");
        errorReasons.put(-11, "User code called from the Firebase runloop threw an exception:\n");
        errorReasons.put(-12, "The specified authentication type is not enabled for this Firebase.");
        errorReasons.put(-13, "The specified authentication type is not properly configured for this Firebase.");
        errorReasons.put(-14, "Invalid provider specified, please check application code.");
        errorReasons.put(-15, "The specified email address is incorrect.");
        errorReasons.put(-16, "The specified password is incorrect.");
        errorReasons.put(-17, "The specified user does not exist.");
        errorReasons.put(-18, "The specified email address is already in use.");
        errorReasons.put(-19, "User denied authentication request.");
        errorReasons.put(-20, "Invalid authentication credentials provided.");
        errorReasons.put(-21, "Invalid authentication arguments provided.");
        errorReasons.put(-22, "A third-party provider error occurred. See data for details.");
        errorReasons.put(-23, "Limits exceeded.");
        errorReasons.put(-24, "The operation could not be performed due to a network error");
        errorReasons.put(-25, "The write was canceled by the user.");
        errorReasons.put(-999, "An unknown error occurred");
        errorCodes = new HashMap<String, Integer>();
        errorCodes.put("datastale", -1);
        errorCodes.put("failure", -2);
        errorCodes.put("permission_denied", -3);
        errorCodes.put("disconnected", -4);
        errorCodes.put("preempted", -5);
        errorCodes.put("expired_token", -6);
        errorCodes.put("invalid_token", -7);
        errorCodes.put("maxretries", -8);
        errorCodes.put("overriddenbyset", -9);
        errorCodes.put("unavailable", -10);
        errorCodes.put("authentication_disabled", -12);
        errorCodes.put("invalid_configuration", -13);
        errorCodes.put("invalid_provider", -14);
        errorCodes.put("invalid_email", -15);
        errorCodes.put("invalid_password", -16);
        errorCodes.put("invalid_user", -17);
        errorCodes.put("email_taken", -18);
        errorCodes.put("user_denied", -19);
        errorCodes.put("invalid_credentials", -20);
        errorCodes.put("invalid_arguments", -21);
        errorCodes.put("provider_error", -22);
        errorCodes.put("limits_exceeded", -23);
        errorCodes.put("network_error", -24);
        errorCodes.put("write_canceled", -25);
    }
}

