/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client;

import com.firebase.client.Firebase;
import com.firebase.client.FirebaseException;
import com.firebase.client.GenericTypeIndicator;
import com.firebase.client.core.Path;
import com.firebase.client.snapshot.IndexedNode;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.utilities.Validation;
import com.firebase.client.utilities.encoding.JsonHelpers;
import java.io.IOException;
import java.util.Iterator;

public class DataSnapshot {
    private final IndexedNode node;
    private final Firebase query;

    public DataSnapshot(Firebase ref, IndexedNode node) {
        this.node = node;
        this.query = ref;
    }

    public DataSnapshot child(String path) {
        Firebase childRef = this.query.child(path);
        Node childNode = this.node.getNode().getChild(new Path(path));
        return new DataSnapshot(childRef, IndexedNode.from(childNode));
    }

    public boolean hasChild(String path) {
        if (this.query.getParent() == null) {
            Validation.validateRootPathString(path);
        } else {
            Validation.validatePathString(path);
        }
        return !this.node.getNode().getChild(new Path(path)).isEmpty();
    }

    public boolean hasChildren() {
        return this.node.getNode().getChildCount() > 0;
    }

    public boolean exists() {
        return !this.node.getNode().isEmpty();
    }

    public Object getValue() {
        return this.node.getNode().getValue();
    }

    public Object getValue(boolean useExportFormat) {
        return this.node.getNode().getValue(useExportFormat);
    }

    public <T> T getValue(Class<T> valueType) {
        Object value = this.node.getNode().getValue();
        try {
            String json = JsonHelpers.getMapper().writeValueAsString(value);
            return JsonHelpers.getMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            throw new FirebaseException("Failed to bounce to type", e);
        }
    }

    public <T> T getValue(GenericTypeIndicator<T> t) {
        Object value = this.node.getNode().getValue();
        try {
            String json = JsonHelpers.getMapper().writeValueAsString(value);
            return JsonHelpers.getMapper().readValue(json, t);
        }
        catch (IOException e) {
            throw new FirebaseException("Failed to bounce to type", e);
        }
    }

    public long getChildrenCount() {
        return this.node.getNode().getChildCount();
    }

    public Firebase getRef() {
        return this.query;
    }

    public String getKey() {
        return this.query.getKey();
    }

    public Iterable<DataSnapshot> getChildren() {
        final Iterator<NamedNode> iter = this.node.iterator();
        return new Iterable<DataSnapshot>(){

            @Override
            public Iterator<DataSnapshot> iterator() {
                return new Iterator<DataSnapshot>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public DataSnapshot next() {
                        NamedNode namedNode = (NamedNode)iter.next();
                        return new DataSnapshot(DataSnapshot.this.query.child(namedNode.getName().asString()), IndexedNode.from(namedNode.getNode()));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove called on immutable collection");
                    }
                };
            }
        };
    }

    public Object getPriority() {
        Object priority = this.node.getNode().getPriority().getValue();
        if (priority instanceof Long) {
            return (double)((Long)priority).longValue();
        }
        return priority;
    }

    public String toString() {
        return "DataSnapshot { key = " + this.query.getKey() + ", value = " + this.node.getNode().getValue(true) + " }";
    }
}

