package mercuryretrograde.findyourfate.com;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream ; 
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import android.content.Context;  
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase; 
import android.database.sqlite.SQLiteOpenHelper;  
public class DatabaseHandler  extends SQLiteOpenHelper { 
    
    private static DatabaseHandler singleton;
    
    public static DatabaseHandler getInstance(final Context context) {
        if (singleton == null) {
            singleton = new DatabaseHandler(context);
        }
        return singleton;
    }
    
    private static SQLiteDatabase mDataBase;  
    private static final String DATABASE_NAME = "mercurynew"; 
    private static final String DATABASE_TABLE_NAME = "mercury";  
    private static final int DATABASE_VERSION = 1;
    public static Context context;
    

    private static final String DATABASE_TABLE_CREATE =
            "CREATE TABLE IF NOT EXISTS " + DATABASE_TABLE_NAME + "(" +
            "sno INTEGER PRIMARY KEY AUTOINCREMENT,"+
            "date1 TEXT,"+
            "date2 TEXT, time1 TEXT, time2 TEXT);";
   
    public DatabaseHandler(Context context) {
  	  super(context, DATABASE_NAME, null, DATABASE_VERSION);
  	     try {
  	    	 File dbFile = context.getDatabasePath(DATABASE_NAME);	    	    	
  	    	InputStream is = context.getAssets().open(DATABASE_NAME);	    	      
  	     OutputStream os = new FileOutputStream(dbFile);
  	     byte[] buffer = new byte[1024];
  	     int mLength;
  	     while ((mLength = is.read(buffer))>0)
  	     {
  	         os.write(buffer, 0, mLength);
  	     }
  	     os.flush();
  	     os.close();
  	     is.close();
  	} catch (IOException e) {
  		e.printStackTrace();
  	}
  	}
     
    public SQLiteDatabase openDatabase() {
        File dbFile = context.getDatabasePath(DATABASE_NAME);	         
        
        return SQLiteDatabase.openDatabase(dbFile.getPath(), null, SQLiteDatabase.OPEN_READONLY);
    }
 
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) { 		
		db.execSQL("DROP TABLE IF EXISTS "+DATABASE_TABLE_NAME);
	    onCreate(db);	    	 
	}
	 
	public void open() {	    	 
	 getWritableDatabase(); 
	}    	
	public void onCreate(SQLiteDatabase db) {	    		  
		  db.execSQL(DATABASE_TABLE_CREATE);	    		   
		}
    

    
  
     
    public List<Contact> getAllContacts() {
		List<Contact> contactList = new ArrayList<Contact>();
			   Calendar c = Calendar.getInstance();
			   SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd hh:mma");
		       String tday = df.format(c.getTime()); 
		       mDataBase = this.getWritableDatabase();
		      Cursor cursor = mDataBase.rawQuery("SELECT * FROM findmercury WHERE date2>='"+tday+"' AND date1<='"+tday+"' order by sno asc", null);   
	 	 	  if (cursor.moveToFirst())
	        {
	      do {
	    	   	Contact contact = new Contact();	    	    
	    	   	contact.setSno(cursor.getInt(0));
			  	contact.setSign(cursor.getString(3));
			    String strtext;
				String str_gen=cursor.getString(4);
				if(str_gen.equals("SD"))
    	        { 
				contact.setupSno(cursor.getInt(0)+1);
				strtext="Direct Station";
    	        }
				else
				{
					 
				contact.setnowsno(cursor.getInt(0));	
				contact.setupSno(cursor.getInt(0)+2);	
				contact.setupSno(cursor.getInt(0)+2);
				strtext="Retrograde Station";
				} 
				contact.setStation(strtext);
			 	contactList.add(contact);
	    			  
	    			 
	      }	while (cursor.moveToNext());
	      cursor.close();
	      } 
		 
		// return contact list
		return contactList;
	}
	 

	 
    @Override
    public synchronized void close() 
    {
        if(mDataBase != null)
            mDataBase.close();
        super.close();
    }
 

}
