package findyourfate.com.ephemeris;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List; 
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper; 
import android.util.Log;
public class DatabaseHandler  extends SQLiteOpenHelper {
    private static String TAG = "DataBaseHelper";
    private static SQLiteDatabase mDataBase;
    private static final String DATABASE_NAME = "ephemerisDB"; 
    private static final String TABLE_CONTACTS = "ephemeris";
    private static final String KEY_SNO = "day";
    private static final String KEY_DATE1 = "month";
    private static final String KEY_DATE2 = "year";
    private static final String KEY_TIME1 = "content";
    private static final int DATABASE_VERSION = 2;
    private Context mContext; 
    private static final String CREATE_CONTACTS_TABLE = "CREATE TABLE " + TABLE_CONTACTS + "("
    		+ KEY_SNO + " NUMERIC,"  
            + KEY_DATE1 + " NUMERIC," + KEY_DATE2 + " NUMERIC,"
            + KEY_TIME1 + " TEXT"+ ")";
    public DatabaseHandler(Context context) throws IOException {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        try {
            File dbFile = context.getDatabasePath(DATABASE_NAME);
            InputStream is = context.getAssets().open(DATABASE_NAME);
            OutputStream os = new FileOutputStream(dbFile);
            byte[] buffer = new byte[1024];
            int mLength;
            while ((mLength = is.read(buffer))>0)
            {
                os.write(buffer, 0, mLength);
            }
            os.flush();
            os.close();
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        this.mContext=context;
        boolean dbexist = checkDataBase();

       
        if (dbexist) {
           System.out.println("Database exists");
            openDataBase();
        } else {
            System.out.println("Database doesn't exist");
            createDataBase();
        }
    }
  
    public void createDataBase() throws IOException
    {
        //If database not exists copy it from the assets
    	
        boolean mDataBaseExist = checkDataBase();
        if(!mDataBaseExist)
        {
            this.getReadableDatabase();
            this.close();
            try 
            {
                //Copy the database from assests
                copyDataBase();
                Log.e(TAG, "createDatabase database created");
            } 
            catch (IOException mIOException) 
            {
                throw new Error("ErrorCopyingDataBase");
            }
        }
    }

    private boolean checkDataBase() {
        SQLiteDatabase checkDB = null;
        try {
            File dbFile = mContext.getDatabasePath(DATABASE_NAME);
            checkDB = SQLiteDatabase.openDatabase(dbFile.getPath(), null, SQLiteDatabase.OPEN_READONLY);
        } catch (SQLiteException e) {
            Log.e(TAG, "Database does not exist", e);
        }
        if (checkDB != null) {
            checkDB.close();
        }
        return checkDB != null;
    }

    //Copy the database from assets
    private void copyDataBase() throws IOException {
        File dbFile = mContext.getDatabasePath(DATABASE_NAME);
        InputStream mInput = mContext.getAssets().open(DATABASE_NAME);
        OutputStream mOutput = new FileOutputStream(dbFile);

        byte[] mBuffer = new byte[1024];
        int mLength;
        while ((mLength = mInput.read(mBuffer)) > 0) {
            mOutput.write(mBuffer, 0, mLength);
        }
        mOutput.flush();
        mOutput.close();
        mInput.close();
        Log.d(TAG, "Database copied to " + dbFile.getAbsolutePath());
    }


    //Open the database, so we can query it
    public void openDataBase() throws SQLException
    {
      File dbFile = mContext.getDatabasePath(DATABASE_NAME);
      mDataBase = SQLiteDatabase.openDatabase(dbFile.getPath(), null, SQLiteDatabase.OPEN_READONLY);
    }

    @Override
    public synchronized void close() 
    {
        if(mDataBase != null)
            mDataBase.close();
        super.close();
    }

 
    @Override
   public void onCreate(SQLiteDatabase db) { 
                 db.execSQL(CREATE_CONTACTS_TABLE);
    }
 
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_CONTACTS); 
        onCreate(db);
}      
    
	public List<Contact> getAllContacts() {
		List<Contact> contactList = new ArrayList<Contact>();
			   File dbFile = mContext.getDatabasePath(DATABASE_NAME);			  
			   mDataBase = SQLiteDatabase.openDatabase(dbFile.getPath(), null,SQLiteDatabase.OPEN_READWRITE);
			   Calendar c = Calendar.getInstance();
			   int tday  =c.get(Calendar.DAY_OF_MONTH);
			   int tmonth=c.get(Calendar.MONTH)+1;
			   int tyear =c.get(Calendar.YEAR); 
				  Cursor cursor = mDataBase.rawQuery("SELECT * FROM ephemeris WHERE day='"+tday+"' AND month='"+tmonth+"' AND year='"+tyear+"' ", null);   
		 	 	  if (cursor.moveToFirst())
		        {
		      do {
		    	   	Contact contact = new Contact();	    	    
		    	   	contact.setSign(cursor.getString(3));
				    contactList.add(contact);
		      }	while (cursor.moveToNext());
		      cursor.close();
		      } 
		 
		// return contact list
		return contactList;
	}

}
