/*
 * Decompiled with CFR 0.152.
 */
package findyourfate.com.ephemeris;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import findyourfate.com.ephemeris.Contact;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DatabaseHandler
extends SQLiteOpenHelper {
    private static String TAG = "DataBaseHelper";
    private static SQLiteDatabase mDataBase;
    private static final String DATABASE_NAME = "ephemerisDB";
    private static final String TABLE_CONTACTS = "ephemeris";
    private static final String KEY_SNO = "day";
    private static final String KEY_DATE1 = "month";
    private static final String KEY_DATE2 = "year";
    private static final String KEY_TIME1 = "content";
    private static final int DATABASE_VERSION = 2;
    private Context mContext;
    private static final String CREATE_CONTACTS_TABLE = "CREATE TABLE ephemeris(day NUMERIC,month NUMERIC,year NUMERIC,content TEXT)";

    public DatabaseHandler(Context context) throws IOException {
        super(context, DATABASE_NAME, null, 2);
        try {
            int mLength;
            File dbFile = context.getDatabasePath(DATABASE_NAME);
            InputStream is = context.getAssets().open(DATABASE_NAME);
            FileOutputStream os = new FileOutputStream(dbFile);
            byte[] buffer = new byte[1024];
            while ((mLength = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, mLength);
            }
            os.flush();
            ((OutputStream)os).close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mContext = context;
        boolean dbexist = this.checkDataBase();
        if (dbexist) {
            System.out.println("Database exists");
            this.openDataBase();
        } else {
            System.out.println("Database doesn't exist");
            this.createDataBase();
        }
    }

    public void createDataBase() throws IOException {
        boolean mDataBaseExist = this.checkDataBase();
        if (!mDataBaseExist) {
            this.getReadableDatabase();
            this.close();
            try {
                this.copyDataBase();
                Log.e((String)TAG, (String)"createDatabase database created");
            }
            catch (IOException mIOException) {
                throw new Error("ErrorCopyingDataBase");
            }
        }
    }

    private boolean checkDataBase() {
        SQLiteDatabase checkDB = null;
        try {
            File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
            checkDB = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)1);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Database does not exist", (Throwable)e);
        }
        if (checkDB != null) {
            checkDB.close();
        }
        return checkDB != null;
    }

    private void copyDataBase() throws IOException {
        int mLength;
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        InputStream mInput = this.mContext.getAssets().open(DATABASE_NAME);
        FileOutputStream mOutput = new FileOutputStream(dbFile);
        byte[] mBuffer = new byte[1024];
        while ((mLength = mInput.read(mBuffer)) > 0) {
            ((OutputStream)mOutput).write(mBuffer, 0, mLength);
        }
        mOutput.flush();
        ((OutputStream)mOutput).close();
        mInput.close();
        Log.d((String)TAG, (String)("Database copied to " + dbFile.getAbsolutePath()));
    }

    public void openDataBase() throws SQLException {
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        mDataBase = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)1);
    }

    public synchronized void close() {
        if (mDataBase != null) {
            mDataBase.close();
        }
        super.close();
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_CONTACTS_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS ephemeris");
        this.onCreate(db);
    }

    public List<Contact> getAllContacts() {
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        mDataBase = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)0);
        Calendar c = Calendar.getInstance();
        int tday = c.get(5);
        int tmonth = c.get(2) + 1;
        int tyear = c.get(1);
        Cursor cursor = mDataBase.rawQuery("SELECT * FROM ephemeris WHERE day='" + tday + "' AND month='" + tmonth + "' AND year='" + tyear + "' ", null);
        if (cursor.moveToFirst()) {
            do {
                Contact contact = new Contact();
                contact.setSign(cursor.getString(3));
                contactList.add(contact);
            } while (cursor.moveToNext());
            cursor.close();
        }
        return contactList;
    }
}

