/*
 * Decompiled with CFR 0.152.
 */
package deathmeter.deathclock;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import deathmeter.deathclock.ActionItem;
import deathmeter.deathclock.PopupWindows;
import deathmeter.deathclock.R;
import java.util.ArrayList;
import java.util.List;

public class QuickAction
extends PopupWindows
implements PopupWindow.OnDismissListener {
    private View mRootView;
    private ImageView mArrowUp;
    private ImageView mArrowDown;
    private LayoutInflater mInflater;
    private ViewGroup mTrack;
    private ScrollView mScroller;
    private OnActionItemClickListener mItemClickListener;
    private OnDismissListener mDismissListener;
    private List<ActionItem> actionItems = new ArrayList<ActionItem>();
    private boolean mDidAction;
    public boolean isDismissed = false;
    private int mChildPos;
    private int mInsertPos;
    private int mAnimStyle;
    private int mOrientation;
    private int rootWidth = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int ANIM_GROW_FROM_LEFT = 1;
    public static final int ANIM_GROW_FROM_RIGHT = 2;
    public static final int ANIM_GROW_FROM_CENTER = 3;
    public static final int ANIM_REFLECT = 4;
    public static final int ANIM_AUTO = 5;
    public static View baseView = null;

    public QuickAction(Context context) {
        this(context, 1);
    }

    public QuickAction(Context context, int orientation) {
        super(context);
        this.mOrientation = orientation;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        if (this.mOrientation == 0) {
            this.setRootViewId(R.layout.popup_horizontal);
        } else {
            this.setRootViewId(R.layout.popup_vertical);
        }
        this.mAnimStyle = 5;
        this.mChildPos = 0;
    }

    public ActionItem getActionItem(int index) {
        return this.actionItems.get(index);
    }

    public View GetBaseView() {
        return baseView;
    }

    public void setRootViewId(int id2) {
        this.mRootView = (ViewGroup)this.mInflater.inflate(id2, null);
        this.mTrack = (ViewGroup)this.mRootView.findViewById(R.id.tracks);
        this.mArrowDown = (ImageView)this.mRootView.findViewById(R.id.arrow_down);
        this.mArrowUp = (ImageView)this.mRootView.findViewById(R.id.arrow_up);
        this.mScroller = (ScrollView)this.mRootView.findViewById(R.id.scroller);
        this.mRootView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setContentView(this.mRootView);
    }

    public void setAnimStyle(int mAnimStyle) {
        this.mAnimStyle = mAnimStyle;
    }

    public void setOnActionItemClickListener(OnActionItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void addActionItem(ActionItem action) {
        this.actionItems.add(action);
        String title = action.getTitle();
        Drawable icon = action.getIcon();
        View container = this.mOrientation == 0 ? this.mInflater.inflate(R.layout.action_item_horizontal, null) : this.mInflater.inflate(R.layout.action_item_vertical, null);
        ImageView img = (ImageView)container.findViewById(R.id.iv_icon);
        TextView text = (TextView)container.findViewById(R.id.tv_title);
        if (icon != null) {
            img.setImageDrawable(icon);
        } else {
            img.setVisibility(8);
        }
        if (title != null) {
            text.setText((CharSequence)title);
        } else {
            text.setVisibility(8);
        }
        final int pos = this.mChildPos;
        final int actionId = action.getActionId();
        container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QuickAction.this.mItemClickListener != null) {
                    QuickAction.this.mItemClickListener.onItemClick(QuickAction.this, pos, actionId);
                }
                if (!QuickAction.this.getActionItem(pos).isSticky()) {
                    QuickAction.this.mDidAction = true;
                    QuickAction.this.dismiss();
                }
            }
        });
        container.setFocusable(true);
        container.setClickable(true);
        if (this.mOrientation == 0 && this.mChildPos != 0) {
            View separator = this.mInflater.inflate(R.layout.horiz_separator, null);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
            separator.setLayoutParams((ViewGroup.LayoutParams)params);
            separator.setPadding(5, 0, 5, 0);
            this.mTrack.addView(separator, this.mInsertPos);
            ++this.mInsertPos;
        }
        this.mTrack.addView(container, this.mInsertPos);
        ++this.mChildPos;
        ++this.mInsertPos;
    }

    public void show(View anchor) {
        int yPos;
        boolean onTop;
        int arrowPos;
        int xPos;
        this.preShow();
        baseView = anchor;
        this.mDidAction = false;
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        Rect anchorRect = new Rect(location[0], location[1], location[0] + anchor.getWidth(), location[1] + anchor.getHeight());
        this.mRootView.measure(-2, -2);
        int rootHeight = this.mRootView.getMeasuredHeight();
        if (this.rootWidth == 0) {
            this.rootWidth = this.mRootView.getMeasuredWidth();
        }
        int screenWidth = this.mWindowManager.getDefaultDisplay().getWidth();
        int screenHeight = this.mWindowManager.getDefaultDisplay().getHeight();
        if (anchorRect.left + this.rootWidth > screenWidth) {
            xPos = anchorRect.left - (this.rootWidth - anchor.getWidth());
            xPos = xPos < 0 ? 0 : xPos;
            arrowPos = anchorRect.centerX() - xPos;
        } else {
            xPos = anchor.getWidth() > this.rootWidth ? anchorRect.centerX() - this.rootWidth / 2 : anchorRect.left;
            arrowPos = anchorRect.centerX() - xPos;
        }
        int dyTop = anchorRect.top;
        int dyBottom = screenHeight - anchorRect.bottom;
        boolean bl = onTop = dyTop > dyBottom;
        if (onTop) {
            if (rootHeight > dyTop) {
                yPos = 15;
                ViewGroup.LayoutParams l = this.mScroller.getLayoutParams();
                l.height = dyTop - anchor.getHeight();
            } else {
                yPos = anchorRect.top - rootHeight;
            }
        } else {
            yPos = anchorRect.bottom;
            if (rootHeight > dyBottom) {
                ViewGroup.LayoutParams l = this.mScroller.getLayoutParams();
                l.height = dyBottom;
            }
        }
        this.showArrow(onTop ? R.id.arrow_down : R.id.arrow_up, arrowPos);
        this.setAnimationStyle(screenWidth, anchorRect.centerX(), onTop);
        this.mWindow.showAtLocation(anchor, 0, xPos, yPos);
    }

    private void setAnimationStyle(int screenWidth, int requestedX, boolean onTop) {
        int arrowPos = requestedX - this.mArrowUp.getMeasuredWidth() / 2;
    }

    private void showArrow(int whichArrow, int requestedX) {
        ImageView showArrow = whichArrow == R.id.arrow_up ? this.mArrowUp : this.mArrowDown;
        ImageView hideArrow = whichArrow == R.id.arrow_up ? this.mArrowDown : this.mArrowUp;
        int arrowWidth = this.mArrowUp.getMeasuredWidth();
        showArrow.setVisibility(0);
        ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)showArrow.getLayoutParams();
        param.leftMargin = requestedX - arrowWidth / 2;
        hideArrow.setVisibility(4);
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.setOnDismissListener(this);
        this.mDismissListener = listener;
    }

    @Override
    public void onDismiss() {
        if (!this.mDidAction && this.mDismissListener != null) {
            this.isDismissed = true;
            Log.d((String)"Qick", (String)"Dismissed-inside");
            this.mDismissListener.onDismiss();
        }
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
    }

    public static interface OnActionItemClickListener {
        public void onItemClick(QuickAction var1, int var2, int var3);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

