/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.Build;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.HttpClientWebRequest;
import com.amazon.device.ads.HttpURLConnectionWebRequest;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

abstract class WebRequest {
    private static final String LOG_TAG = WebRequest.class.getSimpleName();
    private static final String HEADER_ACCEPT_KEY = "Accept";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_KEY = "charset";
    public static final int DEFAULT_TIMEOUT = 20000;
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_PLAIN_TEXT = "text/plain";
    public static final String CONTENT_TYPE_CSS = "text/css";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_JAVASCRIPT = "application/javascript";
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_UTF_16 = "UTF-16";
    public static final int DEFAULT_PORT = -1;
    String requestBody = null;
    String acceptContentType = null;
    String contentType = null;
    String charset = null;
    private String urlString = null;
    private String secureHost = null;
    private String nonSecureHost = null;
    private String path = null;
    private int port = -1;
    private HttpMethod httpMethod = HttpMethod.GET;
    private int timeout = 20000;
    private MetricsCollector metricsCollector;
    protected final HashMap<String, String> headers;
    protected QueryStringParameters queryStringParameters;
    protected HashMap<String, String> postParameters;
    boolean logRequestBodyEnabled = false;
    boolean logResponseEnabled = false;
    protected boolean logUrlEnabled = false;
    protected boolean secure = false;
    private String logTag = LOG_TAG;
    protected Metrics.MetricType serviceCallLatencyMetric;
    private static WebRequestFactory webRequestFactory = new WebRequestFactory();

    protected WebRequest() {
        this.queryStringParameters = new QueryStringParameters();
        this.headers = new HashMap();
        this.postParameters = new HashMap();
        boolean tlsEnabled = Settings.getInstance().getBoolean("tlsEnabled", false);
        this.secure = DebugProperties.getDebugPropertyAsBoolean("debug.tlsEnabled", tlsEnabled);
    }

    public static final WebRequest createNewWebRequest() {
        return webRequestFactory.createWebRequest();
    }

    static void setWebRequestFactory(WebRequestFactory webRequestFactory) {
        WebRequest.webRequestFactory = webRequestFactory;
    }

    public static final WebRequest createJSONGetWebRequest() {
        WebRequest request = WebRequest.createNewWebRequest();
        request.setHttpMethod(HttpMethod.GET);
        request.putHeader(HEADER_ACCEPT_KEY, CONTENT_TYPE_JSON);
        return request;
    }

    public static final WebRequest createJSONPostWebRequest() {
        WebRequest request = WebRequest.createNewWebRequest();
        request.convertToJSONPostRequest();
        return request;
    }

    public void convertToJSONPostRequest() {
        this.setHttpMethod(HttpMethod.POST);
        this.putHeader(HEADER_ACCEPT_KEY, CONTENT_TYPE_JSON);
        this.putHeader(HEADER_CONTENT_TYPE, "application/json; charset=UTF-8");
    }

    public WebResponse makeCall() throws WebRequestException {
        WebResponse response;
        URL url;
        if (ThreadUtils.isOnMainThread()) {
            Log.e(this.logTag, "The network request should not be performed on the main thread.");
        }
        this.setContentTypeHeaders();
        String urlString = this.getUrl();
        try {
            url = this.createURL(urlString);
        }
        catch (MalformedURLException e) {
            Log.e(this.logTag, "Problem with URI syntax: %s", e.getMessage());
            throw new WebRequestException(WebRequestStatus.MALFORMED_URL, "Could not construct URL from String " + urlString, e);
        }
        this.writeMetricStart(this.serviceCallLatencyMetric);
        try {
            response = this.doHttpNetworkCall(url);
        }
        catch (WebRequestException e) {
            throw e;
        }
        finally {
            this.writeMetricStop(this.serviceCallLatencyMetric);
        }
        return response;
    }

    protected abstract WebResponse doHttpNetworkCall(URL var1) throws WebRequestException;

    public void enableLogUrl(boolean enabled) {
        this.logUrlEnabled = enabled;
    }

    public void enableLogRequestBody(boolean enabled) {
        this.logRequestBodyEnabled = enabled;
    }

    public void enableLogResponse(boolean enabled) {
        this.logResponseEnabled = enabled;
    }

    public void enableLog(boolean enabled) {
        this.enableLogUrl(enabled);
        this.enableLogRequestBody(enabled);
        this.enableLogResponse(enabled);
    }

    protected void logUrl(String url) {
        if (this.logUrlEnabled) {
            Log.d(this.getLogTag(), "%s %s", new Object[]{this.getHttpMethod(), url});
        }
    }

    public String getQueryParameter(String name) {
        return this.queryStringParameters.get(name);
    }

    public void putUrlEncodedQueryParameter(String name, String value) {
        this.queryStringParameters.putUrlEncoded(name, value);
    }

    public String putUnencodedQueryParameter(String name, String value) {
        return this.queryStringParameters.putUnencoded(name, value);
    }

    public void setQueryStringParameters(QueryStringParameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
    }

    public String getPostParameter(String name) {
        if (Utils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        return this.postParameters.get(name);
    }

    public void putPostParameter(String name, String value) {
        if (Utils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        if (value == null) {
            this.postParameters.remove(name);
        } else {
            this.postParameters.put(name, value);
        }
    }

    public String getHeader(String name) {
        if (Utils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        return this.headers.get(name);
    }

    public void putHeader(String name, String value) {
        if (Utils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        this.headers.put(name, value);
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("The httpMethod must not be null.");
        }
        this.httpMethod = httpMethod;
    }

    public String getHost() {
        return this.secure ? this.secureHost : this.nonSecureHost;
    }

    public void setHost(String host) {
        if (Utils.isNullOrWhiteSpace(host)) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.secureHost = host;
        this.nonSecureHost = host;
    }

    public void setSecureHost(String secureHost) {
        if (Utils.isNullOrWhiteSpace(secureHost)) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.secureHost = secureHost;
    }

    public void setNonSecureHost(String nonSecureHost) {
        if (Utils.isNullOrWhiteSpace(nonSecureHost)) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.nonSecureHost = nonSecureHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean getUseSecure() {
        return this.secure;
    }

    public void setUseSecure(boolean secure) {
        this.secure = secure;
    }

    public void setUrlString(String urlString) {
        if (urlString != null && this.secure && urlString.startsWith("http:")) {
            urlString = urlString.replaceFirst("http", "https");
        }
        this.urlString = urlString;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setRequestBodyString(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getRequestBodyString() {
        return this.requestBody;
    }

    public String getRequestBody() {
        if (this.getRequestBodyString() != null) {
            return this.getRequestBodyString();
        }
        if (this.postParameters.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.postParameters.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append(";\n");
        }
        return builder.toString();
    }

    public void setAcceptContentType(String acceptContentType) {
        this.acceptContentType = this.contentType;
    }

    public String getAcceptContentType() {
        return this.acceptContentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public void setServiceCallLatencyMetric(Metrics.MetricType metric) {
        this.serviceCallLatencyMetric = metric;
    }

    public void setAdditionalQueryParamsString(String paramsString) {
        this.queryStringParameters.setRawAppendage(paramsString);
    }

    public void setExternalLogTag(String externalLogTag) {
        this.logTag = externalLogTag == null ? LOG_TAG + " " + this.getSubLogTag() : externalLogTag + " " + LOG_TAG + " " + this.getSubLogTag();
    }

    protected String getLogTag() {
        return this.logTag;
    }

    protected abstract String getSubLogTag();

    protected void setContentTypeHeaders() {
        if (this.acceptContentType != null) {
            this.putHeader(HEADER_ACCEPT_KEY, this.contentType);
        }
        if (this.contentType != null) {
            String contentType = this.contentType;
            if (this.charset != null) {
                contentType = contentType + "; charset=" + this.charset;
            }
            this.putHeader(HEADER_CONTENT_TYPE, contentType);
        }
    }

    protected void writeMetricStart(Metrics.MetricType metric) {
        if (metric != null && this.metricsCollector != null) {
            this.metricsCollector.startMetric(metric);
        }
    }

    protected void writeMetricStop(Metrics.MetricType metric) {
        if (metric != null && this.metricsCollector != null) {
            this.metricsCollector.stopMetric(metric);
        }
    }

    protected URI createUri() throws URISyntaxException, MalformedURLException {
        return new URL(this.getUrlString()).toURI();
    }

    protected URI createURI(String url) throws MalformedURLException, URISyntaxException {
        return this.createURI(this.createURL(url));
    }

    protected URI createURI(URL url) throws URISyntaxException {
        return url.toURI();
    }

    protected URL createURL(String urlString) throws MalformedURLException {
        return new URL(urlString);
    }

    protected void appendQuery(StringBuilder builder) {
        this.queryStringParameters.append(builder);
    }

    protected String getScheme() {
        if (this.getUseSecure()) {
            return "https";
        }
        return "http";
    }

    public String toString() {
        return this.getUrl();
    }

    protected String getUrl() {
        if (this.urlString != null) {
            return this.urlString;
        }
        StringBuilder builder = new StringBuilder(this.getScheme());
        builder.append("://");
        builder.append(this.getHost());
        if (this.getPort() != -1) {
            builder.append(":");
            builder.append(this.getPort());
        }
        builder.append(this.getPath());
        this.appendQuery(builder);
        return builder.toString();
    }

    public static final void executeWebRequestInThread(final String url) {
        ThreadUtils.executeRunnable(new Runnable(){

            public void run() {
                WebRequest request = WebRequest.createNewWebRequest();
                request.enableLog(true);
                request.setUrlString(url);
                try {
                    request.makeCall();
                }
                catch (WebRequestException webRequestException) {
                    // empty catch block
                }
            }
        });
    }

    static class QueryStringParameters {
        private final HashMap<String, String> params = new HashMap();
        private String rawAppendage;

        QueryStringParameters() {
        }

        int size() {
            return this.params.size();
        }

        void setRawAppendage(String rawAppendage) {
            this.rawAppendage = rawAppendage;
        }

        void putUrlEncoded(String param, boolean value) {
            this.putUrlEncoded(param, Boolean.toString(value));
        }

        void putUrlEncodedIfNotNullOrEmpty(String param, String value) {
            this.putUrlEncodedIfTrue(param, value, !Utils.isNullOrEmpty(value));
        }

        void putUrlEncodedIfTrue(String param, String value, boolean check) {
            if (check) {
                this.putUrlEncoded(param, value);
            }
        }

        String get(String name) {
            if (Utils.isNullOrWhiteSpace(name)) {
                throw new IllegalArgumentException("The name must not be null or empty string.");
            }
            return this.params.get(name);
        }

        void putUrlEncoded(String name, String value) {
            if (Utils.isNullOrWhiteSpace(name)) {
                throw new IllegalArgumentException("The name must not be null or empty string.");
            }
            if (value == null) {
                this.params.remove(name);
            } else {
                this.params.put(name, value);
            }
        }

        String putUnencoded(String name, String value) {
            String encodedName = Utils.getURLEncodedString(name);
            this.putUrlEncoded(encodedName, Utils.getURLEncodedString(value));
            return encodedName;
        }

        void append(StringBuilder builder) {
            if (this.size() == 0 && Utils.isNullOrEmpty(this.rawAppendage)) {
                return;
            }
            builder.append("?");
            boolean first = true;
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(param.getKey());
                builder.append("=");
                builder.append(param.getValue());
            }
            if (this.rawAppendage != null && !this.rawAppendage.equals("")) {
                if (this.size() != 0) {
                    builder.append("&");
                }
                builder.append(this.rawAppendage);
            }
        }
    }

    static class WebRequestFactory {
        WebRequestFactory() {
        }

        public WebRequest createWebRequest() {
            if (Build.VERSION.SDK_INT < 8) {
                return new HttpClientWebRequest();
            }
            return new HttpURLConnectionWebRequest();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebRequestStatus {
        NETWORK_FAILURE,
        NETWORK_TIMEOUT,
        MALFORMED_URL,
        INVALID_CLIENT_PROTOCOL,
        UNSUPPORTED_ENCODING;

    }

    public class WebRequestException
    extends Exception {
        private static final long serialVersionUID = -4980265484926465548L;
        private final WebRequestStatus status;

        protected WebRequestException(WebRequestStatus status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        protected WebRequestException(WebRequestStatus status, String message) {
            this(status, message, null);
        }

        public WebRequestStatus getStatus() {
            return this.status;
        }
    }

    public class WebResponse {
        private String body;
        private int httpStatusCode;
        private String httpStatus;
        private InputStream inputStream;
        private boolean logEnabled;
        private String logTag = WebRequest.access$000();

        protected WebResponse() {
        }

        public String getBody() {
            if (this.body == null) {
                this.readResponseString();
            }
            return this.body;
        }

        public JSONObject getJSONObjectBody() {
            if (this.getBody() == null) {
                return null;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(this.getBody());
            }
            catch (JSONException e) {
                Log.e(WebRequest.this.getLogTag(), "Unable to parse the body into a JSONObject.");
            }
            return jsonObject;
        }

        protected void setBody(String body) {
            this.body = body;
        }

        protected void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        protected void setLogTag(String logTag) {
            this.logTag = logTag;
        }

        protected void enableLog(boolean logEnabled) {
            this.logEnabled = logEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void readResponseString() {
            block15: {
                if (this.inputStream != null) {
                    int i;
                    StringBuilder out = new StringBuilder();
                    byte[] b = new byte[4096];
                    while ((i = this.inputStream.read(b)) != -1) {
                        out.append(new String(b, 0, i));
                    }
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        Log.e(this.logTag, "IOException while trying to close the stream");
                    }
                    this.setBody(out.toString());
                    if (this.logEnabled) {
                        Log.d(LOG_TAG, "Response: %s", this.getBody());
                    }
                    break block15;
                    catch (IOException e) {
                        try {
                            Log.e(this.logTag, "Unable to read the stream from the network.");
                        }
                        catch (Throwable throwable) {
                            try {
                                this.inputStream.close();
                            }
                            catch (IOException e2) {
                                Log.e(this.logTag, "IOException while trying to close the stream");
                            }
                            this.setBody(out.toString());
                            if (this.logEnabled) {
                                Log.d(LOG_TAG, "Response: %s", this.getBody());
                            }
                            throw throwable;
                        }
                        try {
                            this.inputStream.close();
                        }
                        catch (IOException e3) {
                            Log.e(this.logTag, "IOException while trying to close the stream");
                        }
                        this.setBody(out.toString());
                        if (this.logEnabled) {
                            Log.d(LOG_TAG, "Response: %s", this.getBody());
                        }
                    }
                }
            }
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        protected void setHttpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public boolean isHttpStatusCodeOK() {
            return this.getHttpStatusCode() == 200;
        }

        public String getHttpStatus() {
            return this.httpStatus;
        }

        protected void setHttpStatus(String httpStatus) {
            this.httpStatus = httpStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET("GET"),
        POST("POST");

        private final String methodString;

        private HttpMethod(String methodString) {
            this.methodString = methodString;
        }

        public String toString() {
            return this.methodString;
        }
    }
}

