/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdVideoPlayer;
import com.amazon.device.ads.Controller;
import com.amazon.device.ads.IAdActivityAdapter;

class VideoActionHandler
implements IAdActivityAdapter {
    private RelativeLayout layout;
    private AdVideoPlayer player;
    private Activity activity;

    VideoActionHandler() {
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void onCreate() {
        Bundle data = this.activity.getIntent().getExtras();
        this.layout = new RelativeLayout((Context)this.activity);
        this.layout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.activity.setContentView((View)this.layout);
        this.initPlayer(data);
        this.player.playVideo();
    }

    private void setPlayerListener(AdVideoPlayer player) {
        player.setListener(new AdVideoPlayer.AdVideoPlayerListener(){

            public void onError() {
                VideoActionHandler.this.activity.finish();
            }

            public void onComplete() {
                VideoActionHandler.this.activity.finish();
            }
        });
    }

    private void initPlayer(Bundle data) {
        RelativeLayout.LayoutParams lp;
        Controller.PlayerProperties props = (Controller.PlayerProperties)data.getParcelable("player_properties");
        Controller.Dimensions dimensions = (Controller.Dimensions)data.getParcelable("player_dimensions");
        this.player = new AdVideoPlayer((Context)this.activity);
        this.player.setPlayData(props, data.getString("url"));
        if (dimensions == null) {
            lp = new RelativeLayout.LayoutParams(-1, -1);
            lp.addRule(13);
        } else {
            lp = new RelativeLayout.LayoutParams(dimensions.width, dimensions.height);
            lp.topMargin = dimensions.y;
            lp.leftMargin = dimensions.x;
        }
        this.player.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.player.setViewGroup((ViewGroup)this.layout);
        this.setPlayerListener(this.player);
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
        this.player.releasePlayer();
        this.player = null;
        this.activity.finish();
    }

    public void preOnCreate() {
    }
}

