/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class Utils {
    private static final String LOG_TAG = Utils.class.getSimpleName();
    private static final String DISABLED_APP_SERVER_MESSAGE = "DISABLED_APP";
    private static int[][] rotationArray = new int[][]{{1, 0, 9, 8}, {0, 9, 8, 1}};

    private Utils() {
    }

    public static String sha1(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i] | 0x100).substring(1));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static int parseInt(String string, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static int determineCanonicalScreenOrientation() {
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int rotation = AndroidTargetUtils.getOrientation(display);
        int orientation = context.getResources().getConfiguration().orientation;
        boolean naturalOrientationIsPortrait = false;
        naturalOrientationIsPortrait = orientation == 1 ? rotation == 0 || rotation == 2 : (orientation == 2 ? rotation == 1 || rotation == 3 : true);
        int rotationSelector = naturalOrientationIsPortrait ? 0 : 1;
        return rotationArray[rotationSelector][rotation];
    }

    public static final String getURLEncodedString(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            Log.d(LOG_TAG, "getURLEncodedString threw: %s", e);
            return s;
        }
    }

    public static final String getURLDecodedString(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.d(LOG_TAG, "getURLDecodedString threw: %s", e);
            return s;
        }
    }

    public static final long convertToMillisecondsFromNanoseconds(long nanoseconds) {
        return nanoseconds / 1000000L;
    }

    public static final long convertToNsFromS(long seconds) {
        return seconds * 1000000000L;
    }

    public static final boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    public static final boolean isNullOrWhiteSpace(String s) {
        return Utils.isNullOrEmpty(s) || s.trim().equals("");
    }

    public static boolean isAtLeastAndroidAPI(int api) {
        return Build.VERSION.SDK_INT >= api;
    }

    public static final String getDisabledAppServerMessage() {
        return DISABLED_APP_SERVER_MESSAGE;
    }
}

