/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.amazon.device.ads.AndroidTargetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtils {
    private static RunnableExecutor runnableExecutor = new BackgroundThreadRunnableExecutor();

    public static boolean isOnMainThread() {
        return ThreadVerify.getInstance().isOnMainThread();
    }

    public static final <T> void executeAsyncTask(final AsyncTask<T, ?, ?> task, final T ... params) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            AndroidTargetUtils.executeAsyncTask(task, params);
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                public void run() {
                    AndroidTargetUtils.executeAsyncTask(task, params);
                }
            });
        }
    }

    public static void executeRunnable(Runnable proc) {
        runnableExecutor.execute(proc);
    }

    static void setRunnableExecutor(RunnableExecutor runnableExecutor) {
        ThreadUtils.runnableExecutor = runnableExecutor;
    }

    static class ThreadVerify {
        private static ThreadVerify instance = new ThreadVerify();

        ThreadVerify() {
        }

        static ThreadVerify getInstance() {
            return instance;
        }

        static void setInstance(ThreadVerify threadVerify) {
            instance = threadVerify;
        }

        boolean isOnMainThread() {
            return Looper.getMainLooper().getThread() == Thread.currentThread();
        }
    }

    static class BackgroundThreadRunnableExecutor
    implements RunnableExecutor {
        BackgroundThreadRunnableExecutor() {
        }

        public void execute(Runnable proc) {
            Thread thread = new Thread(proc);
            thread.start();
        }
    }

    static class MainThreadRunnableExecutor
    implements RunnableExecutor {
        MainThreadRunnableExecutor() {
        }

        public void execute(Runnable proc) {
            Handler h = new Handler(Looper.getMainLooper());
            h.post(proc);
        }
    }

    static interface RunnableExecutor {
        public void execute(Runnable var1);
    }
}

