/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

class Size {
    private final int width;
    private final int height;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size(String screenSize) {
        String[] dimensions;
        int width = 0;
        int height = 0;
        if (screenSize != null && (dimensions = screenSize.split("x")) != null && dimensions.length == 2) {
            width = Math.max(Size.parseInt(dimensions[0], 0), 0);
            height = Math.max(Size.parseInt(dimensions[1], 0), 0);
        }
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }

    private static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }
}

