/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.ThreadUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Settings {
    private static final String LOG_TAG = Settings.class.getSimpleName();
    private static final String PREFS_NAME = "AmazonMobileAds";
    private static Settings instance = new Settings();
    public static final String SETTING_ENABLE_WEBVIEW_PAUSE_LOGIC = "shouldPauseWebViewTimersInWebViewRelatedActivities";
    protected static final String SETTING_TESTING_ENABLED = "testingEnabled";
    protected static final String SETTING_TLS_ENABLED = "tlsEnabled";
    private ArrayList<SettingsListener> listeners = new ArrayList();
    private final ReentrantLock listenersLock = new ReentrantLock();
    private final ReentrantLock writeToSharedPreferencesLock = new ReentrantLock();
    private final ConcurrentHashMap<String, Value> cache;
    private SharedPreferences sharedPreferences;
    private final CountDownLatch settingsLoadedLatch = new CountDownLatch(1);

    protected Settings() {
        this.cache = new ConcurrentHashMap();
    }

    public static Settings getInstance() {
        return instance;
    }

    protected static void reset() {
        instance = new Settings();
    }

    protected static void setInstance(Settings settings) {
        instance = settings;
    }

    public void contextReceived(Context context) {
        if (context == null) {
            return;
        }
        this.beginFetch(context);
    }

    protected void beginFetch(final Context context) {
        ThreadUtils.executeRunnable(new Runnable(){

            public void run() {
                Settings.this.fetchSharedPreferences(context);
            }
        });
    }

    public boolean isSettingsLoaded() {
        return this.sharedPreferences != null;
    }

    public void listenForSettings(SettingsListener listener) {
        this.listenersLock.lock();
        if (this.isSettingsLoaded()) {
            listener.settingsLoaded();
        } else {
            this.listeners.add(listener);
        }
        this.listenersLock.unlock();
    }

    protected SharedPreferences getSharedPreferencesFromContext(Context context) {
        return context.getSharedPreferences(PREFS_NAME, 0);
    }

    protected SharedPreferences getSharedPreferences() {
        return this.sharedPreferences;
    }

    protected ConcurrentHashMap<String, Value> getCache() {
        return this.cache;
    }

    private void putSetting(String key, Value value) {
        this.putSettingWithNoFlush(key, value);
        if (!value.isTransientData && this.isSettingsLoaded()) {
            this.flush();
        }
    }

    private void putSettingWithNoFlush(String key, Value value) {
        this.cache.put(key, value);
    }

    protected void readSharedPreferencesIntoCache(SharedPreferences sharedPreferences) {
        Map entries = sharedPreferences.getAll();
        this.cacheAdditionalEntries(entries);
    }

    protected void cacheAdditionalEntries(Map<String, ?> entries) {
        for (Map.Entry<String, ?> entry : entries.entrySet()) {
            String key = entry.getKey();
            if (key == null || this.cache.containsKey(key)) continue;
            Object value = entry.getValue();
            this.cache.put(key, new Value(value.getClass(), value));
        }
    }

    private void writeCacheToSharedPreferences() {
        this.writeCacheToSharedPreferences(this.sharedPreferences);
    }

    protected void writeCacheToSharedPreferences(final SharedPreferences sharedPreferences) {
        ThreadUtils.executeRunnable(new Runnable(){

            public void run() {
                Settings.this.writeToSharedPreferencesLock.lock();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.clear();
                for (Map.Entry entry : Settings.this.cache.entrySet()) {
                    Value value = (Value)entry.getValue();
                    if (value.isTransientData) continue;
                    if (value.clazz == String.class) {
                        editor.putString((String)entry.getKey(), (String)value.value);
                        continue;
                    }
                    if (value.clazz == Long.class) {
                        editor.putLong((String)entry.getKey(), ((Long)value.value).longValue());
                        continue;
                    }
                    if (value.clazz == Integer.class) {
                        editor.putInt((String)entry.getKey(), ((Integer)value.value).intValue());
                        continue;
                    }
                    if (value.clazz != Boolean.class) continue;
                    editor.putBoolean((String)entry.getKey(), ((Boolean)value.value).booleanValue());
                }
                Settings.this.commit(editor);
                Settings.this.writeToSharedPreferencesLock.unlock();
            }
        });
    }

    public void flush() {
        this.writeCacheToSharedPreferences();
    }

    public boolean containsKey(String key) {
        return this.cache.containsKey(key);
    }

    public String getString(String key, String defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value.value;
    }

    public void putString(String key, String value) {
        this.putSetting(key, new Value(String.class, value));
    }

    public void putStringWithNoFlush(String key, String value) {
        this.putSettingWithNoFlush(key, new Value(String.class, value));
    }

    public void putTransientString(String key, String value) {
        this.putSettingWithNoFlush(key, new TransientValue(String.class, value));
    }

    public int getInt(String key, int defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value.value;
    }

    public void putInt(String key, int value) {
        this.putSetting(key, new Value(Integer.class, value));
    }

    public void putIntWithNoFlush(String key, int value) {
        this.putSettingWithNoFlush(key, new Value(Integer.class, value));
    }

    public void putTransientInt(String key, int value) {
        this.putSettingWithNoFlush(key, new TransientValue(Integer.class, value));
    }

    public long getLong(String key, long defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Long)value.value;
    }

    public void putLong(String key, long value) {
        this.putSetting(key, new Value(Long.class, value));
    }

    public void putLongWithNoFlush(String key, long value) {
        this.putSettingWithNoFlush(key, new Value(Long.class, value));
    }

    public void putTransientLong(String key, long value) {
        this.putSettingWithNoFlush(key, new TransientValue(Long.class, value));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean value = this.getBoolean(key, null);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value.value;
    }

    public void putBoolean(String key, boolean value) {
        this.putSetting(key, new Value(Boolean.class, value));
    }

    public void putBooleanWithNoFlush(String key, boolean value) {
        this.putSettingWithNoFlush(key, new Value(Boolean.class, value));
    }

    public void putTransientBoolean(String key, boolean value) {
        this.putSettingWithNoFlush(key, new TransientValue(Boolean.class, value));
    }

    public void remove(String key) {
        Value value = this.cache.remove(key);
        if (value != null && !value.isTransientData && this.isSettingsLoaded()) {
            this.flush();
        }
    }

    public void removeWithNoFlush(String key) {
        this.cache.remove(key);
    }

    private void commit(SharedPreferences.Editor editor) {
        if (ThreadUtils.isOnMainThread()) {
            Log.e(LOG_TAG, "Committing settings must be executed on a background thread.");
        }
        if (Build.VERSION.SDK_INT >= 9) {
            AndroidTargetUtils.editorApply(editor);
        } else {
            editor.commit();
        }
    }

    protected void notifySettingsListeners() {
        this.listenersLock.lock();
        for (SettingsListener listener : this.listeners) {
            listener.settingsLoaded();
        }
        this.listeners.clear();
        this.listeners = null;
        this.listenersLock.unlock();
    }

    protected void fetchSharedPreferences(Context context) {
        if (!this.isSettingsLoaded()) {
            SharedPreferences sharedPreferences = this.getSharedPreferencesFromContext(context);
            this.readSharedPreferencesIntoCache(sharedPreferences);
            this.sharedPreferences = sharedPreferences;
            this.writeCacheToSharedPreferences(sharedPreferences);
        }
        this.settingsLoadedLatch.countDown();
        this.notifySettingsListeners();
    }

    static interface SettingsListener {
        public void settingsLoaded();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransientValue
    extends Value {
        public TransientValue(Class<?> clazz, Object value) {
            super(clazz, value);
            this.isTransientData = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Value {
        public Class<?> clazz;
        public Object value;
        public boolean isTransientData;

        public Value(Class<?> clazz, Object value) {
            this.clazz = clazz;
            this.value = value;
        }
    }
}

