/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.AppEventRegistrationHandler;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISRequest;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SISRegisterEventRequest
implements SISRequest {
    private static final String LOG_TAG = "SISRegisterEventRequest";
    private static final Metrics.MetricType CALL_METRIC_TYPE = Metrics.MetricType.SIS_LATENCY_REGISTER_EVENT;
    private static final String PATH = "/register_event";
    private final AdvertisingIdentifier.Info advertisingIdentifierInfo;
    private final JSONArray appEvents;

    public SISRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents) {
        this.advertisingIdentifierInfo = advertisingIdentifierInfo;
        this.appEvents = appEvents;
    }

    @Override
    public String getLogTag() {
        return LOG_TAG;
    }

    @Override
    public Metrics.MetricType getCallMetricType() {
        return CALL_METRIC_TYPE;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public WebRequest.QueryStringParameters getQueryParameters() {
        WebRequest.QueryStringParameters queryStringParameters = new WebRequest.QueryStringParameters();
        queryStringParameters.putUrlEncoded("adId", this.advertisingIdentifierInfo.getSISDeviceIdentifier());
        queryStringParameters.putUrlEncoded("dt", DeviceInfo.getDeviceType());
        RegistrationInfo registrationInfo = InternalAdRegistration.getInstance().getRegistrationInfo();
        queryStringParameters.putUrlEncoded("app", registrationInfo.getAppName());
        queryStringParameters.putUrlEncoded("appId", registrationInfo.getAppKey());
        queryStringParameters.putUrlEncoded("aud", Configuration.getInstance().getString(Configuration.ConfigOption.SIS_DOMAIN));
        return queryStringParameters;
    }

    @Override
    public HashMap<String, String> getPostParameters() {
        HashMap<String, String> eventsMap = new HashMap<String, String>();
        eventsMap.put("events", this.appEvents.toString());
        return eventsMap;
    }

    @Override
    public void onResponseReceived(JSONObject payload) {
        int statusCode = JSONUtils.getIntegerFromJSON(payload, "rcode", 0);
        if (statusCode == 1) {
            Log.d(LOG_TAG, "Application events registered successfully.");
            AppEventRegistrationHandler.getInstance().onAppEventsRegistered();
        } else {
            Log.d(LOG_TAG, "Application events not registered. rcode:" + statusCode);
        }
    }
}

