/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectionCache {
    private static ReflectionCache instance = new ReflectionCache();
    private final HashMap<String, Class<?>> cachedClasses = new HashMap();

    private ReflectionCache() {
    }

    public static ReflectionCache getInstance() {
        return instance;
    }

    public Class<?> getClass(String className) {
        Class<?> classType;
        if (this.cachedClasses.containsKey(className)) {
            return this.cachedClasses.get(className);
        }
        try {
            classType = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        this.cachedClasses.put(className, classType);
        return classType;
    }

    protected static <T> T invoke(String methodName, Class<?> classType, Object receiver, T defaultValue, Class<?>[] paramTypes, Object[] params) throws Throwable {
        Method method;
        try {
            method = classType.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        try {
            return (T)method.invoke(receiver, params);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return defaultValue;
    }
}

