/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Log;

class PermissionChecker {
    private static final String LOG_TAG = PermissionChecker.class.getSimpleName();
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static PermissionChecker INSTANCE = new PermissionChecker();
    private boolean isInternetPermissionPresent = false;

    protected PermissionChecker() {
    }

    static PermissionChecker getInstance() {
        return INSTANCE;
    }

    protected static void setInstance(PermissionChecker instance) {
        INSTANCE = instance;
    }

    public final boolean passesInternetPermissionCheck(Context context) {
        return this.passesInternetPermissionCheck(context, null);
    }

    public final boolean passesInternetPermissionCheck(Context context, String logtag) {
        if (this.isInternetPermissionPresent) {
            return true;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return PermissionChecker.permissionCheckErrorCondition();
        }
        String path = AndroidTargetUtils.getPackageCodePath(context);
        if (path == null) {
            return PermissionChecker.permissionCheckErrorCondition();
        }
        PackageManager pManager = context.getPackageManager();
        if (pManager == null) {
            return PermissionChecker.permissionCheckErrorCondition();
        }
        PackageInfo info = pManager.getPackageArchiveInfo(path, 4096);
        if (info == null) {
            return PermissionChecker.permissionCheckErrorCondition();
        }
        String[] permissions = info.requestedPermissions;
        if (permissions == null) {
            return PermissionChecker.permissionCheckErrorCondition();
        }
        for (String permission : permissions) {
            if (!permission.equals(INTERNET_PERMISSION)) continue;
            this.isInternetPermissionPresent = true;
            return true;
        }
        if (logtag != null) {
            Log.e(logtag, "Network task cannot commence because the INTERNET permission is missing from the app's manifest.");
        }
        return false;
    }

    private static final boolean permissionCheckErrorCondition() {
        Log.d(LOG_TAG, "App permissions were not read.");
        return true;
    }
}

