/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.AdView;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.MraidBrowserController;
import com.amazon.device.ads.MraidCommand;
import com.amazon.device.ads.MraidCommandRegistry;
import com.amazon.device.ads.MraidDisplayController;
import com.amazon.device.ads.MraidPlacementTypeProperty;
import com.amazon.device.ads.MraidProperty;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebViewFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"ViewConstructor"})
class MraidView
extends FrameLayout {
    private static final String LOGTAG = MraidView.class.getSimpleName();
    private static final String JAVASCRIPT_TEXT = "(function(){var mraidbridge=window.mraidbridge={};var listeners={};var nativeCallQueue=[];var nativeCallInFlight=false;mraidbridge.fireReadyEvent=function(){mraidbridge.fireEvent('ready')};mraidbridge.fireChangeEvent=function(properties){mraidbridge.fireEvent('change',properties)};mraidbridge.fireErrorEvent=function(message,action){mraidbridge.fireEvent('error',message,action)};mraidbridge.fireEvent=function(type){var ls=listeners[type];if(ls){var args=Array.prototype.slice.call(arguments);args.shift();var l=ls.length;for(var i=0;i<l;i++){ls[i].apply(null,args)}}};mraidbridge.nativeCallComplete=function(command){if(nativeCallQueue.length===0){nativeCallInFlight=false;return}var nextCall=nativeCallQueue.pop();window.location=nextCall};mraidbridge.executeNativeCall=function(command){var call='mraid://'+command;var key,value;var isFirstArgument=true;for(var i=1;i<arguments.length;i+=2){key=arguments[i];value=arguments[i+1];if(value===null)continue;if(isFirstArgument){call+='?';isFirstArgument=false}else{call+='&'}call+=key+'='+escape(value)}if(nativeCallInFlight){nativeCallQueue.push(call)}else{nativeCallInFlight=true;window.location=call}};mraidbridge.addEventListener=function(event,listener){var eventListeners;listeners[event]=listeners[event]||[];eventListeners=listeners[event];for(var l in eventListeners){if(listener===l)return}eventListeners.push(listener)};mraidbridge.removeEventListener=function(event,listener){if(listeners.hasOwnProperty(event)){var eventListeners=listeners[event];if(eventListeners){var idx=eventListeners.indexOf(listener);if(idx!==-1){eventListeners.splice(idx,1)}}}}}());(function(){var mraid=window.mraid={};var bridge=window.mraidbridge;var VERSION=mraid.VERSION='1.0';var STATES=mraid.STATES={LOADING:'loading',DEFAULT:'default',EXPANDED:'expanded',HIDDEN:'hidden',};var EVENTS=mraid.EVENTS={ERROR:'error',INFO:'info',READY:'ready',STATECHANGE:'stateChange',VIEWABLECHANGE:'viewableChange'};var PLACEMENT_TYPES=mraid.PLACEMENT_TYPES={UNKNOWN:'unknown',INLINE:'inline',INTERSTITIAL:'interstitial'};var LOG_LEVELS=mraid.LOG_LEVELS={INFO:4,DEBUG:3,VERBOSE:2,WARNING:5,ERROR:6};var expandProperties={width:-1,height:-1,useCustomClose:false,isModal:true,lockOrientation:true};var hasSetCustomSize=false;var hasSetCustomClose=false;var listeners={};var state=STATES.LOADING;var isViewable=false;var screenSize={width:-1,height:-1};var placementType=PLACEMENT_TYPES.UNKNOWN;var EventListeners=function(event){this.event=event;this.count=0;var listeners={};this.add=function(func){var id=String(func);if(!listeners[id]){listeners[id]=func;this.count++}};this.remove=function(func){var id=String(func);if(listeners[id]){listeners[id]=null;delete listeners[id];this.count--;return true}else{return false}};this.removeAll=function(){for(var id in listeners){if(listeners.hasOwnProperty(id))this.remove(listeners[id])}};this.broadcast=function(args){for(var id in listeners){if(listeners.hasOwnProperty(id))listeners[id].apply({},args)}};this.toString=function(){var out=[event,':'];for(var id in listeners){if(listeners.hasOwnProperty(id))out.push('|',id,'|')}return out.join('')}};var broadcastEvent=function(){var args=new Array(arguments.length);var l=arguments.length;for(var i=0;i<l;i++)args[i]=arguments[i];var event=args.shift();if(listeners[event])listeners[event].broadcast(args)};var contains=function(value,array){for(var i in array){if(array[i]===value)return true}return false};var clone=function(obj){if(obj===null)return null;var f=function(){};f.prototype=obj;return new f()};var stringify=function(obj){if(typeof obj==='object'){var out=[];if(obj.push){for(var p in obj)out.push(obj[p]);return'['+out.join(',')+']'}else{for(var p in obj)out.push(\"'\"+p+\"': \"+obj[p]);return'{'+out.join(',')+'}'}}else return String(obj)};var trim=function(str){return str.replace(/^\\s+|\\s+$/g,'')};var changeHandlers={state:function(val){if(state===STATES.LOADING){broadcastEvent(EVENTS.INFO,'Native SDK initialized.')}state=val;broadcastEvent(EVENTS.INFO,'Set state to '+stringify(val));broadcastEvent(EVENTS.STATECHANGE,state)},viewable:function(val){isViewable=val;broadcastEvent(EVENTS.INFO,'Set isViewable to '+stringify(val));broadcastEvent(EVENTS.VIEWABLECHANGE,isViewable)},placementType:function(val){broadcastEvent(EVENTS.INFO,'Set placementType to '+stringify(val));placementType=val},screenSize:function(val){broadcastEvent(EVENTS.INFO,'Set screenSize to '+stringify(val));for(var key in val){if(val.hasOwnProperty(key))screenSize[key]=val[key]}if(!hasSetCustomSize){expandProperties['width']=screenSize['width'];expandProperties['height']=screenSize['height']}},expandProperties:function(val){broadcastEvent(EVENTS.INFO,'Merging expandProperties with '+stringify(val));for(var key in val){if(val.hasOwnProperty(key))expandProperties[key]=val[key]}}};var validate=function(obj,validators,action,merge){if(!merge){if(obj===null){broadcastEvent(EVENTS.ERROR,'Required object not provided.',action);return false}else{for(var i in validators){if(validators.hasOwnProperty(i)&&obj[i]===undefined){broadcastEvent(EVENTS.ERROR,'Object is missing required property: '+i+'.',action);return false}}}}for(var prop in obj){var validator=validators[prop];var value=obj[prop];if(validator&&!validator(value)){broadcastEvent(EVENTS.ERROR,'Value of property '+prop+' is invalid.',action);return false}}return true};var expandPropertyValidators={width:function(v){return!isNaN(v)&&v>=0},height:function(v){return!isNaN(v)&&v>=0},useCustomClose:function(v){return(typeof v==='boolean')},lockOrientation:function(v){return(typeof v==='boolean')}};bridge.addEventListener('change',function(properties){for(var p in properties){if(properties.hasOwnProperty(p)){var handler=changeHandlers[p];handler(properties[p])}}});bridge.addEventListener('error',function(message,action){broadcastEvent(EVENTS.ERROR,message,action)});bridge.addEventListener('ready',function(){broadcastEvent(EVENTS.READY)});mraid.addEventListener=function(event,listener){if(!event||!listener){broadcastEvent(EVENTS.ERROR,'Both event and listener are required.','addEventListener')}else if(!contains(event,EVENTS)){broadcastEvent(EVENTS.ERROR,'Unknown MRAID event: '+event,'addEventListener')}else{if(!listeners[event])listeners[event]=new EventListeners(event);listeners[event].add(listener)}};mraid.close=function(){if(state===STATES.HIDDEN){broadcastEvent(EVENTS.ERROR,'Ad cannot be closed when it is already hidden.','close')}else bridge.executeNativeCall('close')};mraid.playVideo=function(URL,properties){if(state==STATES.DEFAULT||state==STATES.EXPANDED){var args=['playVideo'];if(URL){args=args.concat(['url',URL])}var audioMuted=false,autoPlay=true,controls=true,loop=false,position=[-1,-1,-1,-1],startStyle='normal',stopStyle='normal';if(properties){if((typeof properties.audio!=\"undefined\")&&(properties.audio!=null)){audioMuted=properties.audio}if((typeof properties.autoplay!=\"undefined\")&&(properties.autoplay!=null)){autoPlay=properties.autoplay}if((typeof properties.controls!=\"undefined\")&&(properties.controls!=null)){controls=properties.controls}if((typeof properties.loop!=\"undefined\")&&(properties.loop!=null)){loop=properties.loop}if((typeof properties.position!=\"undefined\")&&(properties.position!=null)){inline=new Array(4);inline[0]=properties.position.top;inline[1]=properties.position.left;if((typeof properties.position.width!=\"undefined\")&&(properties.position.width!=null)){inline[2]=properties.position.width}if((typeof properties.position.height!=\"undefined\")&&(properties.position.height!=null)){inline[3]=properties.position.height}position=inline}if((typeof properties.startStyle!=\"undefined\")&&(properties.startStyle!=null)){startStyle=properties.startStyle}if((typeof properties.stopStyle!=\"undefined\")&&(properties.stopStyle!=null)){stopStyle=properties.stopStyle}if(loop){stopStyle='normal';controls=true}if(!autoPlay){controls=true}if(!controls){stopStyle='exit'}if(position[0]==-1||position[1]==-1){startStyle='fullscreen';autoPlay=true}args=args.concat(['audioMuted',audioMuted]);args=args.concat(['autoPlay',autoPlay]);args=args.concat(['controls',controls]);args=args.concat(['loop',loop]);args=args.concat(['position',position]);args=args.concat(['startStyle',startStyle]);args=args.concat(['stopStyle',stopStyle])}bridge.executeNativeCall.apply(this,args)}};mraid.log=function(level,log){var args=['log','level',level,'log',log];bridge.executeNativeCall.apply(this,args)};mraid.expand=function(URL){if(state!==STATES.DEFAULT){broadcastEvent(EVENTS.ERROR,'Ad can only be expanded from the default state.','expand')}else{var args=['expand'];if(hasSetCustomClose){args=args.concat(['shouldUseCustomClose',expandProperties.useCustomClose?'true':'false'])}if(hasSetCustomSize){if(expandProperties.width>=0&&expandProperties.height>=0){args=args.concat(['w',expandProperties.width,'h',expandProperties.height])}}if(typeof expandProperties.lockOrientation!=='undefined'){args=args.concat(['lockOrientation',expandProperties.lockOrientation])}if(URL){args=args.concat(['url',URL])}bridge.executeNativeCall.apply(this,args)}};mraid.getExpandProperties=function(){var properties={width:expandProperties.width,height:expandProperties.height,useCustomClose:expandProperties.useCustomClose,isModal:expandProperties.isModal};return properties};mraid.getPlacementType=function(){return placementType};mraid.getState=function(){return state};mraid.getVersion=function(){return mraid.VERSION};mraid.isViewable=function(){return isViewable};mraid.open=function(URL){if(!URL)broadcastEvent(EVENTS.ERROR,'URL is required.','open');else bridge.executeNativeCall('open','url',URL)};mraid.removeEventListener=function(event,listener){if(!event)broadcastEvent(EVENTS.ERROR,'Event is required.','removeEventListener');else{if(listener&&(!listeners[event]||!listeners[event].remove(listener))){broadcastEvent(EVENTS.ERROR,'Listener not currently registered for event.','removeEventListener');return}else if(listeners[event])listeners[event].removeAll();if(listeners[event]&&listeners[event].count===0){listeners[event]=null;delete listeners[event]}}};mraid.setExpandProperties=function(properties){if(validate(properties,expandPropertyValidators,'setExpandProperties',true)){if(properties.hasOwnProperty('width')||properties.hasOwnProperty('height')){hasSetCustomSize=true}if(properties.hasOwnProperty('useCustomClose'))hasSetCustomClose=true;var desiredProperties=['width','height','useCustomClose','lockOrientation'];var length=desiredProperties.length;for(var i=0;i<length;i++){var propname=desiredProperties[i];if(properties.hasOwnProperty(propname))expandProperties[propname]=properties[propname]}}};mraid.useCustomClose=function(shouldUseCustomClose){expandProperties.useCustomClose=shouldUseCustomClose;hasSetCustomClose=true;bridge.executeNativeCall('usecustomclose','shouldUseCustomClose',shouldUseCustomClose)}}());";
    private static HashMap<String, MraidView> mraidViewCache;
    private MraidBrowserController mBrowserController;
    private MraidDisplayController mDisplayController;
    private WebViewClient mWebViewClient;
    private WebChromeClient mWebChromeClient;
    private boolean mHasFiredReadyEvent;
    private final PlacementType mPlacementType;
    private MraidListenerInfo mListenerInfo;
    private boolean mAttached = false;
    private int mLastVisibility = 8;
    protected boolean shouldForceRenderFailure = false;
    private boolean mGoingAway = false;
    private int windowWidth_;
    private int windowHeight_;
    protected double scalingMultiplier_;
    protected AdView adView;
    private Context context_;
    private WebView webView_;

    public WebView getWebView() {
        return this.webView_;
    }

    public MraidView(AdView adView, Context context, WebView webView) {
        this(adView, 0, 0, 0.0, context, webView, ExpansionStyle.DISABLED, NativeCloseButtonStyle.ALWAYS_HIDDEN, PlacementType.INLINE);
    }

    public MraidView(AdView adView, int windowWidth, int windowHeight, double scalingMultiplier, Context context, WebView webView) {
        this(adView, windowWidth, windowHeight, scalingMultiplier, context, webView, ExpansionStyle.ENABLED, NativeCloseButtonStyle.AD_CONTROLLED, PlacementType.INLINE);
    }

    MraidView(AdView adView, int windowWidth, int windowHeight, double scalingMultiplier, Context context, WebView webView, ExpansionStyle expStyle, NativeCloseButtonStyle buttonStyle, PlacementType placementType) {
        super(context);
        this.adView = adView;
        this.mPlacementType = placementType;
        this.windowHeight_ = windowHeight;
        this.windowWidth_ = windowWidth;
        this.scalingMultiplier_ = scalingMultiplier;
        this.context_ = context;
        this.webView_ = webView;
        this.setWebViewHeightToAdHeight();
        this.addView((View)this.webView_);
        if (Build.VERSION.SDK_INT >= 11 && this.shouldDisableWebViewHardwareAcceleration()) {
            this.disableHardwareAcceleration();
        }
        this.initialize(expStyle, buttonStyle);
    }

    protected void disableHardwareAcceleration() {
        AndroidTargetUtils.disableHardwareAcceleration((View)this);
    }

    protected void setWebViewHeightToAdHeight() {
        int height = (int)((double)this.adView.getHeight() * this.scalingMultiplier_ * (double)InternalAdRegistration.getInstance().getDeviceInfo().getScalingFactorAsFloat());
        if (height > 0) {
            this.setWebViewLayoutParams(-1, height);
        }
    }

    protected void setWebViewLayoutParams(int width, int height) {
        this.webView_.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
    }

    protected void initialize(ExpansionStyle expStyle, NativeCloseButtonStyle buttonStyle) {
        this.mBrowserController = new MraidBrowserController(this);
        this.mDisplayController = new MraidDisplayController(this, expStyle, buttonStyle);
        this.webView_.setScrollContainer(false);
        this.webView_.setBackgroundColor(0);
        this.webView_.setVerticalScrollBarEnabled(false);
        this.webView_.setHorizontalScrollBarEnabled(false);
        this.shouldForceRenderFailure = !WebViewFactory.setJavaScriptEnabledForWebView(true, this.webView_, LOGTAG);
        this.setupAdWebViewClient();
        this.mWebChromeClient = new MraidWebChromeClient();
        this.webView_.setWebChromeClient(this.mWebChromeClient);
        this.mListenerInfo = new MraidListenerInfo();
    }

    protected int getWindowWidth() {
        return this.windowWidth_;
    }

    protected int getWindowHeight() {
        return this.windowHeight_;
    }

    protected double getScalingMultiplier() {
        return this.scalingMultiplier_;
    }

    protected AdView getAdView() {
        return this.adView;
    }

    public void setAdView(AdView adView) {
        this.adView = adView;
        this.setWebViewHeightToAdHeight();
        this.setupAdWebViewClient();
    }

    public boolean getShouldForceRenderFailure() {
        return this.shouldForceRenderFailure;
    }

    private void setupAdWebViewClient() {
        AdWebViewClient adWebViewClient = new AdWebViewClient(this.adView, this.context_);
        adWebViewClient.putUrlExecutor("mraid", this.createMraidExecutor());
        adWebViewClient.putUrlExecutor("amazonmobile", this.adView.getSpecialUrlExecutor());
        this.mWebViewClient = adWebViewClient;
        this.setWebViewsWebViewClient(this.mWebViewClient);
    }

    protected void setWebViewsWebViewClient(WebViewClient webViewClient) {
        this.webView_.setWebViewClient(webViewClient);
    }

    protected MraidExecutor createMraidExecutor() {
        return new MraidExecutor();
    }

    protected void onAttachedToWindow() {
        if (this.mGoingAway) {
            return;
        }
        super.onAttachedToWindow();
        this.mAttached = true;
        if (this.mDisplayController != null) {
            this.mDisplayController.registerReceivers();
        }
    }

    public void prepareToGoAway() {
        this.mGoingAway = true;
        if (this.mDisplayController != null) {
            this.mDisplayController.detachExpandedView();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttached = false;
        if (this.mDisplayController != null) {
            this.mDisplayController.unregisterReceivers();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (this.mAttached && this.mLastVisibility != visibility && visibility != 0 && this.mDisplayController != null) {
            this.mDisplayController.unregisterReceivers();
        }
    }

    public void destroy() {
        this.mDisplayController.destroy();
        this.removeView((View)this.webView_);
        this.webView_.destroy();
    }

    public void unregisterReceivers() {
        this.mDisplayController.unregisterReceivers();
    }

    public void registerReceivers() {
        this.mDisplayController.registerReceivers();
    }

    public boolean loadHtmlData(String data) {
        return this.loadHtmlData(null, data);
    }

    public boolean loadHtmlData(String baseUrl, String data) {
        if (data.indexOf("<html>") == -1) {
            data = "<html><meta name=\"viewport\" content=\"width=" + this.windowWidth_ + ", height=" + this.windowHeight_ + ", initial-scale=" + AdUtils.getViewportInitialScale(this.scalingMultiplier_) + ", minimum-scale=" + this.scalingMultiplier_ + ", maximum-scale=" + this.scalingMultiplier_ + "\"/>" + "<head></head><body style='margin:0;padding:0;'>" + data + "</body></html>";
        }
        data = data.replace("<head>", "<head><script type='text/javascript'>(function(){var mraidbridge=window.mraidbridge={};var listeners={};var nativeCallQueue=[];var nativeCallInFlight=false;mraidbridge.fireReadyEvent=function(){mraidbridge.fireEvent('ready')};mraidbridge.fireChangeEvent=function(properties){mraidbridge.fireEvent('change',properties)};mraidbridge.fireErrorEvent=function(message,action){mraidbridge.fireEvent('error',message,action)};mraidbridge.fireEvent=function(type){var ls=listeners[type];if(ls){var args=Array.prototype.slice.call(arguments);args.shift();var l=ls.length;for(var i=0;i<l;i++){ls[i].apply(null,args)}}};mraidbridge.nativeCallComplete=function(command){if(nativeCallQueue.length===0){nativeCallInFlight=false;return}var nextCall=nativeCallQueue.pop();window.location=nextCall};mraidbridge.executeNativeCall=function(command){var call='mraid://'+command;var key,value;var isFirstArgument=true;for(var i=1;i<arguments.length;i+=2){key=arguments[i];value=arguments[i+1];if(value===null)continue;if(isFirstArgument){call+='?';isFirstArgument=false}else{call+='&'}call+=key+'='+escape(value)}if(nativeCallInFlight){nativeCallQueue.push(call)}else{nativeCallInFlight=true;window.location=call}};mraidbridge.addEventListener=function(event,listener){var eventListeners;listeners[event]=listeners[event]||[];eventListeners=listeners[event];for(var l in eventListeners){if(listener===l)return}eventListeners.push(listener)};mraidbridge.removeEventListener=function(event,listener){if(listeners.hasOwnProperty(event)){var eventListeners=listeners[event];if(eventListeners){var idx=eventListeners.indexOf(listener);if(idx!==-1){eventListeners.splice(idx,1)}}}}}());(function(){var mraid=window.mraid={};var bridge=window.mraidbridge;var VERSION=mraid.VERSION='1.0';var STATES=mraid.STATES={LOADING:'loading',DEFAULT:'default',EXPANDED:'expanded',HIDDEN:'hidden',};var EVENTS=mraid.EVENTS={ERROR:'error',INFO:'info',READY:'ready',STATECHANGE:'stateChange',VIEWABLECHANGE:'viewableChange'};var PLACEMENT_TYPES=mraid.PLACEMENT_TYPES={UNKNOWN:'unknown',INLINE:'inline',INTERSTITIAL:'interstitial'};var LOG_LEVELS=mraid.LOG_LEVELS={INFO:4,DEBUG:3,VERBOSE:2,WARNING:5,ERROR:6};var expandProperties={width:-1,height:-1,useCustomClose:false,isModal:true,lockOrientation:true};var hasSetCustomSize=false;var hasSetCustomClose=false;var listeners={};var state=STATES.LOADING;var isViewable=false;var screenSize={width:-1,height:-1};var placementType=PLACEMENT_TYPES.UNKNOWN;var EventListeners=function(event){this.event=event;this.count=0;var listeners={};this.add=function(func){var id=String(func);if(!listeners[id]){listeners[id]=func;this.count++}};this.remove=function(func){var id=String(func);if(listeners[id]){listeners[id]=null;delete listeners[id];this.count--;return true}else{return false}};this.removeAll=function(){for(var id in listeners){if(listeners.hasOwnProperty(id))this.remove(listeners[id])}};this.broadcast=function(args){for(var id in listeners){if(listeners.hasOwnProperty(id))listeners[id].apply({},args)}};this.toString=function(){var out=[event,':'];for(var id in listeners){if(listeners.hasOwnProperty(id))out.push('|',id,'|')}return out.join('')}};var broadcastEvent=function(){var args=new Array(arguments.length);var l=arguments.length;for(var i=0;i<l;i++)args[i]=arguments[i];var event=args.shift();if(listeners[event])listeners[event].broadcast(args)};var contains=function(value,array){for(var i in array){if(array[i]===value)return true}return false};var clone=function(obj){if(obj===null)return null;var f=function(){};f.prototype=obj;return new f()};var stringify=function(obj){if(typeof obj==='object'){var out=[];if(obj.push){for(var p in obj)out.push(obj[p]);return'['+out.join(',')+']'}else{for(var p in obj)out.push(\"'\"+p+\"': \"+obj[p]);return'{'+out.join(',')+'}'}}else return String(obj)};var trim=function(str){return str.replace(/^\\s+|\\s+$/g,'')};var changeHandlers={state:function(val){if(state===STATES.LOADING){broadcastEvent(EVENTS.INFO,'Native SDK initialized.')}state=val;broadcastEvent(EVENTS.INFO,'Set state to '+stringify(val));broadcastEvent(EVENTS.STATECHANGE,state)},viewable:function(val){isViewable=val;broadcastEvent(EVENTS.INFO,'Set isViewable to '+stringify(val));broadcastEvent(EVENTS.VIEWABLECHANGE,isViewable)},placementType:function(val){broadcastEvent(EVENTS.INFO,'Set placementType to '+stringify(val));placementType=val},screenSize:function(val){broadcastEvent(EVENTS.INFO,'Set screenSize to '+stringify(val));for(var key in val){if(val.hasOwnProperty(key))screenSize[key]=val[key]}if(!hasSetCustomSize){expandProperties['width']=screenSize['width'];expandProperties['height']=screenSize['height']}},expandProperties:function(val){broadcastEvent(EVENTS.INFO,'Merging expandProperties with '+stringify(val));for(var key in val){if(val.hasOwnProperty(key))expandProperties[key]=val[key]}}};var validate=function(obj,validators,action,merge){if(!merge){if(obj===null){broadcastEvent(EVENTS.ERROR,'Required object not provided.',action);return false}else{for(var i in validators){if(validators.hasOwnProperty(i)&&obj[i]===undefined){broadcastEvent(EVENTS.ERROR,'Object is missing required property: '+i+'.',action);return false}}}}for(var prop in obj){var validator=validators[prop];var value=obj[prop];if(validator&&!validator(value)){broadcastEvent(EVENTS.ERROR,'Value of property '+prop+' is invalid.',action);return false}}return true};var expandPropertyValidators={width:function(v){return!isNaN(v)&&v>=0},height:function(v){return!isNaN(v)&&v>=0},useCustomClose:function(v){return(typeof v==='boolean')},lockOrientation:function(v){return(typeof v==='boolean')}};bridge.addEventListener('change',function(properties){for(var p in properties){if(properties.hasOwnProperty(p)){var handler=changeHandlers[p];handler(properties[p])}}});bridge.addEventListener('error',function(message,action){broadcastEvent(EVENTS.ERROR,message,action)});bridge.addEventListener('ready',function(){broadcastEvent(EVENTS.READY)});mraid.addEventListener=function(event,listener){if(!event||!listener){broadcastEvent(EVENTS.ERROR,'Both event and listener are required.','addEventListener')}else if(!contains(event,EVENTS)){broadcastEvent(EVENTS.ERROR,'Unknown MRAID event: '+event,'addEventListener')}else{if(!listeners[event])listeners[event]=new EventListeners(event);listeners[event].add(listener)}};mraid.close=function(){if(state===STATES.HIDDEN){broadcastEvent(EVENTS.ERROR,'Ad cannot be closed when it is already hidden.','close')}else bridge.executeNativeCall('close')};mraid.playVideo=function(URL,properties){if(state==STATES.DEFAULT||state==STATES.EXPANDED){var args=['playVideo'];if(URL){args=args.concat(['url',URL])}var audioMuted=false,autoPlay=true,controls=true,loop=false,position=[-1,-1,-1,-1],startStyle='normal',stopStyle='normal';if(properties){if((typeof properties.audio!=\"undefined\")&&(properties.audio!=null)){audioMuted=properties.audio}if((typeof properties.autoplay!=\"undefined\")&&(properties.autoplay!=null)){autoPlay=properties.autoplay}if((typeof properties.controls!=\"undefined\")&&(properties.controls!=null)){controls=properties.controls}if((typeof properties.loop!=\"undefined\")&&(properties.loop!=null)){loop=properties.loop}if((typeof properties.position!=\"undefined\")&&(properties.position!=null)){inline=new Array(4);inline[0]=properties.position.top;inline[1]=properties.position.left;if((typeof properties.position.width!=\"undefined\")&&(properties.position.width!=null)){inline[2]=properties.position.width}if((typeof properties.position.height!=\"undefined\")&&(properties.position.height!=null)){inline[3]=properties.position.height}position=inline}if((typeof properties.startStyle!=\"undefined\")&&(properties.startStyle!=null)){startStyle=properties.startStyle}if((typeof properties.stopStyle!=\"undefined\")&&(properties.stopStyle!=null)){stopStyle=properties.stopStyle}if(loop){stopStyle='normal';controls=true}if(!autoPlay){controls=true}if(!controls){stopStyle='exit'}if(position[0]==-1||position[1]==-1){startStyle='fullscreen';autoPlay=true}args=args.concat(['audioMuted',audioMuted]);args=args.concat(['autoPlay',autoPlay]);args=args.concat(['controls',controls]);args=args.concat(['loop',loop]);args=args.concat(['position',position]);args=args.concat(['startStyle',startStyle]);args=args.concat(['stopStyle',stopStyle])}bridge.executeNativeCall.apply(this,args)}};mraid.log=function(level,log){var args=['log','level',level,'log',log];bridge.executeNativeCall.apply(this,args)};mraid.expand=function(URL){if(state!==STATES.DEFAULT){broadcastEvent(EVENTS.ERROR,'Ad can only be expanded from the default state.','expand')}else{var args=['expand'];if(hasSetCustomClose){args=args.concat(['shouldUseCustomClose',expandProperties.useCustomClose?'true':'false'])}if(hasSetCustomSize){if(expandProperties.width>=0&&expandProperties.height>=0){args=args.concat(['w',expandProperties.width,'h',expandProperties.height])}}if(typeof expandProperties.lockOrientation!=='undefined'){args=args.concat(['lockOrientation',expandProperties.lockOrientation])}if(URL){args=args.concat(['url',URL])}bridge.executeNativeCall.apply(this,args)}};mraid.getExpandProperties=function(){var properties={width:expandProperties.width,height:expandProperties.height,useCustomClose:expandProperties.useCustomClose,isModal:expandProperties.isModal};return properties};mraid.getPlacementType=function(){return placementType};mraid.getState=function(){return state};mraid.getVersion=function(){return mraid.VERSION};mraid.isViewable=function(){return isViewable};mraid.open=function(URL){if(!URL)broadcastEvent(EVENTS.ERROR,'URL is required.','open');else bridge.executeNativeCall('open','url',URL)};mraid.removeEventListener=function(event,listener){if(!event)broadcastEvent(EVENTS.ERROR,'Event is required.','removeEventListener');else{if(listener&&(!listeners[event]||!listeners[event].remove(listener))){broadcastEvent(EVENTS.ERROR,'Listener not currently registered for event.','removeEventListener');return}else if(listeners[event])listeners[event].removeAll();if(listeners[event]&&listeners[event].count===0){listeners[event]=null;delete listeners[event]}}};mraid.setExpandProperties=function(properties){if(validate(properties,expandPropertyValidators,'setExpandProperties',true)){if(properties.hasOwnProperty('width')||properties.hasOwnProperty('height')){hasSetCustomSize=true}if(properties.hasOwnProperty('useCustomClose'))hasSetCustomClose=true;var desiredProperties=['width','height','useCustomClose','lockOrientation'];var length=desiredProperties.length;for(var i=0;i<length;i++){var propname=desiredProperties[i];if(properties.hasOwnProperty(propname))expandProperties[propname]=properties[propname]}}};mraid.useCustomClose=function(shouldUseCustomClose){expandProperties.useCustomClose=shouldUseCustomClose;hasSetCustomClose=true;bridge.executeNativeCall('usecustomclose','shouldUseCustomClose',shouldUseCustomClose)}}());</script>");
        this.webView_.loadDataWithBaseURL(baseUrl, data, "text/html", "UTF-8", null);
        return true;
    }

    public void loadUrlForTwoPartExpansionView(String url) {
        WebRequest request = WebRequest.createNewWebRequest();
        request.setUrlString(url);
        WebRequest.WebResponse response = null;
        try {
            response = request.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            this.notifyOnFailureListener();
            return;
        }
        this.loadHtmlData(response.getBody());
    }

    public boolean shouldDisableWebViewHardwareAcceleration() {
        return this.adView.shouldDisableWebViewHardwareAcceleration();
    }

    private void notifyOnFailureListener() {
        if (this.mListenerInfo.mOnFailureListener != null) {
            this.mListenerInfo.mOnFailureListener.onFailure(this);
        }
    }

    protected MraidBrowserController getBrowserController() {
        return this.mBrowserController;
    }

    protected MraidDisplayController getDisplayController() {
        return this.mDisplayController;
    }

    public void setOnExpandListener(OnExpandListener listener) {
        this.mListenerInfo.mOnExpandListener = listener;
    }

    public OnExpandListener getOnExpandListener() {
        return this.mListenerInfo.mOnExpandListener;
    }

    public void setOnCloseListener(OnCloseListener listener) {
        this.mListenerInfo.mOnCloseListener = listener;
    }

    public OnCloseListener getOnCloseListener() {
        return this.mListenerInfo.mOnCloseListener;
    }

    public void setOnReadyListener(OnReadyListener listener) {
        this.mListenerInfo.mOnReadyListener = listener;
    }

    public OnReadyListener getOnReadyListener() {
        return this.mListenerInfo.mOnReadyListener;
    }

    public void setOnFailureListener(OnFailureListener listener) {
        this.mListenerInfo.mOnFailureListener = listener;
    }

    public OnFailureListener getOnFailureListener() {
        return this.mListenerInfo.mOnFailureListener;
    }

    public void setOnCloseButtonStateChange(OnCloseButtonStateChangeListener listener) {
        this.mListenerInfo.mOnCloseButtonListener = listener;
    }

    public OnCloseButtonStateChangeListener getOnCloseButtonStateChangeListener() {
        return this.mListenerInfo.mOnCloseButtonListener;
    }

    public void setOnOpenListener(OnOpenListener listener) {
        this.mListenerInfo.mOnOpenListener = listener;
    }

    public OnOpenListener getOnOpenListener() {
        return this.mListenerInfo.mOnOpenListener;
    }

    public void setOnSpecialUrlClickListener(OnSpecialUrlClickListener listener) {
        this.mListenerInfo.mOnSpecialUrlClickListener = listener;
    }

    public OnSpecialUrlClickListener getOnSpecialUrlClickListener() {
        return this.mListenerInfo.mOnSpecialUrlClickListener;
    }

    protected void setMraidBrowserController(MraidBrowserController browserController) {
        this.mBrowserController = browserController;
    }

    protected void setMraidDisplayController(MraidDisplayController controller) {
        this.mDisplayController = controller;
    }

    protected void setWebViewClient(WebViewClient client) {
        this.mWebViewClient = client;
    }

    protected void setWebChromeClient(WebChromeClient client) {
        this.mWebChromeClient = client;
    }

    protected void setMraidListenerInfo(MraidListenerInfo info) {
        this.mListenerInfo = info;
    }

    protected void injectJavaScript(String js) {
        if (js != null) {
            this.webView_.loadUrl("javascript:" + js);
        }
    }

    protected void fireChangeEventForProperty(MraidProperty property) {
        String json = "{" + property.toString() + "}";
        this.injectJavaScript("window.mraidbridge.fireChangeEvent(" + json + ");");
        Log.d(LOGTAG, "Fire change: %s", json);
    }

    protected void fireChangeEventForProperties(ArrayList<MraidProperty> properties) {
        String props = properties.toString();
        if (props.length() < 2) {
            return;
        }
        String json = "{" + props.substring(1, props.length() - 1) + "}";
        this.injectJavaScript("window.mraidbridge.fireChangeEvent(" + json + ");");
        Log.d(LOGTAG, "Fire changes: %s", json);
    }

    protected void fireErrorEvent(String action, String message) {
        this.injectJavaScript("window.mraidbridge.fireErrorEvent('" + action + "', '" + message + "');");
    }

    protected void fireReadyEvent() {
        this.injectJavaScript("window.mraidbridge.fireReadyEvent();");
    }

    protected void fireNativeCommandCompleteEvent(String command) {
        this.injectJavaScript("window.mraidbridge.nativeCallComplete('" + command + "');");
    }

    protected void onPageFinished() {
        if (!this.mHasFiredReadyEvent) {
            this.mDisplayController.initializeJavaScriptState();
            this.fireChangeEventForProperty(MraidPlacementTypeProperty.createWithType(this.mPlacementType));
            this.fireReadyEvent();
            if (this.getOnReadyListener() != null) {
                this.getOnReadyListener().onReady(this);
            }
            this.mHasFiredReadyEvent = true;
            this.mDisplayController.surfaceAd();
        }
    }

    public static void cacheMraidView(String uniqueId, MraidView mraidView) {
        MraidView.getMraidViewCache().put(uniqueId, mraidView);
    }

    public static MraidView removeCachedMraidView(String uniqueId) {
        return MraidView.getMraidViewCache().remove(uniqueId);
    }

    public static MraidView getCachedMraidView(String uniqueId) {
        return MraidView.getMraidViewCache().get(uniqueId);
    }

    static HashMap<String, MraidView> getMraidViewCache() {
        if (mraidViewCache == null) {
            mraidViewCache = new HashMap();
        }
        return mraidViewCache;
    }

    class MraidExecutor
    implements AdWebViewClient.UrlExecutor {
        MraidExecutor() {
        }

        public boolean execute(String url) {
            URI uri = URI.create(url);
            String commandType = uri.getHost();
            List list = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
            HashMap<String, String> params = new HashMap<String, String>();
            for (NameValuePair pair : list) {
                params.put(pair.getName(), pair.getValue());
            }
            MraidCommand command = MraidCommandRegistry.createCommand(commandType, params, MraidView.this);
            if (command == null) {
                MraidView.this.fireNativeCommandCompleteEvent(commandType);
                return false;
            }
            command.execute();
            MraidView.this.fireNativeCommandCompleteEvent(commandType);
            return true;
        }
    }

    public static interface OnSpecialUrlClickListener {
        public void onSpecialUrlClick(MraidView var1, String var2);
    }

    public static interface OnOpenListener {
        public void onOpen(MraidView var1);
    }

    public static interface OnCloseButtonStateChangeListener {
        public void onCloseButtonStateChange(MraidView var1, boolean var2);
    }

    public static interface OnFailureListener {
        public void onFailure(MraidView var1);
    }

    public static interface OnReadyListener {
        public void onReady(MraidView var1);
    }

    public static interface OnCloseListener {
        public void onClose(MraidView var1, ViewState var2);
    }

    public static interface OnExpandListener {
        public void onExpand(MraidView var1);
    }

    protected class MraidWebChromeClient
    extends WebChromeClient {
        protected MraidWebChromeClient() {
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            Log.d(LOGTAG, message);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PlacementType {
        INLINE,
        INTERSTITIAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NativeCloseButtonStyle {
        ALWAYS_VISIBLE,
        ALWAYS_HIDDEN,
        AD_CONTROLLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExpansionStyle {
        ENABLED,
        DISABLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewState {
        LOADING,
        DEFAULT,
        EXPANDED,
        HIDDEN;

    }

    static class MraidListenerInfo {
        private OnExpandListener mOnExpandListener;
        private OnCloseListener mOnCloseListener;
        private OnReadyListener mOnReadyListener;
        private OnFailureListener mOnFailureListener;
        private OnCloseButtonStateChangeListener mOnCloseButtonListener;
        private OnOpenListener mOnOpenListener;
        private OnSpecialUrlClickListener mOnSpecialUrlClickListener;

        MraidListenerInfo() {
        }
    }
}

