/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdVideoPlayer;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.Controller;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.MraidAbstractController;
import com.amazon.device.ads.MraidProperty;
import com.amazon.device.ads.MraidRenderer;
import com.amazon.device.ads.MraidScreenSizeProperty;
import com.amazon.device.ads.MraidStateProperty;
import com.amazon.device.ads.MraidView;
import com.amazon.device.ads.MraidViewableProperty;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.VideoActionHandler;
import com.amazon.device.ads.WebViewFactory;
import java.util.ArrayList;

class MraidDisplayController
extends MraidAbstractController {
    private static final String LOGTAG = "MraidDisplayController";
    private static final int CLOSE_BUTTON_SIZE_DP = 50;
    private MraidView.ViewState mViewState = MraidView.ViewState.HIDDEN;
    private final MraidView.ExpansionStyle mExpansionStyle;
    private final MraidView.NativeCloseButtonStyle mNativeCloseButtonStyle;
    private MraidView mTwoPartExpansionView;
    private FrameLayout mRootView;
    private AdVideoPlayer vidPlayer_;
    private boolean vidPlaying_ = false;
    private boolean mIsViewable;
    private final int mOriginalRequestedOrientation;
    private BroadcastReceiver mOrientationBroadcastReceiver = new BroadcastReceiver(){
        private int mLastRotation;

        public void onReceive(Context context, Intent intent) {
            try {
                int orientation;
                String action = intent.getAction();
                if (action.equals("android.intent.action.CONFIGURATION_CHANGED") && (orientation = MraidDisplayController.this.getDisplayRotation()) != this.mLastRotation) {
                    this.mLastRotation = orientation;
                    MraidDisplayController.this.onOrientationChanged(this.mLastRotation);
                }
            }
            catch (Exception e) {
                Log.d(MraidDisplayController.LOGTAG, "Orientation broadcast receiver got exception while executing: %s", e.getLocalizedMessage());
            }
        }
    };
    private ImageView mCloseButton;
    private boolean mAdWantsCustomCloseButton;
    protected float mDensity;
    protected int mScreenWidth = -1;
    protected int mScreenHeight = -1;
    private int mViewIndexInParent;
    private int mViewWidth;
    private int mViewHeight;
    FrameLayout mPlaceholderView;
    private boolean mRegistered = false;
    private Context mContext;
    private int windowWidth_;
    private int windowHeight_;
    private double scalingMultiplier_;
    private int modalContainerLayoutId_ = 0;
    protected int adContainerLayoutId_ = 0;
    private int videoContainerId_ = 0;
    private int viewCounter_ = 1131261513;
    private int viewCounterIncrement_ = 50;

    MraidDisplayController(MraidView view, MraidView.ExpansionStyle expStyle, MraidView.NativeCloseButtonStyle buttonStyle) {
        super(view);
        this.mExpansionStyle = expStyle;
        this.mNativeCloseButtonStyle = buttonStyle;
        this.windowHeight_ = view.getWindowHeight();
        this.windowWidth_ = view.getWindowWidth();
        this.scalingMultiplier_ = view.getScalingMultiplier();
        this.mContext = this.getView().getContext();
        this.mOriginalRequestedOrientation = this.mContext instanceof Activity ? ((Activity)this.mContext).getRequestedOrientation() : -1;
        this.initialize();
    }

    protected void registerReceivers() {
        if (!this.mRegistered) {
            this.mRegistered = true;
            this.getView().getContext().registerReceiver(this.mOrientationBroadcastReceiver, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
        }
    }

    protected void unregisterReceivers() {
        if (this.mRegistered) {
            this.mRegistered = false;
            try {
                this.getView().getContext().unregisterReceiver(this.mOrientationBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void initialize() {
        this.mViewState = MraidView.ViewState.LOADING;
        this.initializeScreenMetrics();
        this.registerReceivers();
    }

    protected void surfaceAd() {
        this.getView().fireChangeEventForProperty(MraidViewableProperty.createWithViewable(true));
    }

    protected void initializeScreenMetrics() {
        Context context = this.getView().getContext();
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mDensity = metrics.density;
        int statusBarHeight = 0;
        int titleBarHeight = 0;
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            Window window = activity.getWindow();
            Rect rect = new Rect();
            window.getDecorView().getWindowVisibleDisplayFrame(rect);
            statusBarHeight = rect.top;
            int contentViewTop = window.findViewById(0x1020002).getTop();
            titleBarHeight = contentViewTop - statusBarHeight;
        }
        int widthPixels = metrics.widthPixels;
        int heightPixels = metrics.heightPixels - statusBarHeight - titleBarHeight;
        this.mScreenWidth = (int)((double)widthPixels * (160.0 / (double)metrics.densityDpi));
        this.mScreenHeight = (int)((double)heightPixels * (160.0 / (double)metrics.densityDpi));
    }

    private int getDisplayRotation() {
        WindowManager wm = (WindowManager)this.getView().getContext().getSystemService("window");
        return AndroidTargetUtils.getOrientation(wm.getDefaultDisplay());
    }

    private void onOrientationChanged(int currentRotation) {
        this.initializeScreenMetrics();
        if (this.mRegistered) {
            this.getView().fireChangeEventForProperty(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
        }
    }

    public void destroy() {
        block3: {
            try {
                this.getView().getContext().unregisterReceiver(this.mOrientationBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Receiver not registered")) break block3;
                throw e;
            }
        }
        if (this.mTwoPartExpansionView != null) {
            this.mTwoPartExpansionView.destroy();
            this.mTwoPartExpansionView = null;
        }
    }

    protected void initializeJavaScriptState() {
        ArrayList<MraidProperty> properties = new ArrayList<MraidProperty>();
        properties.add(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
        properties.add(MraidViewableProperty.createWithViewable(this.mIsViewable));
        this.getView().fireChangeEventForProperties(properties);
        this.mViewState = MraidView.ViewState.DEFAULT;
        this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
    }

    protected boolean isExpanded() {
        return this.mViewState == MraidView.ViewState.EXPANDED;
    }

    protected void close() {
        if (this.vidPlaying_) {
            this.vidPlayer_.releasePlayer();
            this.vidPlaying_ = false;
        }
        this.removeKeyListenerFromWebView();
        if (this.mViewState == MraidView.ViewState.EXPANDED) {
            this.resetViewToDefaultState();
            this.setOrientationLockEnabled(false);
            this.mViewState = MraidView.ViewState.DEFAULT;
            this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        } else if (this.mViewState == MraidView.ViewState.DEFAULT) {
            this.getView().setVisibility(4);
            this.mViewState = MraidView.ViewState.HIDDEN;
            this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        }
        if (this.getView().getOnCloseListener() != null) {
            this.getView().getOnCloseListener().onClose(this.getView(), this.mViewState);
        }
    }

    protected void removeKeyListenerFromWebView() {
        this.getView().getWebView().setOnKeyListener(null);
    }

    protected void detachExpandedView() {
        if (this.mViewState == MraidView.ViewState.EXPANDED) {
            ViewGroup placeholderParent;
            Log.d(LOGTAG, "Ad is currently expanded. Detaching the expanded view and returning ad to its default state.");
            RelativeLayout expansionLayout = (RelativeLayout)this.mRootView.findViewById(this.modalContainerLayoutId_);
            if (expansionLayout != null) {
                if (expansionLayout.isShown()) {
                    this.mRootView.removeView((View)expansionLayout);
                } else {
                    expansionLayout.removeAllViews();
                }
            }
            if ((placeholderParent = (ViewGroup)this.mPlaceholderView.getParent()) != null) {
                placeholderParent.removeView((View)this.mPlaceholderView);
                this.setOrientationLockEnabled(false);
                this.mViewState = MraidView.ViewState.DEFAULT;
                this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
            }
        }
    }

    private void resetViewToDefaultState() {
        FrameLayout adContainerLayout = (FrameLayout)this.findViewByIdInRootView(this.adContainerLayoutId_);
        RelativeLayout expansionLayout = (RelativeLayout)this.findViewByIdInRootView(this.modalContainerLayoutId_);
        this.setNativeCloseButtonEnabled(false);
        adContainerLayout.removeAllViewsInLayout();
        this.mRootView.removeView((View)expansionLayout);
        this.getView().requestLayout();
        ViewGroup parent = (ViewGroup)this.mPlaceholderView.getParent();
        parent.addView((View)this.getView(), this.mViewIndexInParent, new ViewGroup.LayoutParams(this.mViewWidth, this.mViewHeight));
        parent.removeView((View)this.mPlaceholderView);
        parent.invalidate();
    }

    protected View findViewByIdInRootView(int id) {
        return this.mRootView.findViewById(id);
    }

    protected void expand(String url, int width, int height, boolean shouldUseCustomClose, boolean shouldLockOrientation) {
        if (this.mExpansionStyle == MraidView.ExpansionStyle.DISABLED || this.mViewState == MraidView.ViewState.EXPANDED) {
            return;
        }
        if (this.isAdLoading()) {
            Log.e(LOGTAG, "Expansion failed because ad loading is currently in progress.");
            return;
        }
        if (url != null && !URLUtil.isValidUrl((String)url)) {
            this.getView().fireErrorEvent("expand", "URL passed to expand() was invalid.");
            return;
        }
        if (!this.obtainRootView()) {
            this.getView().fireErrorEvent("expand", "Root view could not be found.");
            Log.e(LOGTAG, "Expansion failed because root view could not be found.");
            return;
        }
        try {
            this.establishViewIds();
        }
        catch (IllegalArgumentException e) {
            this.getView().fireErrorEvent("expand", "Could not find available view ID.");
            Log.e(LOGTAG, "Expansion failed because available view ID could not be found.");
            return;
        }
        this.useCustomClose(shouldUseCustomClose);
        this.setOrientationLockEnabled(shouldLockOrientation);
        this.swapViewWithPlaceholderView();
        MraidView expansionContentView = this.getView();
        expansionContentView.setWebViewLayoutParams(-1, -1);
        if (url != null) {
            MraidRenderer renderer = (MraidRenderer)expansionContentView.getAdView();
            WebView webView = WebViewFactory.getInstance().createWebView(renderer.context);
            this.mTwoPartExpansionView = new MraidView(renderer, this.windowWidth_, this.windowHeight_, this.scalingMultiplier_, renderer.context, webView, MraidView.ExpansionStyle.DISABLED, MraidView.NativeCloseButtonStyle.AD_CONTROLLED, MraidView.PlacementType.INLINE);
            this.mTwoPartExpansionView.setOnCloseListener(new MraidView.OnCloseListener(){

                public void onClose(MraidView view, MraidView.ViewState newViewState) {
                    MraidDisplayController.this.close();
                }
            });
            this.mTwoPartExpansionView.loadUrlForTwoPartExpansionView(url);
            expansionContentView = this.mTwoPartExpansionView;
        }
        ViewGroup expansionViewContainer = this.createExpansionViewContainer((View)expansionContentView, (int)((float)width * this.mDensity), (int)((float)height * this.mDensity));
        this.addViewToRootView(expansionViewContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.setKeyListenerToClose(expansionContentView);
        if (this.mNativeCloseButtonStyle == MraidView.NativeCloseButtonStyle.ALWAYS_VISIBLE || !this.mAdWantsCustomCloseButton && this.mNativeCloseButtonStyle != MraidView.NativeCloseButtonStyle.ALWAYS_HIDDEN) {
            this.setNativeCloseButtonEnabled(true);
        }
        this.mViewState = MraidView.ViewState.EXPANDED;
        this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        if (this.getView().getOnExpandListener() != null) {
            this.getView().getOnExpandListener().onExpand(this.getView());
        }
    }

    protected boolean isAdLoading() {
        return ((MraidRenderer)this.getView().getAdView()).controller.isAdLoading();
    }

    protected boolean obtainRootView() {
        this.mRootView = (FrameLayout)this.getView().getRootView().findViewById(0x1020002);
        return this.mRootView != null;
    }

    protected void addViewToRootView(ViewGroup expansionViewContainer, ViewGroup.LayoutParams params) {
        this.mRootView.addView((View)expansionViewContainer, params);
    }

    protected void setKeyListenerToClose(MraidView expansionContentView) {
        expansionContentView.getWebView().requestFocus();
        expansionContentView.getWebView().setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4 && event.getRepeatCount() == 0) {
                    MraidDisplayController.this.close();
                    return true;
                }
                return false;
            }
        });
    }

    private void swapViewWithPlaceholderView() {
        int index;
        ViewGroup parent = this.getParentOfView();
        if (parent == null) {
            return;
        }
        this.mPlaceholderView = new FrameLayout(this.getView().getContext());
        int count = parent.getChildCount();
        for (index = 0; index < count && parent.getChildAt(index) != this.getView(); ++index) {
        }
        this.mViewIndexInParent = index;
        this.mViewHeight = this.getViewHeight();
        this.mViewWidth = this.getViewWidth();
        parent.addView((View)this.mPlaceholderView, index, new ViewGroup.LayoutParams(this.getView().getWidth(), this.getView().getHeight()));
        parent.removeView((View)this.getView());
    }

    protected int getViewHeight() {
        return this.getView().getHeight();
    }

    protected int getViewWidth() {
        return this.getView().getWidth();
    }

    protected ViewGroup getParentOfView() {
        return (ViewGroup)this.getView().getParent();
    }

    protected ViewGroup createExpansionViewContainer(View expansionContentView, int expandWidth, int expandHeight) {
        int closeButtonSize = (int)(50.0f * this.mDensity + 0.5f);
        if (expandWidth < closeButtonSize) {
            expandWidth = closeButtonSize;
        }
        if (expandHeight < closeButtonSize) {
            expandHeight = closeButtonSize;
        }
        RelativeLayout expansionLayout = new RelativeLayout(this.getView().getContext());
        expansionLayout.setId(this.modalContainerLayoutId_);
        View dimmingView = new View(this.getView().getContext());
        dimmingView.setBackgroundColor(0);
        dimmingView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        expansionLayout.addView(dimmingView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        FrameLayout adContainerLayout = new FrameLayout(this.getView().getContext());
        adContainerLayout.setId(this.adContainerLayoutId_);
        adContainerLayout.addView(expansionContentView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(expandWidth, expandHeight);
        lp.addRule(13);
        expansionLayout.addView((View)adContainerLayout, (ViewGroup.LayoutParams)lp);
        return expansionLayout;
    }

    private void setOrientationLockEnabled(boolean enabled) {
        Context context = this.getView().getContext();
        Activity activity = null;
        try {
            activity = (Activity)context;
            int requestedOrientation = enabled ? Utils.determineCanonicalScreenOrientation() : this.mOriginalRequestedOrientation;
            activity.setRequestedOrientation(requestedOrientation);
        }
        catch (Exception e) {
            Log.d(LOGTAG, "Unable to modify device orientation.");
        }
    }

    protected void setNativeCloseButtonEnabled(boolean enabled) {
        if (this.mRootView == null) {
            return;
        }
        FrameLayout adContainerLayout = (FrameLayout)this.mRootView.findViewById(this.adContainerLayoutId_);
        if (enabled) {
            if (this.mCloseButton == null) {
                StateListDrawable states = new StateListDrawable();
                states.addState(new int[]{-16842919}, (Drawable)AndroidTargetUtils.getNewBitmapDrawable(this.mContext.getResources(), Assets.getInstance().getFilePath("amazon_ads_close_button_normal.png")));
                states.addState(new int[]{16842919}, (Drawable)AndroidTargetUtils.getNewBitmapDrawable(this.mContext.getResources(), Assets.getInstance().getFilePath("amazon_ads_close_button_pressed.png")));
                this.mCloseButton = new ImageButton(this.getView().getContext());
                this.mCloseButton.setImageDrawable((Drawable)states);
                AndroidTargetUtils.setBackgroundDrawable((View)this.mCloseButton, null);
                this.mCloseButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MraidDisplayController.this.close();
                    }
                });
            }
            int buttonSize = (int)(50.0f * this.mDensity + 0.5f);
            FrameLayout.LayoutParams buttonLayout = new FrameLayout.LayoutParams(buttonSize, buttonSize, 5);
            adContainerLayout.addView((View)this.mCloseButton, (ViewGroup.LayoutParams)buttonLayout);
        } else {
            adContainerLayout.removeView((View)this.mCloseButton);
        }
        MraidView view = this.getView();
        if (view.getOnCloseButtonStateChangeListener() != null) {
            view.getOnCloseButtonStateChangeListener().onCloseButtonStateChange(view, enabled);
        }
    }

    protected void useCustomClose(boolean shouldUseCustomCloseButton) {
        boolean enabled;
        this.mAdWantsCustomCloseButton = shouldUseCustomCloseButton;
        MraidView view = this.getView();
        boolean bl = enabled = !shouldUseCustomCloseButton;
        if (view.getOnCloseButtonStateChangeListener() != null) {
            view.getOnCloseButtonStateChangeListener().onCloseButtonStateChange(view, enabled);
        }
    }

    protected boolean checkViewable() {
        return true;
    }

    private int getUniqueViewId() throws IllegalArgumentException {
        if (this.mRootView == null) {
            Log.w(LOGTAG, "Could not find root view. View ID may not be unique.");
            return this.viewCounter_++;
        }
        ++this.viewCounter_;
        boolean foundUnique = false;
        for (int i = 0; i < 100 && !foundUnique; ++i) {
            if (this.mRootView.findViewById(this.viewCounter_) == null) {
                foundUnique = true;
                continue;
            }
            this.viewCounter_ += this.viewCounterIncrement_;
        }
        if (!foundUnique) {
            throw new IllegalArgumentException();
        }
        return this.viewCounter_;
    }

    private void establishViewIds() throws IllegalArgumentException {
        if (this.modalContainerLayoutId_ != 0) {
            return;
        }
        this.modalContainerLayoutId_ = this.getUniqueViewId();
        this.adContainerLayoutId_ = this.getUniqueViewId();
        this.videoContainerId_ = this.getUniqueViewId();
    }

    protected void playVideo(String url, Controller.Dimensions d, Controller.PlayerProperties props) {
        Log.d(LOGTAG, "in playVideo");
        if (this.vidPlaying_) {
            return;
        }
        if (props.isFullScreen()) {
            Bundle data = new Bundle();
            data.putString("url", url);
            data.putParcelable("player_dimensions", (Parcelable)d);
            data.putParcelable("player_properties", (Parcelable)props);
            try {
                Intent intent = new Intent(this.getView().getContext(), AdActivity.class);
                intent.putExtra("adapter", VideoActionHandler.class.getName());
                intent.putExtras(data);
                this.getView().getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Log.e(LOGTAG, "Failed to open VideoAction activity");
            }
            return;
        }
        if (this.vidPlayer_ == null) {
            this.vidPlayer_ = new AdVideoPlayer(this.mContext);
        }
        this.vidPlayer_.setPlayData(new Controller.PlayerProperties(), url);
        this.vidPlayer_.setListener(new AdVideoPlayer.AdVideoPlayerListener(){

            public void onError() {
                this.onComplete();
            }

            public void onComplete() {
                Log.d(MraidDisplayController.LOGTAG, "videoplayback complete");
                MraidDisplayController.this.vidPlaying_ = false;
                FrameLayout vidContainer = (FrameLayout)MraidDisplayController.this.mRootView.findViewById(MraidDisplayController.this.videoContainerId_);
                vidContainer.setVisibility(4);
                MraidDisplayController.this.mRootView.removeView((View)vidContainer);
            }
        });
        FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(d.width, d.height);
        fl.topMargin = d.x;
        fl.bottomMargin = d.y;
        this.vidPlayer_.setLayoutParams((ViewGroup.LayoutParams)fl);
        FrameLayout vidContainer = new FrameLayout(this.getView().getContext());
        vidContainer.setId(this.videoContainerId_);
        vidContainer.setPadding(d.x, d.y, 0, 0);
        this.vidPlayer_.setViewGroup((ViewGroup)vidContainer);
        this.mRootView.addView((View)vidContainer, -1, -1);
        this.vidPlaying_ = true;
        this.vidPlayer_.playVideo();
    }

    protected void setRootView(FrameLayout layout) {
        this.mRootView = layout;
    }
}

