/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.MraidCommand;
import com.amazon.device.ads.MraidCommandClose;
import com.amazon.device.ads.MraidCommandExpand;
import com.amazon.device.ads.MraidCommandLogCat;
import com.amazon.device.ads.MraidCommandOpen;
import com.amazon.device.ads.MraidCommandPlayVideo;
import com.amazon.device.ads.MraidCommandUseCustomClose;
import com.amazon.device.ads.MraidView;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MraidCommandRegistry {
    private static Map<String, MraidCommandFactory> commandMap = new HashMap<String, MraidCommandFactory>();

    MraidCommandRegistry() {
    }

    static MraidCommand createCommand(String string, Map<String, String> params, MraidView view) {
        MraidCommandFactory factory = commandMap.get(string);
        return factory != null ? factory.create(params, view) : null;
    }

    static {
        commandMap.put("close", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandClose(params, view);
            }
        });
        commandMap.put("expand", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandExpand(params, view);
            }
        });
        commandMap.put("usecustomclose", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandUseCustomClose(params, view);
            }
        });
        commandMap.put("open", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandOpen(params, view);
            }
        });
        commandMap.put("playVideo", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandPlayVideo(params, view);
            }
        });
        commandMap.put("log", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandLogCat(params, view);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MraidCommandFactory {
        public MraidCommand create(Map<String, String> var1, MraidView var2);
    }
}

