/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.net.Uri;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.MraidAbstractController;
import com.amazon.device.ads.MraidBrowser;
import com.amazon.device.ads.MraidView;

class MraidBrowserController
extends MraidAbstractController {
    private static final String LOGTAG = "MraidBrowserController";

    MraidBrowserController(MraidView view) {
        super(view);
    }

    protected void executeAmazonMobileCallback(MraidView view, String url) {
        if (view.getOnSpecialUrlClickListener() != null) {
            if (view.getDisplayController().isExpanded()) {
                view.getDisplayController().close();
            }
            view.getOnSpecialUrlClickListener().onSpecialUrlClick(view, url);
        }
    }

    protected void open(String url) {
        MraidView view = this.getView();
        if (url == null || url.length() == 0) {
            Log.e(LOGTAG, "URI cannot be null or empty");
            return;
        }
        Log.d(LOGTAG, "Opening in-app browser: %s", url);
        Uri incomingUrl = Uri.parse((String)url);
        if (incomingUrl.getScheme() != null && incomingUrl.getScheme().equals("amazonmobile")) {
            this.executeAmazonMobileCallback(view, url);
            return;
        }
        String redir = null;
        try {
            redir = incomingUrl.getQueryParameter("d.url");
        }
        catch (UnsupportedOperationException e) {
            Log.e(LOGTAG, "Could not open non-hierarchical URI: %s", url);
            return;
        }
        if (redir == null) {
            redir = url;
        }
        if (redir.startsWith("amazonmobile:")) {
            this.executeAmazonMobileCallback(view, redir);
            return;
        }
        if (view.getOnOpenListener() != null) {
            view.getOnOpenListener().onOpen(view);
        }
        if (redir.startsWith("http:") || redir.startsWith("https:")) {
            new MraidBrowser.MraidBrowserBuilder().withContext(this.getView().getContext()).withUrl(redir).withExternalBrowserButton().show();
        } else {
            view.adView.launchExternalBrowserForLink(redir);
        }
    }
}

