/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.IAdActivityAdapter;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.WebViewFactory;

class MraidBrowser
implements IAdActivityAdapter {
    protected static final String LOG_TAG = MraidBrowser.class.getSimpleName();
    protected static final String URL_EXTRA = "extra_url";
    protected static final String SHOW_OPEN_EXTERNAL_BROWSER_BTN = "extra_open_btn";
    private static final int BUTTON_SIZE_DP = 50;
    private static final int HORIZONTAL_RULE_SIZE_DP = 3;
    private WebView mWebView;
    private ImageButton mBrowserBackButton;
    private ImageButton mBrowserForwardButton;
    private ImageButton mRefreshButton;
    private ImageButton mCloseButton;
    private ImageButton mOpenExternalBrowserButton;
    private Activity activity;
    private boolean showOpenExternalBrowserButton;

    MraidBrowser() {
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void onCreate() {
        this.activity.getWindow().requestFeature(2);
        this.activity.getWindow().setFeatureInt(2, -1);
        Intent intent = this.activity.getIntent();
        this.showOpenExternalBrowserButton = intent.getBooleanExtra(SHOW_OPEN_EXTERNAL_BROWSER_BTN, false);
        this.initializeEntireView(intent);
        this.initializeWebView(intent);
        this.enableCookies();
    }

    @SuppressLint(value={"InlinedApi"})
    private void initializeEntireView(Intent intent) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.activity.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        float mDensity = metrics.density;
        int buttonHeight = (int)(50.0f * mDensity + 0.5f);
        int ruleSize = (int)(3.0f * mDensity + 0.5f);
        int buttonCount = this.showOpenExternalBrowserButton ? 5 : 4;
        int buttonWidth = metrics.widthPixels / buttonCount;
        if (buttonWidth > 2 * buttonHeight) {
            buttonWidth = 2 * buttonHeight;
        }
        RelativeLayout layout = new RelativeLayout((Context)this.activity);
        layout.setId(10280);
        RelativeLayout.LayoutParams rp = new RelativeLayout.LayoutParams(-1, buttonHeight + ruleSize);
        rp.addRule(12);
        layout.setLayoutParams((ViewGroup.LayoutParams)rp);
        layout.setBackgroundColor(-986896);
        ThreadUtils.executeAsyncTask(new LoadButtonsTask(intent, (ViewGroup)layout, buttonWidth, buttonHeight), new Void[0]);
        View ruler = new View((Context)this.activity);
        ruler.setBackgroundColor(-3355444);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, ruleSize);
        params.addRule(10);
        ruler.setLayoutParams((ViewGroup.LayoutParams)params);
        layout.addView(ruler);
        this.mWebView = WebViewFactory.getInstance().createWebView((Context)this.activity);
        RelativeLayout.LayoutParams wrp = new RelativeLayout.LayoutParams(-1, -1);
        wrp.addRule(2, layout.getId());
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)wrp);
        RelativeLayout rl = new RelativeLayout((Context)this.activity);
        rl.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        rl.addView((View)this.mWebView);
        rl.addView((View)layout);
        LinearLayout mainll = new LinearLayout((Context)this.activity);
        mainll.setOrientation(1);
        mainll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        mainll.addView((View)rl);
        this.activity.setContentView((View)mainll);
    }

    private ImageButton createButton(String src, int verb, int anchor, int buttonWidth, int buttonHeight) {
        ImageButton button = new ImageButton((Context)this.activity);
        button.setImageBitmap(BitmapFactory.decodeFile((String)src));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
        params.addRule(verb, anchor);
        params.addRule(12);
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundColor(0);
        button.setScaleType(ImageView.ScaleType.FIT_CENTER);
        return button;
    }

    private void initializeWebView(Intent intent) {
        WebViewFactory.setJavaScriptEnabledForWebView(true, this.mWebView, LOG_TAG);
        this.mWebView.loadUrl(intent.getStringExtra(URL_EXTRA));
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                Log.w(LOG_TAG, "MRAID error: %s", description);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url == null) {
                    return false;
                }
                if (url.startsWith("market:") || url.startsWith("tel:") || url.startsWith("voicemail:") || url.startsWith("sms:") || url.startsWith("mailto:") || url.startsWith("geo:") || url.startsWith("google.streetview:")) {
                    try {
                        MraidBrowser.this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                    }
                    catch (ActivityNotFoundException e) {
                        Log.w(LOG_TAG, "Could not handle intent with URI: %s", url);
                    }
                    return true;
                }
                return false;
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                Activity a = (Activity)view.getContext();
                a.setTitle((CharSequence)"Loading...");
                a.setProgress(progress * 100);
                if (progress == 100) {
                    a.setTitle((CharSequence)view.getUrl());
                }
                MraidBrowser.this.updateNavigationButtons(view);
            }
        });
    }

    private void initializeButtons(final Intent intent) {
        this.mBrowserBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MraidBrowser.this.mWebView.canGoBack()) {
                    MraidBrowser.this.mWebView.goBack();
                }
            }
        });
        this.mBrowserForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MraidBrowser.this.mWebView.canGoForward()) {
                    MraidBrowser.this.mWebView.goForward();
                }
            }
        });
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MraidBrowser.this.mWebView.reload();
            }
        });
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MraidBrowser.this.activity.finish();
            }
        });
        if (this.showOpenExternalBrowserButton) {
            this.mOpenExternalBrowserButton.setOnClickListener(new View.OnClickListener(){
                final String originalUrl;
                {
                    this.originalUrl = intent.getStringExtra(MraidBrowser.URL_EXTRA);
                }

                public void onClick(View v) {
                    String currentUrl = MraidBrowser.this.mWebView.getUrl();
                    if (currentUrl == null) {
                        String msg = "The current URL is null. Reverting to the original URL for external browser.";
                        Log.w(LOG_TAG, "The current URL is null. Reverting to the original URL for external browser.");
                        currentUrl = this.originalUrl;
                    }
                    AdUtils.launchActivityForIntentLink(currentUrl, MraidBrowser.this.mWebView.getContext());
                }
            });
        }
    }

    private void updateNavigationButtons(WebView view) {
        if (this.mBrowserBackButton != null && this.mBrowserForwardButton != null) {
            if (view.canGoBack()) {
                AndroidTargetUtils.setImageButtonAlpha(this.mBrowserBackButton, 255);
            } else {
                AndroidTargetUtils.setImageButtonAlpha(this.mBrowserBackButton, 102);
            }
            if (view.canGoForward()) {
                AndroidTargetUtils.setImageButtonAlpha(this.mBrowserForwardButton, 255);
            } else {
                AndroidTargetUtils.setImageButtonAlpha(this.mBrowserForwardButton, 102);
            }
        }
    }

    private void enableCookies() {
        CookieSyncManager.createInstance((Context)this.activity);
        CookieSyncManager.getInstance().startSync();
    }

    protected WebView getWebView() {
        return this.mWebView;
    }

    protected boolean getShouldPauseWebViewTimers() {
        return Settings.getInstance().getBoolean("shouldPauseWebViewTimersInWebViewRelatedActivities", false);
    }

    protected boolean canPauseWebViewTimers() {
        WebView webView = this.getWebView();
        return webView != null && this.getShouldPauseWebViewTimers();
    }

    public void onPause() {
        Log.d(LOG_TAG, "onPause");
        WebView webView = this.getWebView();
        if (this.isAtLeastAndroidAPI(11)) {
            this.webViewOnPause(webView);
        } else {
            Log.w(LOG_TAG, "Unable to call WebView.onPause");
        }
        if (this.canPauseWebViewTimers()) {
            webView.pauseTimers();
        }
        CookieSyncManager.getInstance().stopSync();
    }

    protected boolean canResumeWebViewTimers() {
        WebView webView = this.getWebView();
        return webView != null && this.getShouldPauseWebViewTimers();
    }

    public void onResume() {
        Log.d(LOG_TAG, "onResume");
        WebView webView = this.getWebView();
        if (this.isAtLeastAndroidAPI(11)) {
            this.webViewOnResume(webView);
        } else {
            Log.w(LOG_TAG, "Unable to call WebView.onResume");
        }
        if (this.canResumeWebViewTimers()) {
            webView.resumeTimers();
        }
        CookieSyncManager.getInstance().startSync();
    }

    protected boolean isAtLeastAndroidAPI(int api) {
        return Build.VERSION.SDK_INT >= api;
    }

    protected void webViewOnPause(WebView webView) {
        AndroidTargetUtils.webViewOnPause(webView);
    }

    protected void webViewOnResume(WebView webView) {
        AndroidTargetUtils.webViewOnResume(webView);
    }

    public void onStop() {
    }

    public void preOnCreate() {
    }

    static class MraidBrowserBuilder {
        private static final String LOGTAG = MraidBrowserBuilder.class.getSimpleName();
        private Context context;
        private String url;
        private boolean showOpenExternalBrowserButton;

        MraidBrowserBuilder() {
        }

        MraidBrowserBuilder withContext(Context context) {
            this.context = context;
            return this;
        }

        MraidBrowserBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        MraidBrowserBuilder withExternalBrowserButton() {
            this.showOpenExternalBrowserButton = true;
            return this;
        }

        void show() {
            if (this.context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            if (Utils.isNullOrWhiteSpace(this.url)) {
                throw new IllegalArgumentException("Url must not be null or white space");
            }
            if (!Assets.getInstance().ensureAssetsCreated()) {
                Log.e(LOGTAG, "Could not load application assets, failed to open URI: %s", this.url);
                return;
            }
            Intent intent = new Intent(this.context, AdActivity.class);
            intent.putExtra("adapter", MraidBrowser.class.getName());
            intent.putExtra(MraidBrowser.URL_EXTRA, this.url);
            intent.putExtra(MraidBrowser.SHOW_OPEN_EXTERNAL_BROWSER_BTN, this.showOpenExternalBrowserButton);
            intent.addFlags(0x10000000);
            this.context.startActivity(intent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoadButtonsTask
    extends AsyncTask<Void, Void, Void> {
        private final ViewGroup layout;
        private final int buttonWidth;
        private final int buttonHeight;
        private final Intent intent;

        public LoadButtonsTask(Intent intent, ViewGroup layout, int buttonWidth, int buttonHeight) {
            this.intent = intent;
            this.layout = layout;
            this.buttonWidth = buttonWidth;
            this.buttonHeight = buttonHeight;
        }

        protected Void doInBackground(Void ... params) {
            MraidBrowser.this.mBrowserBackButton = MraidBrowser.this.createButton(Assets.getInstance().getFilePath("amazon_ads_leftarrow.png"), 9, -1, this.buttonWidth, this.buttonHeight);
            MraidBrowser.this.mBrowserBackButton.setId(10537);
            MraidBrowser.this.mBrowserForwardButton = MraidBrowser.this.createButton(Assets.getInstance().getFilePath("amazon_ads_rightarrow.png"), 1, MraidBrowser.this.mBrowserBackButton.getId(), this.buttonWidth, this.buttonHeight);
            MraidBrowser.this.mBrowserForwardButton.setId(10794);
            MraidBrowser.this.mCloseButton = MraidBrowser.this.createButton(Assets.getInstance().getFilePath("amazon_ads_close.png"), 11, -1, this.buttonWidth, this.buttonHeight);
            if (MraidBrowser.this.showOpenExternalBrowserButton) {
                MraidBrowser.this.mOpenExternalBrowserButton = MraidBrowser.this.createButton(Assets.getInstance().getFilePath("amazon_ads_open_external_browser.png"), 1, MraidBrowser.this.mBrowserForwardButton.getId(), this.buttonWidth, this.buttonHeight);
                MraidBrowser.this.mOpenExternalBrowserButton.setId(10795);
                MraidBrowser.this.mRefreshButton = MraidBrowser.this.createButton(Assets.getInstance().getFilePath("amazon_ads_refresh.png"), 1, MraidBrowser.this.mOpenExternalBrowserButton.getId(), this.buttonWidth, this.buttonHeight);
            } else {
                MraidBrowser.this.mRefreshButton = MraidBrowser.this.createButton(Assets.getInstance().getFilePath("amazon_ads_refresh.png"), 1, MraidBrowser.this.mBrowserForwardButton.getId(), this.buttonWidth, this.buttonHeight);
            }
            return null;
        }

        protected void onPostExecute(Void param) {
            this.layout.addView((View)MraidBrowser.this.mBrowserBackButton);
            this.layout.addView((View)MraidBrowser.this.mBrowserForwardButton);
            this.layout.addView((View)MraidBrowser.this.mRefreshButton);
            this.layout.addView((View)MraidBrowser.this.mCloseButton);
            if (MraidBrowser.this.showOpenExternalBrowserButton) {
                this.layout.addView((View)MraidBrowser.this.mOpenExternalBrowserButton);
            }
            MraidBrowser.this.initializeButtons(this.intent);
        }
    }
}

