/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.ILog;
import com.amazon.device.ads.Version;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Log {
    protected static final String LOGTAG = "AmazonMobileAds ";
    private static boolean loggingEnabled_ = false;
    private static ILog logger = new LogcatLogger();

    Log() {
    }

    public static void setLogger(ILog newLogger) {
        logger = newLogger;
    }

    public static ILog getLogger() {
        return logger;
    }

    public static boolean canLog() {
        if (logger == null) {
            return false;
        }
        return DebugProperties.getDebugPropertyAsBoolean("debug.logging", loggingEnabled_);
    }

    public static void enableLogging(boolean enabled) {
        loggingEnabled_ = enabled;
    }

    public static void v(String tag, String msg) {
        Log.v(false, tag, msg);
    }

    public static void v(boolean force, String tag, String msg) {
        if (Log.canLog() || force) {
            logger.v(LOGTAG + tag, msg);
        }
    }

    public static void v(String tag, String format, Object ... params) {
        Log.v(false, tag, format, params);
    }

    public static void v(boolean force, String tag, String format, Object ... params) {
        if (Log.canLog() || force) {
            logger.v(LOGTAG + tag, format, params);
        }
    }

    public static void d(String tag, String msg) {
        Log.d(false, tag, msg);
    }

    public static void d(boolean force, String tag, String msg) {
        if (Log.canLog() || force) {
            logger.d(LOGTAG + tag, msg);
        }
    }

    public static void d(String tag, String format, Object ... params) {
        Log.d(false, tag, format, params);
    }

    public static void d(boolean force, String tag, String format, Object ... params) {
        if (Log.canLog() || force) {
            logger.d(LOGTAG + tag, format, params);
        }
    }

    public static void e(String tag, String msg) {
        Log.e(false, tag, msg);
    }

    public static void e(boolean force, String tag, String msg) {
        if (Log.canLog() || force) {
            logger.e(LOGTAG + tag, msg);
        }
    }

    public static void e(String tag, String format, Object ... params) {
        Log.e(false, tag, format, params);
    }

    public static void e(boolean force, String tag, String format, Object ... params) {
        if (Log.canLog() || force) {
            logger.e(LOGTAG + tag, format, params);
        }
    }

    public static void i(String tag, String msg) {
        Log.i(false, tag, msg);
    }

    public static void i(boolean force, String tag, String msg) {
        if (Log.canLog() || force) {
            logger.i(LOGTAG + tag, msg);
        }
    }

    public static void i(String tag, String format, Object ... params) {
        Log.i(false, tag, format, params);
    }

    public static void i(boolean force, String tag, String format, Object ... params) {
        if (Log.canLog() || force) {
            logger.i(LOGTAG + tag, format, params);
        }
    }

    public static void w(String tag, String msg) {
        Log.w(false, tag, msg);
    }

    public static void w(boolean force, String tag, String msg) {
        if (Log.canLog() || force) {
            logger.w(LOGTAG + tag, msg);
        }
    }

    public static void w(String tag, String format, Object ... params) {
        Log.w(false, tag, format, params);
    }

    public static void w(boolean force, String tag, String format, Object ... params) {
        if (Log.canLog() || force) {
            logger.w(LOGTAG + tag, format, params);
        }
    }

    static Iterable<String> split(String input, int maxLength) {
        ArrayList<String> output = new ArrayList<String>();
        if (input == null || input.length() == 0) {
            return output;
        }
        for (int i = 0; i < input.length(); i += maxLength) {
            output.add(input.substring(i, Math.min(input.length(), i + maxLength)));
        }
        return output;
    }

    public static final void enableLoggingWithSetterNotification(String tag, boolean enable) {
        if (!enable) {
            Log.logSetterNotification(tag, "Debug logging", enable);
        }
        Log.enableLogging(enable);
        if (enable) {
            Log.logSetterNotification(tag, "Debug logging", enable);
            Log.d(tag, "Amazon Mobile Ads API Version: %s", Version.getRawSDKVersion());
        }
    }

    public static final void logSetterNotification(String tag, String capitalizedSingularPropertyName, Object value) {
        if (!Log.canLog()) {
            return;
        }
        if (value instanceof Boolean) {
            Log.d(tag, "%s has been %s.", capitalizedSingularPropertyName, (Boolean)value != false ? "enabled" : "disabled");
        } else {
            Log.d(tag, "%s has been set: %s", capitalizedSingularPropertyName, String.valueOf(value));
        }
    }

    private static class LogcatLogger
    implements ILog {
        private static final int MAX_LENGTH = 1000;

        private LogcatLogger() {
        }

        public void i(String tag, String msg) {
            for (String data : Log.split(msg, 1000)) {
                android.util.Log.i((String)tag, (String)data);
            }
        }

        public void v(String tag, String msg) {
            for (String data : Log.split(msg, 1000)) {
                android.util.Log.v((String)tag, (String)data);
            }
        }

        public void d(String tag, String msg) {
            for (String data : Log.split(msg, 1000)) {
                android.util.Log.d((String)tag, (String)data);
            }
        }

        public void w(String tag, String msg) {
            for (String data : Log.split(msg, 1000)) {
                android.util.Log.w((String)tag, (String)data);
            }
        }

        public void e(String tag, String msg) {
            for (String data : Log.split(msg, 1000)) {
                android.util.Log.e((String)tag, (String)data);
            }
        }

        public void i(String tag, String format, Object ... params) {
            this.i(tag, String.format(format, params));
        }

        public void v(String tag, String format, Object ... params) {
            this.v(tag, String.format(format, params));
        }

        public void d(String tag, String format, Object ... params) {
            this.d(tag, String.format(format, params));
        }

        public void w(String tag, String format, Object ... params) {
            this.w(tag, String.format(format, params));
        }

        public void e(String tag, String format, Object ... params) {
            this.e(tag, String.format(format, params));
        }
    }
}

