/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AppInfo;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.IInternalAdRegistration;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISRegistration;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.Version;
import java.io.File;

class InternalAdRegistration
implements IInternalAdRegistration {
    public static final String LOG_TAG = InternalAdRegistration.class.getSimpleName();
    private AppInfo appInfo;
    private DeviceInfo deviceInfo;
    private RegistrationInfo registrationInfo;
    private SISRegistration sisRegistration;
    private boolean contextReceived;
    private boolean isRegistered;
    private int noRetryTtlMillis;
    private long noRetryTtlExpiresMillis;
    private boolean isAppDisabled = false;
    private File filesDirectory;
    protected Context applicationContext;
    private static IInternalAdRegistration instance = new InternalAdRegistration();

    protected InternalAdRegistration() {
        DebugProperties.readDebugProperties();
        Version.getSDKVersion();
        this.registrationInfo = new RegistrationInfo();
    }

    public static IInternalAdRegistration getInstance() {
        return instance;
    }

    protected static void setInstance(IInternalAdRegistration newInstance) {
        instance = newInstance;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public RegistrationInfo getRegistrationInfo() {
        return this.registrationInfo;
    }

    public synchronized void contextReceived(Context context) {
        if (!this.contextReceived) {
            this.contextReceived = true;
            this.setApplicationContextFromContext(context);
            this.setFilesDirectory(context);
            Settings.getInstance().contextReceived(context);
            this.createAppInfo(context);
            this.createDeviceInfo(context);
            this.createSISRegistration();
        }
    }

    public boolean isContextReceived() {
        return this.contextReceived;
    }

    protected void setFilesDirectory(Context context) {
        this.filesDirectory = context.getFilesDir();
    }

    protected void createAppInfo(Context context) {
        this.appInfo = new AppInfo(context);
    }

    protected void createDeviceInfo(Context context) {
        this.deviceInfo = new DeviceInfo(context);
    }

    public void register() {
        this.getSISRegistration().registerApp();
        this.isRegistered = true;
    }

    protected void createSISRegistration() {
        this.sisRegistration = new SISRegistration();
    }

    protected SISRegistration getSISRegistration() {
        return this.sisRegistration;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public int getNoRetryTtlRemainingMillis() {
        if (this.noRetryTtlMillis == 0 || this.noRetryTtlExpiresMillis == 0L) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.noRetryTtlExpiresMillis) {
            this.noRetryTtlMillis = 0;
            this.noRetryTtlExpiresMillis = 0L;
            return 0;
        }
        long timeRemaining = this.noRetryTtlExpiresMillis - currentTime;
        return (int)timeRemaining;
    }

    public void setNoRetryTtl(int noRetryTtlSeconds) {
        int maxNoRetryTtlSeconds = Configuration.getMaxNoRetryTtl();
        if (maxNoRetryTtlSeconds < noRetryTtlSeconds) {
            noRetryTtlSeconds = maxNoRetryTtlSeconds;
        }
        if (noRetryTtlSeconds == 0) {
            this.noRetryTtlMillis = 0;
            this.noRetryTtlExpiresMillis = 0L;
        } else {
            this.noRetryTtlMillis = noRetryTtlSeconds * 1000;
            this.noRetryTtlExpiresMillis = System.currentTimeMillis() + (long)this.noRetryTtlMillis;
        }
    }

    public boolean getIsAppDisabled() {
        return this.isAppDisabled;
    }

    public void setIsAppDisabled(boolean isAppDisabled) {
        this.isAppDisabled = isAppDisabled;
    }

    public File getFilesDir() {
        return this.filesDirectory;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    protected void setApplicationContextFromContext(Context context) {
        this.applicationContext = context.getApplicationContext();
    }
}

