/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Log;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.WebRequest;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;

class HttpURLConnectionWebRequest
extends WebRequest {
    private static final String LOG_TAG = HttpURLConnectionWebRequest.class.getSimpleName();

    HttpURLConnectionWebRequest() {
    }

    protected WebRequest.WebResponse doHttpNetworkCall(URL url) throws WebRequest.WebRequestException {
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(url);
        }
        catch (IOException e) {
            Log.e(this.getLogTag(), "Problem while opening the URL connection: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "Problem while opening the URL connection", e);
        }
        this.setupRequestProperties(connection);
        try {
            connection.connect();
        }
        catch (SocketTimeoutException e) {
            Log.e(this.getLogTag(), "Socket timed out while connecting to URL: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_TIMEOUT, "Socket timed out while connecting to URL", e);
        }
        catch (IOException e) {
            Log.e(this.getLogTag(), "Problem while connecting to URL: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "Problem while connecting to URL", e);
        }
        return this.prepareResponse(connection);
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected void setupRequestProperties(HttpURLConnection connection) throws WebRequest.WebRequestException {
        try {
            connection.setRequestMethod(this.getHttpMethod().name());
        }
        catch (ProtocolException e) {
            Log.e(this.getLogTag(), "Invalid client protocol: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.INVALID_CLIENT_PROTOCOL, "Invalid client protocol", e);
        }
        for (Map.Entry header : this.headers.entrySet()) {
            if (header.getValue() == null || ((String)header.getValue()).equals("")) continue;
            connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
        }
        connection.setConnectTimeout(this.getTimeout());
        connection.setReadTimeout(this.getTimeout());
        this.logUrl(connection.getURL().toString());
        switch (this.getHttpMethod()) {
            case GET: {
                connection.setDoOutput(false);
                break;
            }
            case POST: {
                connection.setDoOutput(true);
                this.writePostBody(connection);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePostBody(HttpURLConnection connection) throws WebRequest.WebRequestException {
        StringBuilder postBody = new StringBuilder();
        if (this.requestBody != null) {
            postBody.append(this.requestBody);
        } else if (this.postParameters != null && !this.postParameters.isEmpty()) {
            for (Map.Entry param : this.postParameters.entrySet()) {
                postBody.append((String)param.getKey()).append("=").append(Utils.getURLEncodedString((String)param.getValue())).append("&");
            }
            postBody.deleteCharAt(postBody.lastIndexOf("&"));
        }
        if (this.logRequestBodyEnabled && this.getRequestBody() != null) {
            Log.d(this.getLogTag(), "Request Body: %s", this.getRequestBody());
        }
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            out.write(postBody.toString());
            if (out == null) return;
        }
        catch (IOException e) {
            try {
                Log.e(this.getLogTag(), "Problem while creating output steam for request body: %s", e.getMessage());
                throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "Problem while creating output steam for request body", e);
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Log.e(this.getLogTag(), "Problem while closing output stream writer for request body: %s", e2.getMessage());
                    throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "Problem while closing output stream writer for request body", e2);
                }
            }
        }
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            Log.e(this.getLogTag(), "Problem while closing output stream writer for request body: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "Problem while closing output stream writer for request body", e);
        }
    }

    protected WebRequest.WebResponse prepareResponse(HttpURLConnection connection) throws WebRequest.WebRequestException {
        WebRequest.WebResponse webResponse = new WebRequest.WebResponse(this);
        webResponse.setLogTag(this.getLogTag());
        webResponse.enableLog(this.logResponseEnabled);
        try {
            webResponse.setHttpStatusCode(connection.getResponseCode());
            webResponse.setHttpStatus(connection.getResponseMessage());
        }
        catch (SocketTimeoutException e) {
            Log.e(this.getLogTag(), "Socket Timeout while getting the response status code: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_TIMEOUT, "Socket Timeout while getting the response status code", e);
        }
        catch (IOException e) {
            Log.e(this.getLogTag(), "IOException while getting the response status code: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "IOException while getting the response status code", e);
        }
        if (webResponse.getHttpStatusCode() == 200) {
            try {
                webResponse.setInputStream(connection.getInputStream());
            }
            catch (IOException e) {
                Log.e(this.getLogTag(), "IOException while reading the input stream from response: %s", e.getMessage());
                throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "IOException while reading the input stream from response", e);
            }
        }
        return webResponse;
    }

    protected String getSubLogTag() {
        return LOG_TAG;
    }
}

