/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.ReflectionCache;
import com.amazon.device.ads.Reflector;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.ThrowableReflector;
import java.io.IOException;

class GooglePlayServices {
    private static final String LOG_TAG = GooglePlayServices.class.getSimpleName();
    private static final String GPS_AVAILABLE_SETTING = "gps-available";

    GooglePlayServices() {
    }

    private boolean isGPSAvailable() {
        return Settings.getInstance().getBoolean(GPS_AVAILABLE_SETTING, true);
    }

    private boolean isGPSAIDFeatureEnabled() {
        return Configuration.getInstance().getBooleanWithDefault(Configuration.FeatureConfigOption.USE_GPS_ADVERTISING_ID, true);
    }

    protected AdvertisingIdClient createAdvertisingIdClient() {
        return new AdvertisingIdClient();
    }

    public AdvertisingInfo getAdvertisingIdentifierInfo() {
        AdvertisingIdClient.Info info;
        if (!this.isGPSAIDFeatureEnabled()) {
            Log.v(LOG_TAG, "The Google Play Services Advertising Identifier feature is not enabled.");
            return new AdvertisingInfo().setGPSAIDFeatureEnabled(false);
        }
        if (!this.isGPSAvailable()) {
            Log.v(LOG_TAG, "The Google Play Services Advertising Identifier feature is not available.");
            return new AdvertisingInfo().setGPSAvailable(false);
        }
        AdvertisingIdClient advertisingIdClient = this.createAdvertisingIdClient();
        if (!advertisingIdClient.isValid()) {
            Log.v(LOG_TAG, "The Google Play Services Advertising Identifier library was unable to be reflected.");
            this.setGooglePlayServicesAvailable(false);
            return new AdvertisingInfo().setGPSAvailable(false);
        }
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        try {
            info = advertisingIdClient.getAdvertisingIdInfo(context);
        }
        catch (IllegalStateException e) {
            Log.e(LOG_TAG, "The Google Play Services Advertising Id API was called from a non-background thread.");
            return new AdvertisingInfo();
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Retrieving the Google Play Services Advertising Identifier caused an IOException.");
            return new AdvertisingInfo();
        }
        catch (GooglePlayServicesNotAvailableException e) {
            Log.v(LOG_TAG, "Retrieving the Google Play Services Advertising Identifier caused a GooglePlayServicesNotAvailableException.");
            this.setGooglePlayServicesAvailable(false);
            return new AdvertisingInfo().setGPSAvailable(false);
        }
        catch (GooglePlayServicesRepairableException e) {
            Log.v(LOG_TAG, "Retrieving the Google Play Services Advertising Identifier caused a GooglePlayServicesRepairableException.");
            return new AdvertisingInfo();
        }
        Log.v(LOG_TAG, "The Google Play Services Advertising Identifier was successfully retrieved.");
        this.setGooglePlayServicesAvailable(true);
        String advertisingId = info.getId();
        boolean limitAdTrackingEnabled = info.isLimitAdTrackingEnabled();
        return new AdvertisingInfo().setAdvertisingIdentifier(advertisingId).setLimitAdTrackingEnabled(limitAdTrackingEnabled);
    }

    private void setGooglePlayServicesAvailable(boolean available) {
        Settings.getInstance().putTransientBoolean(GPS_AVAILABLE_SETTING, available);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GooglePlayServicesRepairableException
    extends ThrowableReflector {
        private static final long serialVersionUID = 2188408730610519113L;
        private static final String REFLECTED_CLASS_NAME = "com.google.android.gms.common.GooglePlayServicesRepairableException";

        public GooglePlayServicesRepairableException(Object object) {
            super(GooglePlayServicesRepairableException.getReflectedClass(), object);
        }

        public static Class<?> getReflectedClass() {
            return ReflectionCache.getInstance().getClass(REFLECTED_CLASS_NAME);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GooglePlayServicesNotAvailableException
    extends ThrowableReflector {
        private static final long serialVersionUID = 4117521149484373667L;
        private static final String REFLECTED_CLASS_NAME = "com.google.android.gms.common.GooglePlayServicesNotAvailableException";

        public GooglePlayServicesNotAvailableException(Object object) {
            super(GooglePlayServicesNotAvailableException.getReflectedClass(), object);
        }

        public static Class<?> getReflectedClass() {
            return ReflectionCache.getInstance().getClass(REFLECTED_CLASS_NAME);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AdvertisingIdClient
    extends Reflector {
        private static final String REFLECTED_CLASS_NAME = "com.google.android.gms.ads.identifier.AdvertisingIdClient";

        public AdvertisingIdClient() {
            super(AdvertisingIdClient.getReflectedClass());
        }

        public static Class<?> getReflectedClass() {
            return ReflectionCache.getInstance().getClass(REFLECTED_CLASS_NAME);
        }

        public Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
            try {
                Object object = this.invoke("getAdvertisingIdInfo", null, new Class[]{Context.class}, new Object[]{context});
                Info info = new Info((Object)object);
                return info;
            }
            catch (Throwable e) {
                if (e.getClass().equals(IOException.class)) {
                    throw (IOException)e;
                }
                if (e.getClass().equals(IllegalStateException.class)) {
                    throw (IllegalStateException)e;
                }
                if (e.getClass().equals(GooglePlayServicesNotAvailableException.getReflectedClass())) {
                    throw new GooglePlayServicesNotAvailableException((Object)e);
                }
                if (e.getClass().equals(GooglePlayServicesRepairableException.getReflectedClass())) {
                    throw new GooglePlayServicesRepairableException((Object)e);
                }
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Info
        extends Reflector {
            private static final String REFLECTED_CLASS_NAME = "com.google.android.gms.ads.identifier.AdvertisingIdClient$Info";

            public Info(Object object) {
                super(Info.getReflectedClass(), object);
            }

            public static Class<?> getReflectedClass() {
                return ReflectionCache.getInstance().getClass(REFLECTED_CLASS_NAME);
            }

            public String getId() {
                try {
                    return this.invoke("getId", null, null, null);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            public boolean isLimitAdTrackingEnabled() {
                try {
                    return this.invoke("isLimitAdTrackingEnabled", false, null, null);
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
        }
    }

    static class AdvertisingInfo {
        private boolean gpsaidFeatureEnabled = true;
        private boolean gpsAvailable = true;
        private String advertisingIdentifier;
        private boolean limitAdTrackingEnabled;

        protected AdvertisingInfo() {
        }

        boolean isGPSAIDFeatureEnabled() {
            return this.gpsaidFeatureEnabled;
        }

        private AdvertisingInfo setGPSAIDFeatureEnabled(boolean gpsaidFeatureEnabled) {
            this.gpsaidFeatureEnabled = gpsaidFeatureEnabled;
            return this;
        }

        boolean isGPSAvailable() {
            return this.gpsAvailable;
        }

        private AdvertisingInfo setGPSAvailable(boolean gpsAvailable) {
            this.gpsAvailable = gpsAvailable;
            return this;
        }

        String getAdvertisingIdentifier() {
            return this.advertisingIdentifier;
        }

        private AdvertisingInfo setAdvertisingIdentifier(String advertisingIdentifier) {
            this.advertisingIdentifier = advertisingIdentifier;
            return this;
        }

        boolean hasAdvertisingIdentifier() {
            return this.getAdvertisingIdentifier() != null;
        }

        boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }

        private AdvertisingInfo setLimitAdTrackingEnabled(boolean limitAdTrackingEnabled) {
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            return this;
        }
    }
}

