/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.Environment;
import com.amazon.device.ads.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Properties;
import javax.crypto.Cipher;

class DebugProperties {
    private static final String LOG_TAG = DebugProperties.class.getSimpleName();
    private static final String FILE_PREFIX = "/com.amazon.device.ads.debug";
    public static final String DEBUG_ON = "debug.mode";
    public static final String DEBUG_LOGGING = "debug.logging";
    public static final String DEBUG_AAX_CONFIG_HOSTNAME = "debug.aaxConfigHostname";
    public static final String DEBUG_AAX_CONFIG_USE_SECURE = "debug.aaxConfigUseSecure";
    public static final String DEBUG_AAX_CONFIG_PARAMS = "debug.aaxConfigParams";
    public static final String DEBUG_AAX_AD_PARAMS = "debug.aaxAdParams";
    public static final String DEBUG_AAX_AD_HOSTNAME = "debug.aaxHostname";
    public static final String DEBUG_SIS_URL = "debug.sisURL";
    public static final String DEBUG_SIS_DOMAIN = "debug.sisDomain";
    public static final String DEBUG_MADS_HOSTNAME = "debug.madsHostname";
    public static final String DEBUG_MADS_USE_SECURE = "debug.madsUseSecure";
    public static final String DEBUG_SEND_GEO = "debug.sendGeo";
    public static final String DEBUG_CHANNEL = "debug.channel";
    public static final String DEBUG_SIZE = "debug.size";
    public static final String DEBUG_PT = "debug.pt";
    public static final String DEBUG_SLOT = "debug.slot";
    public static final String DEBUG_SLOTS = "debug.slots";
    public static final String DEBUG_SLOT_ID = "debug.slotId";
    public static final String DEBUG_ECPM = "debug.ec";
    public static final String DEBUG_APPID = "debug.appid";
    public static final String DEBUG_ADID = "debug.adid";
    public static final String DEBUG_PK = "debug.pk";
    public static final String DEBUG_DINFO = "debug.dinfo";
    public static final String DEBUG_PKG = "debug.pkg";
    public static final String DEBUG_GEOLOC = "debug.geoloc";
    public static final String DEBUG_MD5UDID = "debug.md5udid";
    public static final String DEBUG_MXSZ = "debug.mxsz";
    public static final String DEBUG_PA = "debug.pa";
    public static final String DEBUG_SHA1UDID = "debug.sha1udid";
    public static final String DEBUG_SP = "debug.sp";
    public static final String DEBUG_TEST = "debug.test";
    public static final String DEBUG_UA = "debug.ua";
    public static final String DEBUG_UI = "debug.ui";
    public static final String DEBUG_VER = "debug.ver";
    public static final String DEBUG_NORETRYTTL = "debug.noRetryTTL";
    public static final String DEBUG_NORETRYTTL_MAX = "debug.noRetryTTLMax";
    public static final String DEBUG_TLS_ENABLED = "debug.tlsEnabled";
    public static final String DEBUG_AD_PREF_URL = "debug.adPrefURL";
    public static final String DEBUG_SHOULD_IDENTIFY_USER = "debug.shouldIdentifyUser";
    public static final String DEBUG_SHOULD_REGISTER_SIS = "debug.shouldRegisterSIS";
    public static final String DEBUG_CONFIG_FEATURE_USE_GPS_ADVERTISING_ID = "debug.fUseGPSAID";
    public static final String DEBUG_IDFA = "debug.idfa";
    public static final String DEBUG_OPT_OUT = "debug.optOut";
    public static final String DEBUG_SHOULD_FETCH_CONFIG = "debug.shouldFetchConfig";
    private static final BigInteger privModulus = new BigInteger("22425945969293236512819607281747202268852113345956851069545419503178249900977203670147638322801582881051882957295768557918356441519366172126884608406316888515239296504501830280664879549133570276792155151832332847188532369002492210234019359186842709493620665119919750832332220777141369255943445578381285984064028865613478676828533273460580467686485184132743895959747097454385452868408957601246667523882372216446056029831689133478714597838700864119273209955182548633182248700235085802575904827859971001196599005060045450779595767759943984991630413046800554347791145167910883355627096118148593841261053098773337592734097");
    private static final BigInteger privExponent = new BigInteger("5599215006722084151841970702827860151139465197978118529242591197804380779249736540498127864809226859371835159226553869008622098243456195347852554241917744888762998133926842072150379542281041403163862165638226686887497980590930009552760406707269286898150890998325325890252103828011111664174475487114957696526157790937869377570600085450453371238028811033168218737171144699577236108423054506552958366535341910569552237227686862748056351625445281035713423043506793107235726047151346608576583081807969458368853010104969843563629579750936551771756389538574062221915919980316992216032119182896925094308799622409361028579777");
    private static Properties debugProperties = new Properties();
    private static boolean debugModeOn = false;

    DebugProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readDebugProperties() {
        String storageState = Environment.getExternalStorageState();
        if ("mounted".equals(storageState)) {
            String filename = Environment.getExternalStorageDirectory() + FILE_PREFIX;
            File file = new File(filename);
            if (!file.exists() || file.length() > Integer.MAX_VALUE) {
                return;
            }
            try {
                InputStream input = null;
                try {
                    int totalBytesRead = 0;
                    input = new BufferedInputStream(new FileInputStream(file));
                    byte[] res = new byte[(int)file.length()];
                    while (totalBytesRead < res.length) {
                        int bytesRemaining = res.length - totalBytesRead;
                        int bytesRead = input.read(res, totalBytesRead, bytesRemaining);
                        if (bytesRead <= 0) continue;
                        totalBytesRead += bytesRead;
                    }
                    byte[] decrypted = DebugProperties.decrypt(res);
                    if (decrypted != null) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(decrypted);
                        debugProperties.clear();
                        debugProperties.load(bais);
                        String debug = debugProperties.getProperty(DEBUG_ON, "false");
                        if (debug.equals("true")) {
                            debugModeOn = true;
                        }
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getDebugPropertyAsString(String property, String defaultValue) {
        if (!debugModeOn) {
            return defaultValue;
        }
        return debugProperties.getProperty(property, defaultValue);
    }

    public static int getDebugPropertyAsInteger(String property, int defaultValue) {
        return DebugProperties.getDebugPropertyAsInteger(property, (Integer)defaultValue);
    }

    public static Integer getDebugPropertyAsInteger(String property, Integer defaultValue) {
        if (!debugModeOn) {
            return defaultValue;
        }
        String propertyValue = debugProperties.getProperty(property);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            Log.e(LOG_TAG, "Unable to parse integer debug property - property: %s, value: %s", property, propertyValue);
            return defaultValue;
        }
    }

    public static boolean getDebugPropertyAsBoolean(String property, boolean defaultValue) {
        return DebugProperties.getDebugPropertyAsBoolean(property, (Boolean)defaultValue);
    }

    public static Boolean getDebugPropertyAsBoolean(String property, Boolean defaultValue) {
        if (!debugModeOn) {
            return defaultValue;
        }
        String propertyValue = debugProperties.getProperty(property);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(propertyValue);
        }
        catch (NumberFormatException e) {
            Log.e(LOG_TAG, "Unable to parse boolean debug property - property: %s, value: %s", property, propertyValue);
            return defaultValue;
        }
    }

    public static long getDebugPropertyAsLong(String property, long defaultValue) {
        return DebugProperties.getDebugPropertyAsLong(property, (Long)defaultValue);
    }

    public static Long getDebugPropertyAsLong(String property, Long defaultValue) {
        if (!debugModeOn) {
            return defaultValue;
        }
        String propertyValue = debugProperties.getProperty(property);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            Log.e(LOG_TAG, "Unable to parse long debug property - property: %s, value: %s", property, propertyValue);
            return defaultValue;
        }
    }

    public static boolean containsDebugProperty(String property) {
        if (!debugModeOn) {
            return false;
        }
        return debugProperties.containsKey(property);
    }

    public static boolean isDebugModeOn() {
        return debugModeOn;
    }

    protected static byte[] decrypt(byte[] data) {
        byte[] decryptedData = null;
        try {
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(privModulus, privExponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey key = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            decryptedData = cipher.doFinal(data);
        }
        catch (Exception e) {
            Log.d(LOG_TAG, "Exception " + e + " trying to decrypt debug file");
        }
        return decryptedData;
    }

    static void setDebugProperty(String property, String value) {
        debugProperties.put(property, value);
    }

    static void enableDebugging() {
        debugModeOn = true;
    }

    static void disableDebugging() {
        debugModeOn = false;
    }
}

