/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.Parcel;
import android.os.Parcelable;
import com.amazon.device.ads.Log;
import java.lang.reflect.Field;

class Controller {
    private static String LOG_TAG = "Controller";

    Controller() {
    }

    public static class PlayerProperties
    extends ReflectedParcelable {
        public boolean autoPlay;
        public boolean showControl;
        public boolean doLoop;
        public boolean audioMuted;
        public boolean inline;
        public String stopStyle;
        public String startStyle;
        public static final Parcelable.Creator<PlayerProperties> CREATOR = new Parcelable.Creator<PlayerProperties>(){

            public PlayerProperties createFromParcel(Parcel source) {
                return new PlayerProperties(source);
            }

            public PlayerProperties[] newArray(int size) {
                return new PlayerProperties[size];
            }
        };

        public PlayerProperties() {
            this.autoPlay = true;
            this.showControl = true;
            this.doLoop = false;
            this.audioMuted = false;
            this.startStyle = "normal";
            this.stopStyle = "normal";
        }

        public PlayerProperties(Parcel in) {
            super(in);
        }

        public void setProperties(boolean audioMuted, boolean autoPlay, boolean controls, boolean inline, boolean loop, String startStyle, String stopStyle) {
            this.audioMuted = audioMuted;
            this.autoPlay = autoPlay;
            this.showControl = controls;
            this.inline = inline;
            this.doLoop = loop;
            this.startStyle = startStyle;
            this.stopStyle = stopStyle;
        }

        public void muteAudio() {
            this.audioMuted = true;
        }

        public boolean isAutoPlay() {
            return this.autoPlay;
        }

        public boolean showControl() {
            return this.showControl;
        }

        public boolean doLoop() {
            return this.doLoop;
        }

        public boolean doMute() {
            return this.audioMuted;
        }

        public boolean exitOnComplete() {
            return this.stopStyle.equalsIgnoreCase("exit");
        }

        public boolean isFullScreen() {
            return this.startStyle.equalsIgnoreCase("fullscreen");
        }
    }

    public static class Dimensions
    extends ReflectedParcelable {
        public int x;
        public int y;
        public int width;
        public int height;
        public static final Parcelable.Creator<Dimensions> CREATOR = new Parcelable.Creator<Dimensions>(){

            public Dimensions createFromParcel(Parcel source) {
                return new Dimensions(source);
            }

            public Dimensions[] newArray(int size) {
                return new Dimensions[size];
            }
        };

        public Dimensions() {
            this.x = -1;
            this.y = -1;
            this.width = -1;
            this.height = -1;
        }

        public Dimensions(Parcel in) {
            super(in);
        }
    }

    public static class ReflectedParcelable
    implements Parcelable {
        public static final Parcelable.Creator<ReflectedParcelable> CREATOR = new Parcelable.Creator<ReflectedParcelable>(){

            public ReflectedParcelable createFromParcel(Parcel source) {
                return new ReflectedParcelable(source);
            }

            public ReflectedParcelable[] newArray(int size) {
                return new ReflectedParcelable[size];
            }
        };

        public ReflectedParcelable() {
        }

        protected ReflectedParcelable(Parcel in) {
            Field[] fields;
            Class<?> c = this.getClass();
            for (Field f : fields = c.getDeclaredFields()) {
                try {
                    Object dt = f.get(this);
                    if (dt instanceof Parcelable.Creator) continue;
                    f.set(this, in.readValue(null));
                }
                catch (IllegalAccessException e) {
                    Log.e(LOG_TAG, "Error: Could not create object from parcel: %s", e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    Log.e(LOG_TAG, "Error: Could not create object from parcel: %s", e.getMessage());
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            Field[] fields;
            Class<?> c = this.getClass();
            for (Field f : fields = c.getDeclaredFields()) {
                try {
                    Object dt = f.get(this);
                    if (dt instanceof Parcelable.Creator) continue;
                    dest.writeValue(dt);
                }
                catch (IllegalAccessException e) {
                    Log.e(LOG_TAG, "Error: Could not write to parcel: %s", e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    Log.e(LOG_TAG, "Error: Could not write to parcel: %s", e.getMessage());
                }
            }
        }
    }
}

