/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.PreferredMarketplaceRetriever;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

class Configuration {
    private static final String LOG_TAG = Configuration.class.getSimpleName();
    private static final String AAX_PROD_US_HOSTNAME = "aax-us-east.amazon-adsystem.com";
    private static final String AAX_MSDK_CONFIG_ENDPOINT = "/e/msdk/cfg";
    protected static final int MAX_NO_RETRY_TTL = 300000;
    protected static final int MAX_CONFIG_TTL = 172800;
    protected static final String CONFIG_TTL = "config-ttl";
    protected static final String CONFIG_LASTFETCHTIME = "config-lastFetchTime";
    protected static final String CONFIG_APP_DEFINED_MARKETPLACE = "config-appDefinedMarketplace";
    protected static final String CONFIG_VERSION_NAME = "configVersion";
    protected static final int CURRENT_CONFIG_VERSION = 1;
    protected static Configuration instance = new Configuration();
    private String appDefinedMarketplace = null;
    private boolean isAppDefinedMarketplaceSet = false;
    private List<ConfigurationListener> listeners = null;
    private AtomicBoolean isFetching = null;
    private Boolean lastTestModeValue = null;
    private boolean isFirstParty = false;
    private PreferredMarketplaceRetriever pfmRetriever = new PreferredMarketplaceRetriever.NullPreferredMarketplaceRetriever();

    protected Configuration() {
        this.listeners = new ArrayList<ConfigurationListener>(5);
        this.isFetching = new AtomicBoolean(false);
    }

    public static final Configuration getInstance() {
        return instance;
    }

    public String getAppDefinedMarketplace() {
        return this.appDefinedMarketplace;
    }

    public void setAppDefinedMarketplace(String appDefinedMarketplace) {
        this.appDefinedMarketplace = appDefinedMarketplace;
        this.isAppDefinedMarketplaceSet = true;
    }

    public void setIsFirstParty(boolean isFirstParty) {
        this.isFirstParty = isFirstParty;
    }

    boolean isFirstParty() {
        return this.isFirstParty;
    }

    public String getString(ConfigOption configOption) {
        String value = DebugProperties.getDebugPropertyAsString(configOption.getDebugProperty(), null);
        if (value == null) {
            value = Settings.getInstance().getString(configOption.getSettingsName(), null);
        }
        return value;
    }

    public boolean getBoolean(ConfigOption configOption) {
        return this.getBooleanWithDefault(configOption, false);
    }

    public boolean getBooleanWithDefault(ConfigOption configOption, boolean defaultValue) {
        if (DebugProperties.containsDebugProperty(configOption.getDebugProperty())) {
            return DebugProperties.getDebugPropertyAsBoolean(configOption.getDebugProperty(), defaultValue);
        }
        return Settings.getInstance().getBoolean(configOption.getSettingsName(), defaultValue);
    }

    public static int getMaxNoRetryTtl() {
        return DebugProperties.getDebugPropertyAsInteger("debug.noRetryTTLMax", 300000);
    }

    protected boolean shouldFetch() {
        Settings settings = Settings.getInstance();
        if (this.hasAppDefinedMarketplaceChanged()) {
            return true;
        }
        if (Settings.getInstance().getInt(CONFIG_VERSION_NAME, 0) != 1) {
            return true;
        }
        long currentTime = this.nanoTime();
        long lastFetchTime = settings.getLong(CONFIG_LASTFETCHTIME, 0L);
        long ttl = settings.getInt(CONFIG_TTL, 172800);
        if (lastFetchTime == 0L) {
            Log.d(LOG_TAG, "No configuration found. A new configuration will be retrieved.");
            return true;
        }
        if (currentTime - lastFetchTime > Utils.convertToNsFromS(ttl)) {
            Log.d(LOG_TAG, "The configuration has expired. A new configuration will be retrieved.");
            return true;
        }
        if (this.lastTestModeValue != null && this.lastTestModeValue.booleanValue() != settings.getBoolean("testingEnabled", false)) {
            Log.d(LOG_TAG, "The testing mode has changed. A new configuration will be retrieved.");
            return true;
        }
        return DebugProperties.getDebugPropertyAsBoolean("debug.shouldFetchConfig", false);
    }

    private boolean hasAppDefinedMarketplaceChanged() {
        Settings settings = Settings.getInstance();
        String storedAppDefinedMarketplace = settings.getString(CONFIG_APP_DEFINED_MARKETPLACE, null);
        boolean appDefinedMarketplaceChanged = false;
        if (this.isAppDefinedMarketplaceSet) {
            this.isAppDefinedMarketplaceSet = false;
            if (this.appDefinedMarketplace != null && !this.appDefinedMarketplace.equals(storedAppDefinedMarketplace)) {
                settings.putLongWithNoFlush(CONFIG_LASTFETCHTIME, 0L);
                settings.putStringWithNoFlush(CONFIG_APP_DEFINED_MARKETPLACE, this.appDefinedMarketplace);
                settings.flush();
                InternalAdRegistration.getInstance().getRegistrationInfo().requestNewSISDeviceIdentifier();
                Log.d(LOG_TAG, "New application-defined marketplace set. A new configuration will be retrieved.");
                appDefinedMarketplaceChanged = true;
            } else if (storedAppDefinedMarketplace != null && this.appDefinedMarketplace == null) {
                settings.remove(CONFIG_APP_DEFINED_MARKETPLACE);
                InternalAdRegistration.getInstance().getRegistrationInfo().requestNewSISDeviceIdentifier();
                Log.d(LOG_TAG, "Application-defined marketplace removed. A new configuration will be retrieved.");
                appDefinedMarketplaceChanged = true;
            }
        }
        return appDefinedMarketplaceChanged;
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    protected boolean isFetching() {
        return this.isFetching.get();
    }

    protected void setIsFetching(boolean isFetching) {
        this.isFetching.set(isFetching);
    }

    public synchronized void queueConfigurationListener(ConfigurationListener listener) {
        this.queueConfigurationListener(listener, true);
    }

    public synchronized void queueConfigurationListener(ConfigurationListener listener, boolean allowFetch) {
        if (this.isFetching()) {
            this.listeners.add(listener);
        } else if (this.shouldFetch()) {
            this.listeners.add(listener);
            if (allowFetch) {
                Log.d(LOG_TAG, "Starting configuration fetching...");
                this.setIsFetching(true);
                this.beginFetch();
            }
        } else {
            listener.onConfigurationReady();
        }
    }

    protected void beginFetch() {
        ThreadUtils.executeRunnable(new Runnable(){

            public void run() {
                Configuration.this.fetchConfigurationOnBackgroundThread();
            }
        });
    }

    protected synchronized void onFetchSuccess() {
        ConfigurationListener[] toCall;
        this.setIsFetching(false);
        for (ConfigurationListener listener : toCall = this.getAndClearListeners()) {
            listener.onConfigurationReady();
        }
    }

    protected synchronized void onFetchFailure() {
        ConfigurationListener[] toCall;
        Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AAX_CONFIG_DOWNLOAD_FAILED);
        this.setIsFetching(false);
        for (ConfigurationListener listener : toCall = this.getAndClearListeners()) {
            listener.onConfigurationFailure();
        }
    }

    protected synchronized ConfigurationListener[] getAndClearListeners() {
        ConfigurationListener[] toCall = new ConfigurationListener[this.listeners.size()];
        toCall = this.listeners.toArray(toCall);
        this.listeners.clear();
        return toCall;
    }

    protected ConfigOption[] getConfigOptions() {
        return ConfigOption.configOptions;
    }

    protected void setLastTestModeValue(boolean testMode) {
        this.lastTestModeValue = testMode;
    }

    protected void fetchConfigurationOnBackgroundThread() {
        Log.d(LOG_TAG, "In configuration fetcher background thread.");
        boolean passesInternetPermissionCheck = PermissionChecker.getInstance().passesInternetPermissionCheck(InternalAdRegistration.getInstance().getApplicationContext(), LOG_TAG);
        if (!passesInternetPermissionCheck) {
            this.onFetchFailure();
            return;
        }
        AdvertisingIdentifier.Info advertisingIdentifierInfo = this.createAdvertisingIdentifierInfo();
        if (!advertisingIdentifierInfo.canDo()) {
            this.onFetchFailure();
            return;
        }
        WebRequest webRequest = this.createWebRequest(advertisingIdentifierInfo);
        WebRequest.WebResponse webResponse = null;
        try {
            webResponse = webRequest.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            this.onFetchFailure();
            return;
        }
        Log.d(LOG_TAG, "Response Body: %s", webResponse.getBody());
        JSONObject json = webResponse.getJSONObjectBody();
        Settings settings = Settings.getInstance();
        int ttl = 172800;
        try {
            for (ConfigOption configOption : this.getConfigOptions()) {
                if (json.isNull(configOption.getResponseKey())) {
                    if (!configOption.getAllowEmpty()) {
                        throw new Exception("The configuration value must be present and not null.");
                    }
                    settings.removeWithNoFlush(configOption.getSettingsName());
                    continue;
                }
                this.writeSettingFromConfigOption(configOption, json);
            }
            for (ConfigOption configOption : FeatureConfigOption.featureConfigOptions) {
                if (!json.has(configOption.getResponseKey())) continue;
                this.writeSettingFromConfigOption(configOption, json);
            }
            if (json.isNull("ttl")) {
                throw new Exception("The configuration value must be present and not null.");
            }
            ttl = json.getInt("ttl");
        }
        catch (JSONException e) {
            Log.e(LOG_TAG, "Unable to parse JSON response: %s", e.getMessage());
            this.onFetchFailure();
            return;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Unexpected error during parsing: %s", e.getMessage());
            this.onFetchFailure();
            return;
        }
        ttl = ttl > 172800 ? 172800 : ttl;
        settings.putIntWithNoFlush(CONFIG_TTL, ttl);
        settings.putLongWithNoFlush(CONFIG_LASTFETCHTIME, this.nanoTime());
        settings.putIntWithNoFlush(CONFIG_VERSION_NAME, 1);
        settings.flush();
        Log.d(LOG_TAG, "Configuration fetched and saved.");
        this.onFetchSuccess();
    }

    private void writeSettingFromConfigOption(ConfigOption configOption, JSONObject json) throws Exception {
        if (configOption.getDataType().equals(String.class)) {
            String value = json.getString(configOption.getResponseKey());
            if (!configOption.getAllowEmpty() && Utils.isNullOrWhiteSpace(value)) {
                throw new IllegalArgumentException("The configuration value must not be empty or contain only white spaces.");
            }
            Settings.getInstance().putStringWithNoFlush(configOption.getSettingsName(), value);
        } else if (configOption.getDataType().equals(Boolean.class)) {
            boolean value = json.getBoolean(configOption.getResponseKey());
            Settings.getInstance().putBooleanWithNoFlush(configOption.getSettingsName(), value);
        } else {
            throw new IllegalArgumentException("Undefined configuration option type.");
        }
    }

    protected WebRequest createWebRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        WebRequest request = WebRequest.createJSONGetWebRequest();
        request.setExternalLogTag(LOG_TAG);
        request.enableLogUrl(true);
        request.setHost(DebugProperties.getDebugPropertyAsString("debug.aaxConfigHostname", AAX_PROD_US_HOSTNAME));
        request.setPath(AAX_MSDK_CONFIG_ENDPOINT);
        request.setMetricsCollector(Metrics.getInstance().getMetricsCollector());
        request.setServiceCallLatencyMetric(Metrics.MetricType.AAX_CONFIG_DOWNLOAD_LATENCY);
        request.setUseSecure(DebugProperties.getDebugPropertyAsBoolean("debug.aaxConfigUseSecure", true));
        RegistrationInfo registrationInfo = InternalAdRegistration.getInstance().getRegistrationInfo();
        DeviceInfo deviceInfo = InternalAdRegistration.getInstance().getDeviceInfo();
        request.putUnencodedQueryParameter("appId", registrationInfo.getAppKey());
        request.putUnencodedQueryParameter("dinfo", deviceInfo.getDInfoProperty().toString());
        request.putUnencodedQueryParameter("adId", advertisingIdentifierInfo.getSISDeviceIdentifier());
        request.putUnencodedQueryParameter("sdkVer", Version.getSDKVersion());
        request.putUnencodedQueryParameter("fp", Boolean.toString(this.isFirstParty));
        request.putUnencodedQueryParameter("mkt", Settings.getInstance().getString(CONFIG_APP_DEFINED_MARKETPLACE, null));
        request.putUnencodedQueryParameter("pfm", this.getPreferredMarketplace());
        boolean testingEnabled = Settings.getInstance().getBoolean("testingEnabled", false);
        this.setLastTestModeValue(testingEnabled);
        if (testingEnabled) {
            request.putUnencodedQueryParameter("testMode", "true");
        }
        request.setAdditionalQueryParamsString(DebugProperties.getDebugPropertyAsString("debug.aaxConfigParams", null));
        return request;
    }

    AdvertisingIdentifier.Info createAdvertisingIdentifierInfo() {
        AdvertisingIdentifier advertisingIdentifier = new AdvertisingIdentifier().setShouldSetCurrentAdvertisingIdentifier(Settings.getInstance().getInt(CONFIG_VERSION_NAME, 0) != 0);
        return advertisingIdentifier.getAdvertisingIdentifierInfo();
    }

    public void setPreferredMarketplaceRetriever(PreferredMarketplaceRetriever pfmRetriever) {
        this.pfmRetriever = pfmRetriever;
    }

    PreferredMarketplaceRetriever getPreferredMarketplaceRetriever() {
        return this.pfmRetriever;
    }

    private String getPreferredMarketplace() {
        return this.pfmRetriever.retrievePreferredMarketplace();
    }

    static interface ConfigurationListener {
        public void onConfigurationReady();

        public void onConfigurationFailure();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FeatureConfigOption
    extends ConfigOption {
        public static final FeatureConfigOption USE_GPS_ADVERTISING_ID = new FeatureConfigOption("config-useGPSAID", Boolean.class, "featureUseGPSAID", "debug.fUseGPSAID");
        public static final FeatureConfigOption[] featureConfigOptions = new FeatureConfigOption[]{USE_GPS_ADVERTISING_ID};

        protected FeatureConfigOption(String settingsName, Class<?> dataType, String responseKey, String debugProperty) {
            super(settingsName, dataType, responseKey, debugProperty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigOption {
        public static final ConfigOption AAX_HOSTNAME = new ConfigOption("config-aaxHostname", String.class, "aaxHostname", "debug.aaxHostname");
        public static final ConfigOption SIS_URL = new ConfigOption("config-sisURL", String.class, "sisURL", "debug.sisURL");
        public static final ConfigOption AD_PREF_URL = new ConfigOption("config-adPrefURL", String.class, "adPrefURL", "debug.adPrefURL");
        public static final ConfigOption MADS_HOSTNAME = new ConfigOption("config-madsHostname", String.class, "madsHostname", "debug.madsHostname", true);
        public static final ConfigOption SIS_DOMAIN = new ConfigOption("config-sisDomain", String.class, "sisDomain", "debug.sisDomain");
        public static final ConfigOption SEND_GEO = new ConfigOption("config-sendGeo", Boolean.class, "sendGeo", "debug.sendGeo");
        public static final ConfigOption[] configOptions = new ConfigOption[]{AAX_HOSTNAME, SIS_URL, AD_PREF_URL, MADS_HOSTNAME, SIS_DOMAIN, SEND_GEO};
        private final String settingsName;
        private final String responseKey;
        private final Class<?> dataType;
        private final String debugProperty;
        private final boolean allowEmpty;

        protected ConfigOption(String settingsName, Class<?> dataType, String responseKey, String debugProperty) {
            this(settingsName, dataType, responseKey, debugProperty, false);
        }

        protected ConfigOption(String settingsName, Class<?> dataType, String responseKey, String debugProperty, boolean allowEmpty) {
            this.settingsName = settingsName;
            this.responseKey = responseKey;
            this.dataType = dataType;
            this.debugProperty = debugProperty;
            this.allowEmpty = allowEmpty;
        }

        String getSettingsName() {
            return this.settingsName;
        }

        String getResponseKey() {
            return this.responseKey;
        }

        Class<?> getDataType() {
            return this.dataType;
        }

        String getDebugProperty() {
            return this.debugProperty;
        }

        boolean getAllowEmpty() {
            return this.allowEmpty;
        }
    }
}

