/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.amazon.device.ads.JSONUtils;
import org.json.JSONObject;

class AppInfo {
    private String packageName;
    private String applicationLabel;
    private String versionCode;
    private String versionName;
    private JSONObject packageInfoUrlJSON;

    public AppInfo(Context context) {
        this.packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        this.applicationLabel = (String)packageManager.getApplicationLabel(applicationInfo);
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        this.versionName = packageInfo != null ? packageInfo.versionName : "";
        this.versionCode = packageInfo != null ? Integer.toString(packageInfo.versionCode) : "";
        this.packageInfoUrlJSON = new JSONObject();
        JSONUtils.put(this.packageInfoUrlJSON, "lbl", this.applicationLabel);
        JSONUtils.put(this.packageInfoUrlJSON, "pn", this.packageName);
        JSONUtils.put(this.packageInfoUrlJSON, "v", this.versionCode);
        JSONUtils.put(this.packageInfoUrlJSON, "vn", this.versionName);
    }

    protected AppInfo() {
    }

    public JSONObject getPackageInfoJSON() {
        return this.packageInfoUrlJSON;
    }

    public String getPackageInfoJSONString() {
        if (this.packageInfoUrlJSON != null) {
            return this.packageInfoUrlJSON.toString();
        }
        return null;
    }
}

