/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AppEvent;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.ThreadUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AppEventRegistrationHandler {
    private static final String LOG_TAG = AppEventRegistrationHandler.class.getSimpleName();
    protected static final String APP_EVENTS_FILE = "AppEventsJsonFile";
    protected static final String APP_EVENT_NAME_KEY = "evtName";
    protected static final String APP_EVENT_TIMESTAMP_KEY = "ts";
    protected static final long APP_EVENTS_FILE_MAX_SIZE = 0x100000L;
    protected final Object appEventsFileLock = new Object();
    protected final Set<String> newEventsToSave = Collections.synchronizedSet(new HashSet());
    protected final Set<String> eventsSent = Collections.synchronizedSet(new HashSet());
    protected static AppEventRegistrationHandler instance = new AppEventRegistrationHandler();

    protected AppEventRegistrationHandler() {
    }

    public static AppEventRegistrationHandler getInstance() {
        return instance;
    }

    public void addEventToAppEventsCacheFile(final AppEvent appEvent) {
        ThreadUtils.executeRunnable(new Runnable(){

            public void run() {
                AppEventRegistrationHandler.this.appendAppEventToFile(appEvent);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendAppEventToFile(AppEvent appEvent) {
        Context appContext = InternalAdRegistration.getInstance().getApplicationContext();
        if (appContext == null) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        try {
            jsonEvent.put(APP_EVENT_NAME_KEY, (Object)appEvent.getEventName());
            jsonEvent.put(APP_EVENT_TIMESTAMP_KEY, appEvent.getTimestamp());
            for (Map.Entry<String, String> prop : appEvent.getPropertyEntries()) {
                jsonEvent.put(prop.getKey(), (Object)prop.getValue());
            }
        }
        catch (JSONException e) {
            Log.w(LOG_TAG, "Internal error while persisting the application event %s.", appEvent.toString());
            return;
        }
        this.newEventsToSave.add(jsonEvent.toString());
        Object object = this.appEventsFileLock;
        synchronized (object) {
            String toAppend = jsonEvent.toString() + "\n";
            File file = new File(appContext.getFilesDir(), APP_EVENTS_FILE);
            if (file.length() + (long)toAppend.length() > 0x100000L) {
                Log.w(LOG_TAG, "Couldn't write the application event %s to the cache file. Maximum size limit reached.", appEvent.toString());
                return;
            }
            FileOutputStream fos = null;
            OutputStreamWriter writer = null;
            try {
                fos = new FileOutputStream(file, true);
                writer = new OutputStreamWriter(fos);
                writer.write(toAppend);
                Log.d(LOG_TAG, "Added the application event %s to the cache file.", appEvent.toString());
            }
            catch (IOException e) {
                Log.w(LOG_TAG, "Couldn't write the application event %s to the file.", appEvent.toString());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    Log.w(LOG_TAG, "Problem while closing application events file.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getAppEventsJSONArray() {
        Context appContext = InternalAdRegistration.getInstance().getApplicationContext();
        if (appContext == null) {
            return null;
        }
        Object object = this.appEventsFileLock;
        synchronized (object) {
            File file = new File(appContext.getFilesDir(), APP_EVENTS_FILE);
            if (!file.exists()) {
                return null;
            }
            JSONArray jsonArray = null;
            FileInputStream fin = null;
            BufferedReader reader = null;
            try {
                fin = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader(fin));
                String jsonEventString = null;
                while ((jsonEventString = reader.readLine()) != null) {
                    JSONObject jsonEventObject = JSONUtils.getJSONObjectFromString(jsonEventString);
                    if (jsonEventObject == null) {
                        this.onAppEventsRegistered();
                        jsonArray = null;
                        break;
                    }
                    if (jsonArray == null) {
                        jsonArray = new JSONArray();
                    }
                    jsonArray.put((Object)jsonEventObject);
                    this.eventsSent.add(jsonEventObject.toString());
                }
            }
            catch (IOException e) {
                Log.w(LOG_TAG, "Problem while reading the application events file.");
                jsonArray = null;
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e1) {
                    Log.w(LOG_TAG, "Problem while closing the application events file.");
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Log.w(LOG_TAG, "Problem while closing the application events file.");
                }
            }
            return jsonArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppEventsRegistered() {
        Context appContext = InternalAdRegistration.getInstance().getApplicationContext();
        if (appContext == null) {
            return;
        }
        Object object = this.appEventsFileLock;
        synchronized (object) {
            this.newEventsToSave.removeAll(this.eventsSent);
            if (!this.newEventsToSave.isEmpty()) {
                StringBuilder toWrite = new StringBuilder();
                Set<String> set = this.newEventsToSave;
                synchronized (set) {
                    for (String newEvent : this.newEventsToSave) {
                        toWrite.append(newEvent).append("\n");
                    }
                }
                File file = new File(appContext.getFilesDir(), APP_EVENTS_FILE);
                FileOutputStream fos = null;
                BufferedWriter writer = null;
                try {
                    fos = new FileOutputStream(file, false);
                    writer = new BufferedWriter(new OutputStreamWriter(fos));
                    writer.write(toWrite.toString());
                    this.newEventsToSave.clear();
                    this.eventsSent.clear();
                }
                catch (IOException e) {
                    Log.w(LOG_TAG, "Couldn't write the application event(s) to the file.");
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        Log.w(LOG_TAG, "Problem while closing application events file.");
                    }
                }
            } else {
                appContext.deleteFile(APP_EVENTS_FILE);
                this.eventsSent.clear();
            }
        }
    }
}

