/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.view.Display;
import android.view.View;
import android.webkit.WebView;
import android.widget.ImageButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndroidTargetUtils {
    private AndroidTargetUtils() {
    }

    public static boolean isAtLeastAndroidAPI(int api) {
        return Build.VERSION.SDK_INT >= api;
    }

    public static BitmapDrawable getNewBitmapDrawable(Resources r, String f) {
        if (AndroidTargetUtils.isAtLeastAndroidAPI(5)) {
            return EclairTargetUtils.getNewBitmapDrawable(r, f);
        }
        return new BitmapDrawable(f);
    }

    public static boolean isInstanceOfSQLiteDatabaseLockedException(SQLiteException e) {
        return HoneycombTargetUtils.isInstanceOfSQLiteDatabaseLockedException(e);
    }

    public static final void disableHardwareAcceleration(View view) {
        HoneycombTargetUtils.disableHardwareAcceleration(view);
    }

    public static String getPackageCodePath(Context context) {
        return FroyoTargetUtils.getPackageCodePath(context);
    }

    public static void webViewOnPause(WebView webView) {
        HoneycombTargetUtils.webViewOnPause(webView);
    }

    public static void webViewOnResume(WebView webView) {
        HoneycombTargetUtils.webViewOnResume(webView);
    }

    public static void editorApply(SharedPreferences.Editor editor) {
        GingerbreadTargetUtils.editorApply(editor);
    }

    public static void setImageButtonAlpha(ImageButton imageButton, int alpha) {
        if (AndroidTargetUtils.isAtLeastAndroidAPI(16)) {
            JellyBeanTargetUtils.setImageButtonAlpha(imageButton, alpha);
        } else {
            imageButton.setAlpha(alpha);
        }
    }

    public static void setBackgroundDrawable(View view, Drawable drawable) {
        if (AndroidTargetUtils.isAtLeastAndroidAPI(16)) {
            JellyBeanTargetUtils.setBackgroundForLinerLayout(view, drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static int getOrientation(Display display) {
        if (AndroidTargetUtils.isAtLeastAndroidAPI(8)) {
            return FroyoTargetUtils.getRotation(display);
        }
        return display.getOrientation();
    }

    public static <T> void executeAsyncTask(AsyncTask<T, ?, ?> task, T ... params) {
        if (Build.VERSION.SDK_INT >= 11) {
            HoneycombTargetUtils.executeAsyncTaskWithThreadPooling(task, params);
        } else {
            task.execute((Object[])params);
        }
    }

    public static void hideActionAndStatusBars(Activity activity) {
        HoneycombTargetUtils.hideActionAndStatusBars(activity);
    }

    @TargetApi(value=16)
    private static class JellyBeanTargetUtils {
        private JellyBeanTargetUtils() {
        }

        public static void setBackgroundForLinerLayout(View view, Drawable background) {
            view.setBackground(background);
        }

        protected static void setImageButtonAlpha(ImageButton imageButton, int alpha) {
            imageButton.setImageAlpha(alpha);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TargetApi(value=11)
    private static class HoneycombTargetUtils {
        private HoneycombTargetUtils() {
        }

        public static boolean isInstanceOfSQLiteDatabaseLockedException(SQLiteException e) {
            return e instanceof SQLiteDatabaseLockedException;
        }

        public static final void disableHardwareAcceleration(View view) {
            view.setLayerType(1, null);
        }

        protected static final <T> void executeAsyncTaskWithThreadPooling(AsyncTask<T, ?, ?> task, T ... params) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])params);
        }

        protected static void webViewOnPause(WebView webView) {
            webView.onPause();
        }

        protected static void webViewOnResume(WebView webView) {
            webView.onResume();
        }

        protected static void hideActionAndStatusBars(Activity activity) {
            ActionBar actionBar = activity.getActionBar();
            if (actionBar != null) {
                actionBar.hide();
            }
            View decorView = activity.getWindow().getDecorView();
            decorView.setSystemUiVisibility(4);
        }
    }

    @TargetApi(value=9)
    private static class GingerbreadTargetUtils {
        private GingerbreadTargetUtils() {
        }

        protected static void editorApply(SharedPreferences.Editor editor) {
            editor.apply();
        }
    }

    @TargetApi(value=8)
    private static class FroyoTargetUtils {
        private FroyoTargetUtils() {
        }

        protected static String getPackageCodePath(Context context) {
            return context.getPackageCodePath();
        }

        protected static int getRotation(Display display) {
            return display.getRotation();
        }
    }

    @TargetApi(value=5)
    private static class EclairTargetUtils {
        private EclairTargetUtils() {
        }

        protected static BitmapDrawable getNewBitmapDrawable(Resources r, String f) {
            return new BitmapDrawable(r, f);
        }
    }
}

