/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.GooglePlayServices;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Utils;

class AdvertisingIdentifier {
    private static final String LOG_TAG = AdvertisingIdentifier.class.getSimpleName();
    private static final String GPS_ADVERTISING_IDENTIFIER_SETTING = "gpsAdId";
    private static final String TRANSITION_SETTING = "adIdTransistion";
    private static final String TRANSITION_MIGRATE = "migrate";
    private static final String TRANSITION_RESET = "reset";
    private static final String TRANSITION_REVERT = "revert";
    private GooglePlayServices.AdvertisingInfo gpsAdvertisingInfo;
    private boolean shouldSetCurrentAdvertisingIdentifier = true;

    AdvertisingIdentifier() {
    }

    static String getAndClearTransition() {
        Settings settings = Settings.getInstance();
        String transition = settings.getString(TRANSITION_SETTING, null);
        settings.remove(TRANSITION_SETTING);
        return transition;
    }

    AdvertisingIdentifier setShouldSetCurrentAdvertisingIdentifier(boolean shouldSetCurrentAdvertisingIdentifier) {
        this.shouldSetCurrentAdvertisingIdentifier = shouldSetCurrentAdvertisingIdentifier;
        return this;
    }

    Info getAdvertisingIdentifierInfo() {
        if (ThreadUtils.isOnMainThread()) {
            Log.e(LOG_TAG, "You must obtain the advertising indentifier information on a background thread.");
            return new Info().setCanDo(false);
        }
        this.fetchGooglePlayServicesAdvertisingIdentifierInfo();
        if (this.shouldSetCurrentAdvertisingIdentifier) {
            this.determineTransition();
        }
        Info info = new Info();
        if (this.getGPSAdvertisingInfo().hasAdvertisingIdentifier()) {
            info.setAdvertisingIdentifier(this.getGPSAdvertisingInfo().getAdvertisingIdentifier());
            info.setLimitAdTrackingEnabled(this.getGPSAdvertisingInfo().isLimitAdTrackingEnabled());
            if (this.shouldSetCurrentAdvertisingIdentifier) {
                AdvertisingIdentifier.setCurrentGPSAID(this.getGPSAdvertisingInfo().getAdvertisingIdentifier());
            }
        }
        RegistrationInfo registrationInfo = InternalAdRegistration.getInstance().getRegistrationInfo();
        if (RegistrationInfo.isAdIdCurrent(info)) {
            info.setSISDeviceIdentifier(registrationInfo.getAdId());
        } else {
            registrationInfo.requestNewSISDeviceIdentifier();
        }
        return info;
    }

    private void determineTransition() {
        String transition = null;
        if (this.isTransitionMigrated()) {
            transition = TRANSITION_MIGRATE;
        } else if (this.isTransitionReset()) {
            transition = TRANSITION_RESET;
        } else if (this.isTransitionReverted()) {
            transition = TRANSITION_REVERT;
        }
        if (transition != null) {
            AdvertisingIdentifier.setTransition(transition);
        } else {
            Log.d(LOG_TAG, "No transition detected.");
        }
    }

    private static void setTransition(String transition) {
        Log.d(LOG_TAG, "Transition: %s", transition);
        Settings.getInstance().putString(TRANSITION_SETTING, transition);
    }

    protected void fetchGooglePlayServicesAdvertisingIdentifierInfo() {
        GooglePlayServices gps = new GooglePlayServices();
        this.gpsAdvertisingInfo = gps.getAdvertisingIdentifierInfo();
    }

    protected GooglePlayServices.AdvertisingInfo getGPSAdvertisingInfo() {
        return this.gpsAdvertisingInfo;
    }

    private boolean isTransitionMigrated() {
        RegistrationInfo registrationInfo = InternalAdRegistration.getInstance().getRegistrationInfo();
        return registrationInfo.hasAdId() && RegistrationInfo.isAdIdOriginatedFromNonAdvertisingIdentifier() && !this.hasCurrentGPSAID() && this.getGPSAdvertisingInfo().hasAdvertisingIdentifier();
    }

    private boolean isTransitionReset() {
        return this.hasCurrentGPSAID() && this.getGPSAdvertisingInfo().hasAdvertisingIdentifier() && !AdvertisingIdentifier.getCurrentGPSAID().equals(this.getGPSAdvertisingInfo().getAdvertisingIdentifier());
    }

    private boolean isTransitionReverted() {
        return this.hasCurrentGPSAID() && !this.getGPSAdvertisingInfo().hasAdvertisingIdentifier();
    }

    private static void setCurrentGPSAID(String gpsaid) {
        Settings.getInstance().putString(GPS_ADVERTISING_IDENTIFIER_SETTING, gpsaid);
    }

    private static String getCurrentGPSAID() {
        return Settings.getInstance().getString(GPS_ADVERTISING_IDENTIFIER_SETTING, "");
    }

    private boolean hasCurrentGPSAID() {
        return !Utils.isNullOrEmpty(AdvertisingIdentifier.getCurrentGPSAID());
    }

    static class Info {
        private boolean canDo = true;
        private String advertisingIdentifier;
        private boolean limitAdTrackingEnabled;
        private String sisDeviceIdentifier;

        Info() {
        }

        boolean canDo() {
            return this.canDo;
        }

        private Info setCanDo(boolean canDo) {
            this.canDo = canDo;
            return this;
        }

        String getAdvertisingIdentifier() {
            return DebugProperties.getDebugPropertyAsString("debug.idfa", this.advertisingIdentifier);
        }

        private Info setAdvertisingIdentifier(String advertisingIdentifier) {
            this.advertisingIdentifier = advertisingIdentifier;
            return this;
        }

        boolean hasAdvertisingIdentifier() {
            return !Utils.isNullOrEmpty(this.getAdvertisingIdentifier());
        }

        boolean isLimitAdTrackingEnabled() {
            return DebugProperties.getDebugPropertyAsBoolean("debug.optOut", this.limitAdTrackingEnabled);
        }

        private Info setLimitAdTrackingEnabled(boolean limitAdTrackingEnabled) {
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            return this;
        }

        String getSISDeviceIdentifier() {
            return DebugProperties.getDebugPropertyAsString("debug.adid", this.sisDeviceIdentifier);
        }

        boolean hasSISDeviceIdentifier() {
            return this.getSISDeviceIdentifier() != null;
        }

        private Info setSISDeviceIdentifier(String sisDeviceIdentifier) {
            this.sisDeviceIdentifier = sisDeviceIdentifier;
            return this;
        }
    }
}

