/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.MediaController;
import android.widget.VideoView;
import com.amazon.device.ads.Controller;
import com.amazon.device.ads.Log;

final class AdVideoPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static String LOG_TAG = "AdVideoPlayer";
    private Controller.PlayerProperties playerProperties_;
    private AudioManager audioManager_;
    private AdVideoPlayerListener listener_;
    private String contentUrl_;
    private int volumeBeforeMuting_;
    private boolean released_ = false;
    private Context context_;
    private VideoView videoView_ = null;
    private ViewGroup.LayoutParams layoutParams_ = null;
    private ViewGroup viewGroup_ = null;

    public AdVideoPlayer(Context context) {
        this.context_ = context;
        this.playerProperties_ = new Controller.PlayerProperties();
        this.audioManager_ = (AudioManager)this.context_.getSystemService("audio");
    }

    public void setPlayData(Controller.PlayerProperties properties, String url) {
        this.released_ = false;
        if (properties != null) {
            this.playerProperties_ = properties;
        }
        this.contentUrl_ = url;
    }

    public void setListener(AdVideoPlayerListener listener) {
        this.listener_ = listener;
    }

    public void playVideo() {
        Log.d(LOG_TAG, "in playVideo");
        if (this.playerProperties_.doMute()) {
            this.mutePlayer();
        }
        this.initializeVideoView();
        this.loadPlayerContent();
        this.startPlaying();
    }

    public void playAudio() {
        Log.d(LOG_TAG, "in playAudio");
        this.loadPlayerContent();
    }

    public void mutePlayer() {
        Log.d(LOG_TAG, "in mutePlayer");
        this.volumeBeforeMuting_ = this.audioManager_.getStreamVolume(3);
        this.audioManager_.setStreamVolume(3, 0, 4);
    }

    public void unmutePlayer() {
        Log.d(LOG_TAG, "in unmutePlayer");
        this.audioManager_.setStreamVolume(3, this.volumeBeforeMuting_, 4);
    }

    private void initializeVideoView() {
        VideoView videoView = new VideoView(this.context_);
        videoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        videoView.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        videoView.setLayoutParams(this.layoutParams_);
        this.videoView_ = videoView;
        this.viewGroup_.addView((View)this.videoView_);
    }

    private void loadPlayerContent() {
        Uri uri = Uri.parse((String)this.contentUrl_);
        this.videoView_.setVideoURI(uri);
    }

    public void startPlaying() {
        Log.d(LOG_TAG, "in startPlaying");
        this.displayPlayerControls();
        if (this.playerProperties_.isAutoPlay()) {
            this.videoView_.start();
        }
    }

    private void displayPlayerControls() {
        Log.d(LOG_TAG, "in displayPlayerControls");
        if (this.playerProperties_.showControl()) {
            MediaController controller = new MediaController(this.context_);
            this.videoView_.setMediaController(controller);
            controller.setAnchorView((View)this.videoView_);
            controller.requestFocus();
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.removePlayerFromParent();
        if (this.listener_ != null) {
            this.listener_.onError();
        }
        return false;
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.playerProperties_.doLoop()) {
            this.videoView_.start();
        } else if (this.playerProperties_.exitOnComplete() || this.playerProperties_.inline) {
            this.releasePlayer();
            if (this.listener_ != null) {
                this.listener_.onComplete();
            }
        }
    }

    private void removePlayerFromParent() {
        Log.d(LOG_TAG, "in removePlayerFromParent");
        this.viewGroup_.removeView((View)this.videoView_);
    }

    public void releasePlayer() {
        Log.d(LOG_TAG, "in releasePlayer");
        if (this.released_) {
            return;
        }
        this.released_ = true;
        this.videoView_.stopPlayback();
        this.removePlayerFromParent();
        if (this.playerProperties_.doMute()) {
            this.unmutePlayer();
        }
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.layoutParams_ = layoutParams;
    }

    public void setViewGroup(ViewGroup viewGroup) {
        this.viewGroup_ = viewGroup;
    }

    public static interface AdVideoPlayerListener {
        public void onComplete();

        public void onError();
    }
}

