/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.Utils;
import java.util.HashSet;

class AdUtils {
    public static final String LOG_TAG = AdUtils.class.getSimpleName();
    private static final HashSet<String> requiredActivities = new HashSet();
    public static final String REQUIRED_ACTIVITY = "com.amazon.device.ads.AdActivity";

    private AdUtils() {
    }

    public static boolean launchActivityForIntentLink(String url, Context context) {
        if (url == null || url.equals("")) {
            url = "about:blank";
        }
        Log.d(LOG_TAG, "Launch Intent: %s", url);
        Intent actionIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        actionIntent.setFlags(0x10000000);
        try {
            context.startActivity(actionIntent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            String action = actionIntent.getAction();
            Log.w(LOG_TAG, "Could not handle %s action: %s", action.startsWith("market://") ? "market" : "intent", action);
            return false;
        }
    }

    public static String encloseHtml(String html, boolean isHTML5) {
        if (html != null) {
            if (html.indexOf("<html>") == -1) {
                html = "<html>" + html + "</html>";
            }
            if (isHTML5 && html.indexOf("<!DOCTYPE html>") == -1) {
                html = "<!DOCTYPE html>" + html;
            }
        }
        return html;
    }

    public static boolean checkDefinedActivities(Context context) {
        HashSet<String> activities = new HashSet<String>();
        try {
            if (Utils.isAtLeastAndroidAPI(8)) {
                String path = AndroidTargetUtils.getPackageCodePath(context);
                PackageManager pManager = context.getPackageManager();
                PackageInfo info = pManager.getPackageArchiveInfo(path, 1);
                for (ActivityInfo a : info.activities) {
                    activities.add(a.name);
                }
                return activities.containsAll(requiredActivities);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void setConnectionMetrics(AdData adData) {
        String connectionType = adData.getConnectionType();
        if ("Wifi".equals(connectionType)) {
            adData.getMetricsCollector().incrementMetric(Metrics.MetricType.WIFI_PRESENT);
        } else {
            adData.getMetricsCollector().setMetricString(Metrics.MetricType.CONNECTION_TYPE, connectionType);
        }
        DeviceInfo deviceInfo = InternalAdRegistration.getInstance().getDeviceInfo();
        if (deviceInfo.getCarrier() != null) {
            adData.getMetricsCollector().setMetricString(Metrics.MetricType.CARRIER_NAME, deviceInfo.getCarrier());
        }
    }

    public static double getViewportInitialScale(double defaultScale) {
        return Utils.isAtLeastAndroidAPI(19) ? 1.0 : defaultScale;
    }

    static {
        requiredActivities.add(REQUIRED_ACTIVITY);
    }
}

