/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdLayout;
import com.amazon.device.ads.AdLayoutWrapper;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdWrapper;
import com.amazon.device.ads.IAdLoaderCallback;
import com.amazon.device.ads.InterstitialAd;
import com.amazon.device.ads.InterstitialAdWrapper;

class AdSlot {
    private int slotNumber;
    private final AdWrapper adWrapper;
    private final AdTargetingOptions adOptions;
    private AdError adError;

    public AdSlot(Ad ad, AdTargetingOptions adOptions) {
        this(AdSlot.createAdWrapper(ad), adOptions);
    }

    AdSlot(AdWrapper adWrapper, AdTargetingOptions adOptions) {
        this.adWrapper = adWrapper;
        this.adOptions = adOptions == null ? new AdTargetingOptions() : adOptions;
    }

    public Ad getAd() {
        return this.adWrapper.getAd();
    }

    public AdTargetingOptions getAdTargetingOptions() {
        return this.adOptions;
    }

    void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    int getSlotNumber() {
        return this.slotNumber;
    }

    void setAdError(AdError adError) {
        this.adError = adError;
    }

    AdError getAdError() {
        return this.adError;
    }

    AdWrapper getAdWrapper() {
        return this.adWrapper;
    }

    AdData getAdData() {
        return this.adWrapper.getAdData();
    }

    IAdLoaderCallback getAdLoaderCallback() {
        return this.adWrapper.getAdLoaderCallback();
    }

    static AdWrapper createAdWrapper(Ad ad) {
        if (ad instanceof AdLayout) {
            return new AdLayoutWrapper((AdLayout)ad);
        }
        if (ad instanceof InterstitialAd) {
            return new InterstitialAdWrapper((InterstitialAd)ad);
        }
        return null;
    }
}

