/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Log;
import com.amazon.device.ads.Utils;
import java.util.Locale;

public class AdSize {
    private static final String LOG_TAG = "AdSize";
    public static final AdSize SIZE_300x50 = new AdSize(300, 50);
    public static final AdSize SIZE_320x50 = new AdSize(320, 50);
    public static final AdSize SIZE_300x250 = new AdSize(300, 250);
    public static final AdSize SIZE_600x90 = new AdSize(600, 90);
    public static final AdSize SIZE_728x90 = new AdSize(728, 90);
    public static final AdSize SIZE_1024x50 = new AdSize(1024, 50);
    public static final AdSize SIZE_AUTO = new AdSize(SizeType.AUTO);
    static final AdSize SIZE_INTERSTITIAL = new AdSize(SizeType.INTERSTITIAL);
    private int width;
    private int height;
    private SizeType type;

    public AdSize(int width, int height) {
        this.initialize(width, height);
    }

    AdSize(String width, String height) {
        int parsedWidth = Utils.parseInt(width, 0);
        int parsedHeight = Utils.parseInt(height, 0);
        this.initialize(parsedWidth, parsedHeight);
    }

    AdSize(SizeType type) {
        this.type = type;
    }

    private void initialize(int width, int height) {
        if (width <= 0 || height <= 0) {
            String msg = "The width and height must be positive integers.";
            Log.e(LOG_TAG, msg);
            throw new IllegalArgumentException(msg);
        }
        this.width = width;
        this.height = height;
        this.type = SizeType.EXPLICIT;
    }

    public String toString() {
        String sizeString = null;
        switch (this.type) {
            case EXPLICIT: {
                sizeString = String.format(Locale.US, "%dx%d", this.width, this.height);
                break;
            }
            case AUTO: {
                sizeString = "auto";
                break;
            }
            case INTERSTITIAL: {
                sizeString = "interstitial";
            }
        }
        return sizeString;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isAuto() {
        return this.type == SizeType.AUTO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SizeType {
        EXPLICIT,
        AUTO,
        INTERSTITIAL;

    }
}

