/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdView;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.IAdController;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AdRenderer
implements AdView {
    private static final String LOG_TAG = "AdRenderer";
    protected static final String AAX_REDIRECT_PROD = "aax-us-east.amazon-adsystem.com";
    protected static final String AAX_REDIRECT_GAMMA = "aax-us-east.amazon-adsystem.com";
    protected static final String AAX_REDIRECT_BETA = "aax-beta.integ.amazon.com";
    protected static final String CORNERSTONE_BEST_ENDPOINT_PROD = "pda-bes.amazon.com";
    protected static final String CORNERSTONE_BEST_ENDPOINT_BETA = "d16g-cornerstone-bes.integ.amazon.com";
    protected final IAdController controller;
    protected final Context context;
    protected AdData adData;
    protected boolean viewRemoved = false;
    protected boolean isDestroyed = false;
    protected boolean isInitialized = false;
    private double scalingMultiplier = 1.0;

    protected AdRenderer(AdData ad, IAdController controller, Context context) {
        this.adData = ad;
        this.controller = controller;
        this.context = context;
    }

    public void initialize() {
        this.scalingMultiplier = AdRenderer.determineScalingMultiplier(this.adData, this.controller);
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected static double determineScalingMultiplier(AdData adData, IAdController controller) {
        float scalingDensity = InternalAdRegistration.getInstance().getDeviceInfo().getScalingFactorAsFloat();
        int adWidth = (int)((float)adData.getWidth() * scalingDensity);
        int adHeight = (int)((float)adData.getHeight() * scalingDensity);
        double scalingMultiplier = AdRenderer.calculateScalingMultiplier(adWidth, adHeight, controller.getWindowWidth(), controller.getWindowHeight());
        Log.d(LOG_TAG, "Scaling Params: scalingDensity: %f, windowWidth: %d, windowHeight: %d, adWidth: %d, adHeight: %d, scale: %f", Float.valueOf(scalingDensity), controller.getWindowWidth(), controller.getWindowHeight(), adWidth, adHeight, scalingMultiplier);
        return scalingMultiplier;
    }

    protected static double calculateScalingMultiplier(int absoluteAdWidth, int absoluteAdHeight, int absoluteWindowWidth, int absoluteWindowHeight) {
        double heightRatio = (double)absoluteWindowHeight / (double)absoluteAdHeight;
        double widthRatio = (double)absoluteWindowWidth / (double)absoluteAdWidth;
        double multiplier = (heightRatio < widthRatio || widthRatio == 0.0) && heightRatio != 0.0 ? heightRatio : widthRatio;
        return multiplier == 0.0 ? 1.0 : multiplier;
    }

    protected double getScalingMultiplier() {
        return this.scalingMultiplier;
    }

    public String getScalingMultiplierDescription() {
        if (this.getScalingMultiplier() > 1.0) {
            return "u";
        }
        if (this.getScalingMultiplier() < 1.0 && this.getScalingMultiplier() > 0.0) {
            return "d";
        }
        return "n";
    }

    protected void setAd(AdData ad) {
        this.adData = ad;
    }

    protected boolean isAdViewDestroyed() {
        return !this.isInitialized() || this.isDestroyed;
    }

    protected boolean isAdViewRemoved() {
        return !this.isInitialized() || this.viewRemoved;
    }

    @Override
    public boolean isAdViewRenderable() {
        return this.isInitialized() && !this.isAdViewRemoved() && !this.isAdViewDestroyed();
    }

    protected void adLoaded(AdProperties props) {
        this.controller.adLoaded(props);
    }

    @Override
    public boolean shouldDisableWebViewHardwareAcceleration() {
        return this.controller.shouldDisableWebViewHardwareAcceleration();
    }

    protected abstract boolean getAdState(AdState var1);

    protected abstract boolean render();

    protected abstract void prepareToGoAway();

    protected abstract boolean sendCommand(String var1, Map<String, String> var2);

    protected abstract boolean shouldReuse();

    protected abstract void removeView();

    protected abstract void destroy();

    @Override
    public int getHeight() {
        return this.adData.getHeight();
    }

    @Override
    public AdWebViewClient.UrlExecutor getSpecialUrlExecutor() {
        return this.controller.getSpecialUrlExecutor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AdState {
        EXPANDED;

    }
}

